/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.Rflow;
import com.ef_prime.rflow.core.base.Settings;
import com.ef_prime.rflow.core.common.keyvalue.ValueMap;
import com.ef_prime.rflow.core.common.keyvalue.WidgetNode;
import com.ef_prime.rflow.core.flow.FlowNode;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEvent;
import com.ef_prime.rflow.core.flow.FlowNodeSelectionEventHandler;
import com.ef_prime.rflow.core.node.OpExecutor;
import com.ef_prime.rflow.node.base.SubflowNodeView;
import com.ef_prime.rflow.node.ui.Operation;
import com.ef_prime.rflow.node.ui.UINodeModel;
import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.app.base.Preview;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.SwitchPanel;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.keyvalue.WidgetFactory;
import com.ef_prime.rflow.ui.common.view.View;
import com.ef_prime.rflow.ui.flow.FlowBrowseView;
import com.ef_prime.rflow.ui.flow.FlowViewer;
import com.ef_prime.rflow.ui.view.ActiveViewEvent;
import com.ef_prime.rflow.ui.view.ActiveViewEventHandler;
import com.ef_prime.rflow.ui.view.PreviewRunEvent;
import com.ef_prime.rflow.ui.view.PreviewRunEventHandler;
import edu.uci.ics.jung.graph.Vertex;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLayer;
import javax.swing.plaf.LayerUI;

public class PreviewRunView
extends View
implements PreviewRunEventHandler,
FlowNodeSelectionEventHandler,
ActiveViewEventHandler {
    private SwitchPanel switchPanel;
    private Operation uiModel;
    private FlowNode flowNode;
    private boolean enabled = true;

    public PreviewRunView() {
        this.setTitle(Messages.getString("View.Preview.title"));
        this.setIcon(Icons.getIcon("16/page_white_magnify.png"));
        this.setIconOnly(true);
        this.switchPanel = new SwitchPanel();
        this.add(new JLayer<JComponent>(this.switchPanel, new PreviewLayerUI()), "Center");
    }

    @Override
    protected void viewDidBecomeDisplayable() {
        super.viewDidBecomeDisplayable();
        EventManager.getInstance().registerEventHandler(PreviewRunEvent.class, this);
        EventManager.getInstance().registerEventHandler(FlowNodeSelectionEvent.class, this);
        EventManager.getInstance().registerEventHandler(ActiveViewEvent.class, this);
    }

    @Override
    protected void viewDidBecomeUndisplayable() {
        super.viewDidBecomeUndisplayable();
        EventManager.getInstance().removeEventHandler(PreviewRunEvent.class, this);
        EventManager.getInstance().removeEventHandler(FlowNodeSelectionEvent.class, this);
        EventManager.getInstance().removeEventHandler(ActiveViewEvent.class, this);
    }

    @Override
    public void handlePreviewRunEvent(PreviewRunEvent previewRunEvent) {
        Operation operation = previewRunEvent.getOperation();
        WidgetNode widgetNode = operation.getPreviewWidgetNode();
        if (widgetNode == null) {
            return;
        }
        if (Objects.equals(this.uiModel, operation)) {
            ((Preview)((Object)this.switchPanel.get())).refresh();
        } else {
            this.uiModel = operation;
            this.flowNode = previewRunEvent.getNode();
            OpExecutor opExecutor = new OpExecutor(operation);
            ValueMap valueMap = new ValueMap();
            valueMap.putValue(OpExecutor.PROPERTY_EXECUTOR, opExecutor);
            valueMap.putValue(Preview.AUTO_REFRESH_KEY, Settings.PREVIEW_AUTO_REFRESH);
            widgetNode.setProperties(valueMap);
            Component component = WidgetFactory.getInstance().create(operation, widgetNode);
            if (component instanceof Preview) {
                this.switchPanel.set(component);
                if (!Rflow.settings().getValue(Settings.PREVIEW_AUTO_REFRESH).booleanValue()) {
                    ((Preview)((Object)component)).refresh();
                }
            }
        }
        this.toFront();
        this.enabled(true);
    }

    @Override
    public void flowSelectionChanged(FlowNodeSelectionEvent flowNodeSelectionEvent) {
        UINodeModel uINodeModel;
        Operation operation;
        if (this.uiModel == null || this.flowNode == null) {
            this.enabled(true);
            return;
        }
        FlowNode flowNode = flowNodeSelectionEvent.getState().getSelectedNode();
        if (flowNode != null && flowNode.getModel() instanceof UINodeModel && Objects.equals(this.uiModel, operation = (uINodeModel = (UINodeModel)flowNode.getModel()).getModel())) {
            this.enabled(true);
            return;
        }
        this.enabled(false);
    }

    private void enabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            this.repaint();
        }
    }

    @Override
    public void activeViewChanged(ActiveViewEvent activeViewEvent) {
        FlowBrowseView flowBrowseView;
        if (this.flowNode == null) {
            return;
        }
        View view2 = Rflow.mainView().getView(this.flowNode.getParentNode());
        if (view2 == null) {
            this.enabled(false);
            return;
        }
        if (view2.isShowing() && view2 instanceof FlowBrowseView && (flowBrowseView = (FlowBrowseView)view2).getFlowNodeView() instanceof SubflowNodeView) {
            FlowViewer[] flowViewerArray;
            for (FlowViewer flowViewer : flowViewerArray = ((SubflowNodeView)flowBrowseView.getFlowNodeView()).getViewers()) {
                if (!flowViewer.getPickedState().isPicked((Vertex)this.flowNode)) continue;
                this.enabled(true);
                return;
            }
        }
        this.enabled(false);
    }

    private class PreviewLayerUI
    extends LayerUI<JComponent> {
        private PreviewLayerUI() {
        }

        @Override
        public void paint(Graphics graphics, JComponent jComponent) {
            super.paint(graphics, jComponent);
            if (!PreviewRunView.this.enabled) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setComposite(AlphaComposite.getInstance(10, 0.4f));
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                graphics2D.dispose();
            }
        }
    }
}

