/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.resource.Messages;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.common.component.SwitchPanel;
import com.ef_prime.rflow.ui.common.event.EventManager;
import com.ef_prime.rflow.ui.common.item.Item;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEvent;
import com.ef_prime.rflow.ui.common.item.ItemSelectionEventHandler;
import com.ef_prime.rflow.ui.common.view.View;
import java.awt.BorderLayout;
import java.awt.Component;

public class PreviewView
extends View
implements ItemSelectionEventHandler {
    private SwitchPanel switchPanel;
    private Item reserved;

    public PreviewView() {
        this.setTitle(Messages.getString("View.Preview.title"));
        this.setIcon(Icons.getIcon("16/page_white_magnify.png"));
        this.setLayout(new BorderLayout());
        this.switchPanel = new SwitchPanel();
        this.add((Component)this.switchPanel, "Center");
        EventManager.getInstance().registerEventHandler(ItemSelectionEvent.class, this);
    }

    private void setView(View view2) {
        Component component = this.switchPanel.get();
        if (component instanceof View) {
            View view3 = (View)component;
            view3.unloadView();
        }
        this.updateTabBusy(false);
        this.switchPanel.set(view2);
    }

    private void updatePreview() {
        if (this.isShowing()) {
            this.setView(this.createView(this.reserved));
        }
    }

    private View createView(Item item) {
        if (item == null) {
            return null;
        }
        return item.createPreviewView();
    }

    @Override
    public void itemSelected(ItemSelectionEvent itemSelectionEvent) {
        this.reserved = itemSelectionEvent.getItem();
        this.updatePreview();
    }

    @Override
    protected void viewShown() {
        this.updatePreview();
    }
}

