/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.core.app.file.FileInfos;
import com.ef_prime.rflow.ui.view.BasicFileNode;
import com.ef_prime.rflow.ui.view.FileForSort;
import com.ef_prime.rflow.ui.view.FileNode;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class SelectableFileNode
extends BasicFileNode {
    private Selection selection;
    private Predicate<SelectableFileNode> nodePredicate;
    private List<SelectableFileNode> allChildren = new ArrayList<SelectableFileNode>();

    public SelectableFileNode(File file, boolean bl, Predicate<SelectableFileNode> predicate) {
        super(file, true);
        this.selection = bl ? Selection.SELECTED : Selection.NONE;
        this.nodePredicate = predicate;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public void refreshSelection() {
        this.selection = this.retreiveSelection();
    }

    public boolean hasChildren() {
        return this.isDirectory() && !this.children.isEmpty();
    }

    private Selection retreiveSelection() {
        if (this.isDirectory() && !this.children.isEmpty()) {
            Selection selection = ((SelectableFileNode)this.children.get(0)).getSelection();
            block5: for (int i = 1; i < this.children.size(); ++i) {
                SelectableFileNode selectableFileNode = (SelectableFileNode)this.children.get(i);
                switch (selectableFileNode.getSelection().ordinal()) {
                    case 0: {
                        if (selection == Selection.SELECTED) continue block5;
                        return Selection.MIXED;
                    }
                    case 1: {
                        return Selection.MIXED;
                    }
                    case 2: {
                        if (selection == Selection.NONE) continue block5;
                        return Selection.MIXED;
                    }
                }
            }
            return selection;
        }
        return this.selection;
    }

    public void setSelection(Selection selection) {
        if (selection == Selection.MIXED) {
            selection = Selection.NONE;
        }
        this.selection = selection;
    }

    public List<SelectableFileNode> getAllChildren() {
        return this.allChildren;
    }

    @Override
    public SelectableFileNode getParent() {
        return (SelectableFileNode)super.getParent();
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isDirectory();
    }

    @Override
    public boolean isLeaf() {
        return !this.isDirectory();
    }

    @Override
    public List<FileNode> retrieveChildren() {
        this.info = FileInfos.getInstance().refreshFileInfo(this.file);
        this.updateAttributes();
        this.allChildren.clear();
        if (!this.isDirectory()) {
            return new ArrayList<FileNode>(0);
        }
        List<FileForSort> list = this.getFileChildren(true);
        ArrayList<FileNode> arrayList = new ArrayList<FileNode>(list.size());
        for (FileForSort fileForSort : list) {
            SelectableFileNode selectableFileNode = new SelectableFileNode(fileForSort.getFile(), this.selection == Selection.SELECTED, this.nodePredicate);
            this.allChildren.add(selectableFileNode);
            if (this.nodePredicate.test(selectableFileNode)) {
                arrayList.add(selectableFileNode);
            }
            selectableFileNode.setParent(this);
        }
        return arrayList;
    }

    @Override
    protected boolean watchChildren() {
        return false;
    }

    public static enum Selection {
        SELECTED,
        MIXED,
        NONE;

    }
}

