/*
 * Decompiled with CFR 0.152.
 */
package com.ef_prime.rflow.ui.view;

import com.ef_prime.rflow.core.app.file.ZipFileUtility;
import com.ef_prime.rflow.core.app.file.ZipInfo;
import com.ef_prime.rflow.ui.base.Icons;
import com.ef_prime.rflow.ui.view.BasicFileNode;
import com.ef_prime.rflow.ui.view.FileForSort;
import com.ef_prime.rflow.ui.view.FileNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;

public class ZipFileNode
extends BasicFileNode {
    private File zipFile;
    private String inZipPath;
    private boolean isDirectory;

    public ZipFileNode(File file, File file2, String string) {
        super(file);
        this.zipFile = file2;
        this.inZipPath = string;
        this.isDirectory = string.endsWith("/");
    }

    @Override
    public boolean getAllowsChildren() {
        return this.isDirectory;
    }

    @Override
    public boolean isLeaf() {
        return !this.isDirectory;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isFileValid() {
        return true;
    }

    @Override
    public Icon getIcon() {
        if (this.isDirectory) {
            return Icons.getIcon("16/folder.png");
        }
        return super.getIcon();
    }

    @Override
    public List<FileNode> retrieveChildren() {
        Object object;
        block12: {
            if (!this.getAllowsChildren()) {
                return new ArrayList<FileNode>(0);
            }
            String string = this.inZipPath;
            ZipFile zipFile = ZipInfo.get(this.zipFile).createZipFile();
            try {
                Object object2;
                Object object3;
                Enumeration enumeration = zipFile.getEntries();
                ArrayList<FileForSort> arrayList = new ArrayList<FileForSort>();
                HashSet<Object> hashSet = new HashSet<Object>();
                while (enumeration.hasMoreElements()) {
                    object3 = (ZipArchiveEntry)enumeration.nextElement();
                    object = ZipFileUtility.path(object3.getName());
                    if (!((String)object).startsWith(string) || ((String)object).length() == string.length()) continue;
                    int n = ((String)object).indexOf(47, string.length());
                    if (n >= 0 && n < ((String)object).length() - 1) {
                        object2 = ((String)object).substring(0, n + 1);
                        if (hashSet.contains(object2)) continue;
                        object3 = new ZipArchiveEntry((String)object2);
                        object = object2;
                    }
                    hashSet.add(object);
                    arrayList.add(new FileForSort((String)object));
                }
                Collections.sort(arrayList, comparator);
                object3 = new ArrayList(arrayList.size());
                for (FileForSort fileForSort : arrayList) {
                    object2 = new File(this.zipFile.getAbsolutePath(), fileForSort.getName());
                    ZipFileNode zipFileNode = new ZipFileNode((File)object2, this.zipFile, fileForSort.getName());
                    zipFileNode.setParent(this);
                    object3.add(zipFileNode);
                }
                object = object3;
                if (zipFile == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    return new ArrayList<FileNode>(0);
                }
            }
            zipFile.close();
        }
        return object;
    }

    @Override
    protected boolean watchChildren() {
        return false;
    }
}

