/*
 * Decompiled with CFR 0.152.
 */
package org.fife.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public abstract class RPrintUtilities {
    private static int currentDocLineNumber;
    private static int numDocLines;
    private static Element rootElement;
    private static final char[] breakChars;
    private static int xOffset;
    private static int tabSizeInSpaces;
    private static FontMetrics fm;

    private static int getLineBreakPoint(String string, int n) {
        int n2 = -1;
        for (int i = 0; i < breakChars.length; ++i) {
            int n3 = string.lastIndexOf(breakChars[i], n - 1);
            if (n3 <= n2) continue;
            n2 = n3;
        }
        return n2 == -1 ? n - 1 : n2;
    }

    public static int printDocumentMonospaced(Graphics graphics, Document document, int n, int n2, PageFormat pageFormat, int n3) {
        graphics.setColor(Color.BLACK);
        graphics.setFont(new Font("Monospaced", 0, n));
        tabSizeInSpaces = n3;
        fm = graphics.getFontMetrics();
        int n4 = fm.charWidth('w');
        int n5 = fm.getHeight();
        int n6 = (int)pageFormat.getImageableWidth() / n4;
        int n7 = (int)pageFormat.getImageableHeight() / n5;
        int n8 = n7 * n2;
        xOffset = (int)pageFormat.getImageableX();
        int n9 = (int)pageFormat.getImageableY() + fm.getAscent() + 1;
        int n10 = 0;
        rootElement = document.getDefaultRootElement();
        numDocLines = rootElement.getElementCount();
        for (currentDocLineNumber = 0; currentDocLineNumber < numDocLines; ++currentDocLineNumber) {
            String string;
            Element element = rootElement.getElement(currentDocLineNumber);
            int n11 = element.getStartOffset();
            try {
                string = document.getText(n11, element.getEndOffset() - n11);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return 1;
            }
            string = string.replaceAll("\n", "");
            if (tabSizeInSpaces == 0) {
                string = string.replaceAll("\t", "");
            } else {
                int n12 = string.indexOf(9);
                while (n12 > -1) {
                    int n13 = tabSizeInSpaces - n12 % tabSizeInSpaces;
                    Object object = "";
                    for (int i = 0; i < n13; ++i) {
                        object = (String)object + " ";
                    }
                    string = string.replaceFirst("\t", (String)object);
                    n12 = string.indexOf(9);
                }
            }
            while (string.length() > n6) {
                if (++n10 > n8) {
                    graphics.drawString(string.substring(0, n6), xOffset, n9);
                    n9 += n5;
                    if (n10 == n8 + n7) {
                        return 0;
                    }
                }
                string = string.substring(n6, string.length());
            }
            if (++n10 <= n8) continue;
            graphics.drawString(string, xOffset, n9);
            n9 += n5;
            if (n10 != n8 + n7) continue;
            return 0;
        }
        if (n10 > n8) {
            return 0;
        }
        return 1;
    }

    public static int printDocumentMonospacedWordWrap(Graphics graphics, Document document, int n, int n2, PageFormat pageFormat, int n3) {
        graphics.setColor(Color.BLACK);
        graphics.setFont(new Font("Monospaced", 0, n));
        tabSizeInSpaces = n3;
        fm = graphics.getFontMetrics();
        int n4 = fm.charWidth('w');
        int n5 = fm.getHeight();
        int n6 = (int)pageFormat.getImageableWidth() / n4;
        int n7 = (int)pageFormat.getImageableHeight() / n5;
        int n8 = n7 * n2;
        xOffset = (int)pageFormat.getImageableX();
        int n9 = (int)pageFormat.getImageableY() + fm.getAscent() + 1;
        int n10 = 0;
        rootElement = document.getDefaultRootElement();
        numDocLines = rootElement.getElementCount();
        for (currentDocLineNumber = 0; currentDocLineNumber < numDocLines; ++currentDocLineNumber) {
            int n11;
            String string;
            Element element = rootElement.getElement(currentDocLineNumber);
            int n12 = element.getStartOffset();
            try {
                string = document.getText(n12, element.getEndOffset() - n12);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
                return 1;
            }
            string = string.replaceAll("\n", "");
            if (tabSizeInSpaces == 0) {
                string = string.replaceAll("\t", "");
            } else {
                n11 = string.indexOf(9);
                while (n11 > -1) {
                    int n13 = tabSizeInSpaces - n11 % tabSizeInSpaces;
                    Object object = "";
                    for (int i = 0; i < n13; ++i) {
                        object = (String)object + " ";
                    }
                    string = string.replaceFirst("\t", (String)object);
                    n11 = string.indexOf(9);
                }
            }
            while (string.length() > n6) {
                n11 = RPrintUtilities.getLineBreakPoint(string, n6) + 1;
                if (++n10 > n8) {
                    graphics.drawString(string.substring(0, n11), xOffset, n9);
                    n9 += n5;
                    if (n10 == n8 + n7) {
                        return 0;
                    }
                }
                string = string.substring(n11, string.length());
            }
            if (++n10 <= n8) continue;
            graphics.drawString(string, xOffset, n9);
            n9 += n5;
            if (n10 != n8 + n7) continue;
            return 0;
        }
        if (n10 > n8) {
            return 0;
        }
        return 1;
    }

    public static int printDocumentWordWrap(Graphics graphics, JTextComponent jTextComponent, Font font, int n, PageFormat pageFormat, int n2) {
        graphics.setColor(Color.BLACK);
        graphics.setFont(font != null ? font : jTextComponent.getFont());
        tabSizeInSpaces = n2;
        fm = graphics.getFontMetrics();
        int n3 = fm.getHeight();
        int n4 = (int)pageFormat.getImageableWidth();
        int n5 = (int)pageFormat.getImageableHeight() / n3;
        int n6 = n5 * n;
        RPrintTabExpander rPrintTabExpander = new RPrintTabExpander();
        xOffset = (int)pageFormat.getImageableX();
        int n7 = (int)pageFormat.getImageableY() + fm.getAscent() + 1;
        int n8 = 0;
        Document document = jTextComponent.getDocument();
        rootElement = document.getDefaultRootElement();
        numDocLines = rootElement.getElementCount();
        currentDocLineNumber = 0;
        int n9 = 0;
        while (currentDocLineNumber < numDocLines) {
            Segment segment = new Segment();
            Element element = rootElement.getElement(currentDocLineNumber);
            int n10 = element.getStartOffset();
            int n11 = element.getEndOffset();
            try {
                document.getText(n10 + n9, n11 - (n10 + n9), segment);
            }
            catch (BadLocationException badLocationException) {
                System.err.println("BadLocationException in print (where there shouldn't be one!): " + String.valueOf(badLocationException));
                return 1;
            }
            segment = RPrintUtilities.removeEndingWhitespace(segment);
            int n12 = Utilities.getTabbedTextWidth(segment, fm, 0, (TabExpander)rPrintTabExpander, 0);
            if (n12 <= n4) {
                ++currentDocLineNumber;
                n9 = 0;
            } else {
                int n13 = -1;
                while (n12 > n4) {
                    segment = RPrintUtilities.removeEndingWhitespace(segment);
                    n13 = -1;
                    String string = segment.toString();
                    for (int i = 0; i < breakChars.length; ++i) {
                        int n14 = string.lastIndexOf(breakChars[i]) + 1;
                        if (n14 <= 0 || !(n14 > n13 & n14 != string.length())) continue;
                        n13 = n14;
                    }
                    if (n13 == -1) {
                        n13 = 0;
                        do {
                            ++n13;
                            try {
                                document.getText(n10 + n9, n13, segment);
                            }
                            catch (BadLocationException badLocationException) {
                                System.err.println(badLocationException);
                                return 1;
                            }
                        } while ((n12 = Utilities.getTabbedTextWidth(segment, fm, 0, (TabExpander)rPrintTabExpander, 0)) <= n4);
                        --n13;
                    }
                    try {
                        document.getText(n10 + n9, n13, segment);
                    }
                    catch (BadLocationException badLocationException) {
                        System.err.println("BadLocationException in print (a):");
                        System.err.println("==> currentLineStart: " + n10 + "; startingOffset: " + n9 + "; currentPos: " + n13);
                        System.err.println("==> Range: " + (n10 + n9) + " - " + (n10 + n9 + n13));
                        badLocationException.printStackTrace();
                        return 1;
                    }
                    n12 = Utilities.getTabbedTextWidth(segment, fm, 0, (TabExpander)rPrintTabExpander, 0);
                }
                n9 += n13;
            }
            if (++n8 <= n6) continue;
            Utilities.drawTabbedText(segment, xOffset, n7, graphics, (TabExpander)rPrintTabExpander, 0);
            n7 += n3;
            if (n8 != n6 + n5) continue;
            return 0;
        }
        if (n8 > n6) {
            return 0;
        }
        return 1;
    }

    private static Segment removeEndingWhitespace(Segment segment) {
        int n = 0;
        char c = segment.setIndex(segment.getEndIndex() - 1);
        while ((c == ' ' || c == '\t') && c != '\uffff') {
            ++n;
            c = segment.previous();
        }
        String string = segment.toString();
        String string2 = string.substring(0, string.length() - n);
        return new Segment(string2.toCharArray(), 0, string2.length());
    }

    static {
        breakChars = new char[]{' ', '\t', ',', '.', ';', '?', '!'};
    }

    private static class RPrintTabExpander
    implements TabExpander {
        RPrintTabExpander() {
        }

        @Override
        public float nextTabStop(float f, int n) {
            if (tabSizeInSpaces == 0) {
                return f;
            }
            int n2 = tabSizeInSpaces * fm.charWidth(' ');
            int n3 = ((int)f - xOffset) / n2;
            return xOffset + (n3 + 1) * n2;
        }
    }
}

