/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import javax.swing.Icon;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;

public abstract class AbstractCompletion
implements Completion {
    private CompletionProvider provider;
    private Icon icon;
    private int relevance;

    protected AbstractCompletion(CompletionProvider completionProvider) {
        this.provider = completionProvider;
    }

    protected AbstractCompletion(CompletionProvider completionProvider, Icon icon) {
        this(completionProvider);
        this.setIcon(icon);
    }

    @Override
    public int compareTo(Completion completion) {
        if (completion == this) {
            return 0;
        }
        if (completion != null) {
            return this.toString().compareToIgnoreCase(completion.toString());
        }
        return -1;
    }

    @Override
    public String getAlreadyEntered(JTextComponent jTextComponent) {
        return this.provider.getAlreadyEnteredText(jTextComponent);
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public String getInputText() {
        return this.getReplacementText();
    }

    @Override
    public CompletionProvider getProvider() {
        return this.provider;
    }

    @Override
    public int getRelevance() {
        return this.relevance;
    }

    @Override
    public String getToolTipText() {
        return null;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public void setRelevance(int n) {
        this.relevance = n;
    }

    public String toString() {
        return this.getInputText();
    }
}

