/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.CompletionProviderBase;
import org.fife.ui.autocomplete.Util;

public abstract class AbstractCompletionProvider
extends CompletionProviderBase {
    protected List<Completion> completions;
    protected CaseInsensitiveComparator comparator = new CaseInsensitiveComparator();

    public AbstractCompletionProvider() {
        this.clearParameterizedCompletionParams();
        this.completions = new ArrayList<Completion>();
    }

    public void addCompletion(Completion completion) {
        this.checkProviderAndAdd(completion);
        Collections.sort(this.completions);
    }

    public void addCompletions(List<Completion> list) {
        for (Completion completion : list) {
            this.checkProviderAndAdd(completion);
        }
        Collections.sort(this.completions);
    }

    protected void addWordCompletions(String[] stringArray) {
        int n = stringArray == null ? 0 : stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.completions.add(new BasicCompletion((CompletionProvider)this, stringArray[i]));
        }
        Collections.sort(this.completions);
    }

    protected void checkProviderAndAdd(Completion completion) {
        if (completion.getProvider() != this) {
            throw new IllegalArgumentException("Invalid CompletionProvider");
        }
        this.completions.add(completion);
    }

    public void clear() {
        this.completions.clear();
    }

    public List<Completion> getCompletionByInputText(String string) {
        int n;
        int n2 = Collections.binarySearch(this.completions, string, this.comparator);
        if (n2 < 0) {
            return null;
        }
        for (n = n2; n > 0 && this.comparator.compare(this.completions.get(n - 1), string) == 0; --n) {
        }
        int n3 = this.completions.size();
        while (++n2 < n3 && this.comparator.compare(this.completions.get(n2), string) == 0) {
        }
        return this.completions.subList(n, n2);
    }

    @Override
    protected List<Completion> getCompletionsImpl(JTextComponent jTextComponent) {
        ArrayList<Completion> arrayList = new ArrayList<Completion>();
        String string = this.getAlreadyEnteredText(jTextComponent);
        if (string != null) {
            Completion completion;
            int n = Collections.binarySearch(this.completions, string, this.comparator);
            if (n < 0) {
                n = -n - 1;
            } else {
                for (int i = n - 1; i > 0 && this.comparator.compare(this.completions.get(i), string) == 0; --i) {
                    arrayList.add(this.completions.get(i));
                }
            }
            while (n < this.completions.size() && Util.startsWithIgnoreCase((completion = this.completions.get(n)).getInputText(), string)) {
                arrayList.add(completion);
                ++n;
            }
        }
        return arrayList;
    }

    public boolean removeCompletion(Completion completion) {
        int n = Collections.binarySearch(this.completions, completion);
        if (n < 0) {
            return false;
        }
        this.completions.remove(n);
        return true;
    }

    public static class CaseInsensitiveComparator
    implements Comparator,
    Serializable {
        public int compare(Object object, Object object2) {
            String string = object instanceof String ? (String)object : ((Completion)object).getInputText();
            String string2 = object2 instanceof String ? (String)object2 : ((Completion)object2).getInputText();
            return String.CASE_INSENSITIVE_ORDER.compare(string, string2);
        }
    }
}

