/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.fife.ui.autocomplete.AbstractCompletionProvider;
import org.fife.ui.autocomplete.AutoCompletePopupWindow;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.DescWindowCallback;
import org.fife.ui.autocomplete.DescriptionListener;
import org.fife.ui.autocomplete.SizeGrip;
import org.fife.ui.autocomplete.TipUtil;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;

public class AutoCompleteDescWindow
extends JWindow
implements HyperlinkListener,
DescWindowCallback {
    private AutoCompletion ac;
    private JEditorPane descArea;
    private JScrollPane scrollPane;
    private JPanel bottomPanel;
    private JToolBar descWindowNavBar;
    private Action backAction;
    private Action forwardAction;
    private List<HistoryEntry> history;
    private int historyPos;
    private Timer timer;
    private TimerAction timerAction;
    private ResourceBundle bundle;
    private static final int INITIAL_TIMER_DELAY = 80;
    private static final String MSG = "org.fife.ui.autocomplete.AutoCompleteDescWindow";

    public AutoCompleteDescWindow(Window window, AutoCompletion autoCompletion) {
        super(window);
        PopupWindowDecorator popupWindowDecorator;
        this.ac = autoCompletion;
        ComponentOrientation componentOrientation = autoCompletion == null ? ComponentOrientation.LEFT_TO_RIGHT : autoCompletion.getTextComponentOrientation();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(TipUtil.getToolTipBorder());
        this.descArea = new JEditorPane("text/html", null);
        TipUtil.tweakTipEditorPane(this.descArea);
        this.descArea.addHyperlinkListener(this);
        this.scrollPane = new JScrollPane(this.descArea);
        Border border = BorderFactory.createEmptyBorder();
        this.scrollPane.setBorder(border);
        this.scrollPane.setViewportBorder(border);
        jPanel.add(this.scrollPane);
        this.descWindowNavBar = new JToolBar();
        this.backAction = new ToolBarBackAction(componentOrientation.isLeftToRight());
        this.forwardAction = new ToolBarForwardAction(componentOrientation.isLeftToRight());
        this.descWindowNavBar.setFloatable(false);
        this.descWindowNavBar.add(new JButton(this.backAction));
        this.descWindowNavBar.add(new JButton(this.forwardAction));
        this.bottomPanel = new JPanel(new BorderLayout());
        border = new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(1, 0, 0, 0);
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.setColor(UIManager.getColor("controlDkShadow"));
                graphics.drawLine(n, n2, n + n3 - 1, n2);
            }
        };
        this.bottomPanel.setBorder(border);
        SizeGrip sizeGrip = new SizeGrip();
        this.bottomPanel.add((Component)this.descWindowNavBar, "Before");
        this.bottomPanel.add((Component)sizeGrip, "After");
        jPanel.add((Component)this.bottomPanel, "South");
        this.setContentPane(jPanel);
        this.applyComponentOrientation(componentOrientation);
        this.setFocusableWindowState(false);
        if (Util.getShouldAllowDecoratingMainAutoCompleteWindows() && (popupWindowDecorator = PopupWindowDecorator.get()) != null) {
            popupWindowDecorator.decorate(this);
        }
        this.history = new ArrayList<HistoryEntry>(1);
        this.historyPos = -1;
        this.timerAction = new TimerAction();
        this.timer = new Timer(80, this.timerAction);
        this.timer.setRepeats(false);
    }

    private void addToHistory(HistoryEntry historyEntry) {
        this.history.add(++this.historyPos, historyEntry);
        this.clearHistoryAfterCurrentPos();
        this.setActionStates();
    }

    private void clearHistory() {
        this.history.clear();
        this.historyPos = -1;
        if (this.descWindowNavBar != null) {
            this.setActionStates();
        }
    }

    private void clearHistoryAfterCurrentPos() {
        for (int i = this.history.size() - 1; i > this.historyPos; --i) {
            this.history.remove(i);
        }
        this.setActionStates();
    }

    public boolean copy() {
        if (this.isVisible() && this.descArea.getSelectionStart() != this.descArea.getSelectionEnd()) {
            this.descArea.copy();
            return true;
        }
        return false;
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(MSG);
        }
        return this.bundle.getString(string);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        Object object;
        Object object2;
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        if (!eventType.equals(HyperlinkEvent.EventType.ACTIVATED)) {
            return;
        }
        Object object3 = hyperlinkEvent.getURL();
        if (object3 != null && (object2 = AutoCompletion.getLinkRedirector()) != null && (object = object2.possiblyRedirect((URL)object3)) != null && object != object3) {
            object3 = object;
            hyperlinkEvent = new HyperlinkEvent(hyperlinkEvent.getSource(), hyperlinkEvent.getEventType(), (URL)object, hyperlinkEvent.getDescription(), hyperlinkEvent.getSourceElement());
        }
        if (this.ac != null && (object2 = this.ac.getExternalURLHandler()) != null) {
            object = this.history.get(this.historyPos);
            object2.urlClicked(hyperlinkEvent, ((HistoryEntry)object).completion, this);
            return;
        }
        if (object3 != null) {
            try {
                Util.browse(new URI(((URL)object3).toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this.descArea);
                uRISyntaxException.printStackTrace();
            }
        } else {
            object2 = (AutoCompletePopupWindow)this.getParent();
            object = ((AutoCompletePopupWindow)object2).getSelection().getProvider();
            if (object instanceof AbstractCompletionProvider) {
                String string = hyperlinkEvent.getDescription();
                List<Completion> list = ((AbstractCompletionProvider)object).getCompletionByInputText(string);
                if (list != null && !list.isEmpty()) {
                    Completion completion = list.get(0);
                    this.setDescriptionFor(completion, true);
                } else {
                    UIManager.getLookAndFeel().provideErrorFeedback(this.descArea);
                }
            }
        }
    }

    private void setActionStates() {
        String string = null;
        if (this.historyPos > 0) {
            this.backAction.setEnabled(true);
            string = "Back to " + String.valueOf(this.history.get(this.historyPos - 1));
        } else {
            this.backAction.setEnabled(false);
        }
        this.backAction.putValue("ShortDescription", string);
        if (this.historyPos > -1 && this.historyPos < this.history.size() - 1) {
            this.forwardAction.setEnabled(true);
            string = "Forward to " + String.valueOf(this.history.get(this.historyPos + 1));
        } else {
            this.forwardAction.setEnabled(false);
            string = null;
        }
        this.forwardAction.putValue("ShortDescription", string);
    }

    public void setDescriptionFor(Completion completion) {
        this.setDescriptionFor(completion, false);
    }

    protected void setDescriptionFor(Completion completion, boolean bl) {
        this.setDescriptionFor(completion, null, bl);
    }

    protected void setDescriptionFor(Completion completion, String string, boolean bl) {
        this.timer.stop();
        this.timerAction.setCompletion(completion, string, bl);
        this.timer.start();
    }

    private void setDisplayedDesc(Completion completion, final String string, boolean bl) {
        Object object;
        Object object2 = object = completion == null ? null : completion.getSummary();
        if (object == null) {
            object = "<html><em>" + this.getString("NoDescAvailable") + "</em>";
        }
        this.descArea.setText((String)object);
        if (string != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoCompleteDescWindow.this.descArea.scrollToReference(string);
                }
            });
        } else {
            this.descArea.setCaretPosition(0);
        }
        if (!bl) {
            this.clearHistory();
        }
        this.addToHistory(new HistoryEntry(completion, (String)object, null));
    }

    @Override
    public void setVisible(boolean bl) {
        if (!bl) {
            this.clearHistory();
        }
        super.setVisible(bl);
    }

    @Override
    public void showSummaryFor(Completion completion, String string) {
        this.setDescriptionFor(completion, string, true);
    }

    public void updateUI() {
        SwingUtilities.updateComponentTreeUI(this);
        TipUtil.tweakTipEditorPane(this.descArea);
        this.scrollPane.setBackground(this.descArea.getBackground());
        this.scrollPane.getViewport().setBackground(this.descArea.getBackground());
        ((JPanel)this.getContentPane()).setBorder(TipUtil.getToolTipBorder());
    }

    class ToolBarBackAction
    extends AbstractAction {
        public ToolBarBackAction(boolean bl) {
            String string = "org/fife/ui/autocomplete/arrow_" + (bl ? "left.png" : "right.png");
            ClassLoader classLoader = this.getClass().getClassLoader();
            ImageIcon imageIcon = new ImageIcon(classLoader.getResource(string));
            this.putValue("SmallIcon", imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompleteDescWindow.this.historyPos > 0) {
                HistoryEntry historyEntry = AutoCompleteDescWindow.this.history.get(--AutoCompleteDescWindow.this.historyPos);
                AutoCompleteDescWindow.this.descArea.setText(historyEntry.summary);
                if (historyEntry.anchor != null) {
                    AutoCompleteDescWindow.this.descArea.scrollToReference(historyEntry.anchor);
                } else {
                    AutoCompleteDescWindow.this.descArea.setCaretPosition(0);
                }
                AutoCompleteDescWindow.this.setActionStates();
            }
        }
    }

    class ToolBarForwardAction
    extends AbstractAction {
        public ToolBarForwardAction(boolean bl) {
            String string = "org/fife/ui/autocomplete/arrow_" + (bl ? "right.png" : "left.png");
            ClassLoader classLoader = this.getClass().getClassLoader();
            ImageIcon imageIcon = new ImageIcon(classLoader.getResource(string));
            this.putValue("SmallIcon", imageIcon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AutoCompleteDescWindow.this.history != null && AutoCompleteDescWindow.this.historyPos < AutoCompleteDescWindow.this.history.size() - 1) {
                HistoryEntry historyEntry = AutoCompleteDescWindow.this.history.get(++AutoCompleteDescWindow.this.historyPos);
                AutoCompleteDescWindow.this.descArea.setText(historyEntry.summary);
                if (historyEntry.anchor != null) {
                    AutoCompleteDescWindow.this.descArea.scrollToReference(historyEntry.anchor);
                } else {
                    AutoCompleteDescWindow.this.descArea.setCaretPosition(0);
                }
                AutoCompleteDescWindow.this.setActionStates();
            }
        }
    }

    private class TimerAction
    extends AbstractAction {
        private Completion completion;
        private String anchor;
        private boolean addToHistory;
        private String description;

        private TimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            String string2 = string = this.completion == null ? null : this.completion.getSummary();
            if (string != this.description) {
                AutoCompleteDescWindow.this.setDisplayedDesc(this.completion, this.anchor, this.addToHistory);
            }
            this.description = string;
            if (this.completion instanceof DescriptionListener) {
                ((DescriptionListener)((Object)this.completion)).descriptionDidSet(AutoCompleteDescWindow.this.descArea);
            }
        }

        public void setCompletion(Completion completion, String string, boolean bl) {
            this.completion = completion;
            this.anchor = string;
            this.addToHistory = bl;
        }
    }

    private static class HistoryEntry {
        public Completion completion;
        public String summary;
        public String anchor;

        public HistoryEntry(Completion completion, String string, String string2) {
            this.completion = completion;
            this.summary = string;
            this.anchor = string2;
        }

        public String toString() {
            return this.completion.getInputText();
        }
    }
}

