/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.text.View;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.EmptyIcon;
import org.fife.ui.autocomplete.FunctionCompletion;
import org.fife.ui.autocomplete.MarkupTagCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.TemplateCompletion;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.autocomplete.VariableCompletion;

public class CompletionCellRenderer
extends DefaultListCellRenderer {
    private static Color altBG;
    private Font font;
    private boolean showTypes;
    private String typeColor;
    private boolean selected;
    private Color realBG;
    private String paramColor;
    private Icon emptyIcon;
    private Rectangle paintTextR;
    private DefaultListCellRenderer delegate;
    private static final String SUBSTANCE_RENDERER_CLASS_NAME = "org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer";
    private static final String PREFIX = "<html><nobr>";

    public CompletionCellRenderer() {
        this.init();
    }

    public CompletionCellRenderer(DefaultListCellRenderer defaultListCellRenderer) {
        this.setDelegateRenderer(defaultListCellRenderer);
        this.init();
    }

    protected Icon createEmptyIcon() {
        return new EmptyIcon(16);
    }

    private String createParamColor() {
        return Util.isLightForeground(this.getForeground()) ? Util.getHexString(Util.getHyperlinkForeground()) : "#aa0077";
    }

    private String createTypeColor() {
        return "#808080";
    }

    public void delegateToSubstanceRenderer() throws Exception {
        Class<?> clazz = Class.forName(SUBSTANCE_RENDERER_CLASS_NAME);
        DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)clazz.newInstance();
        this.setDelegateRenderer(defaultListCellRenderer);
    }

    public static Color getAlternateBackground() {
        return altBG;
    }

    public DefaultListCellRenderer getDelegateRenderer() {
        return this.delegate;
    }

    public Font getDisplayFont() {
        return this.font;
    }

    protected Icon getEmptyIcon() {
        if (this.emptyIcon == null) {
            this.emptyIcon = this.createEmptyIcon();
        }
        return this.emptyIcon;
    }

    protected Icon getIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            File file = new File(string);
            try {
                uRL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        return uRL != null ? new ImageIcon(uRL) : null;
    }

    @Override
    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        if (this.font != null) {
            this.setFont(this.font);
        }
        this.selected = bl;
        this.realBG = altBG != null && (n & 1) == 1 ? altBG : jList.getBackground();
        Completion completion = (Completion)object;
        this.setIcon(completion.getIcon());
        if (completion instanceof FunctionCompletion) {
            FunctionCompletion functionCompletion = (FunctionCompletion)object;
            this.prepareForFunctionCompletion(jList, functionCompletion, n, bl, bl2);
        } else if (completion instanceof VariableCompletion) {
            VariableCompletion variableCompletion = (VariableCompletion)object;
            this.prepareForVariableCompletion(jList, variableCompletion, n, bl, bl2);
        } else if (completion instanceof TemplateCompletion) {
            TemplateCompletion templateCompletion = (TemplateCompletion)object;
            this.prepareForTemplateCompletion(jList, templateCompletion, n, bl, bl2);
        } else if (completion instanceof MarkupTagCompletion) {
            MarkupTagCompletion markupTagCompletion = (MarkupTagCompletion)object;
            this.prepareForMarkupTagCompletion(jList, markupTagCompletion, n, bl, bl2);
        } else {
            this.prepareForOtherCompletion(jList, completion, n, bl, bl2);
        }
        if (this.delegate != null) {
            this.delegate.getListCellRendererComponent((JList<?>)jList, this.getText(), n, bl, bl2);
            this.delegate.setFont(this.getFont());
            this.delegate.setIcon(this.getIcon());
            return this.delegate;
        }
        if (!bl && (n & 1) == 1 && altBG != null) {
            this.setBackground(altBG);
        }
        return this;
    }

    public boolean getShowTypes() {
        return this.showTypes;
    }

    private void init() {
        this.setShowTypes(true);
        this.typeColor = this.createTypeColor();
        this.paramColor = this.createParamColor();
        this.paintTextR = new Rectangle();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        String string;
        graphics.setColor(this.realBG);
        int n = 0;
        if (this.getIcon() != null) {
            n = this.getIcon().getIconWidth();
        }
        if (this.selected && n > 0) {
            graphics.fillRect(0, 0, n, this.getHeight());
            graphics.setColor(this.getBackground());
            graphics.fillRect(n, 0, this.getWidth() - n, this.getHeight());
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.getIcon() != null) {
            this.getIcon().paintIcon(this, graphics, 0, 0);
        }
        if ((string = this.getText()) != null) {
            this.paintTextR.setBounds(n, 0, this.getWidth() - n, this.getHeight());
            this.paintTextR.x += 3;
            int n2 = this.paintTextR.height - graphics.getFontMetrics().getHeight();
            View view = (View)this.getClientProperty("html");
            if (view != null) {
                this.paintTextR.y += n2 / 2;
                this.paintTextR.height -= n2;
                view.paint(graphics, this.paintTextR);
            } else {
                int n3 = this.paintTextR.x;
                int n4 = this.paintTextR.y;
                graphics.drawString(string, n3, n4);
            }
        }
    }

    protected void prepareForFunctionCompletion(JList jList, FunctionCompletion functionCompletion, int n, boolean bl, boolean bl2) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(PREFIX);
        stringBuilder.append(functionCompletion.getName());
        char c = functionCompletion.getProvider().getParameterListStart();
        if (c != '\u0000') {
            stringBuilder.append(c);
        }
        int n3 = functionCompletion.getParamCount();
        for (n2 = 0; n2 < n3; ++n2) {
            ParameterizedCompletion.Parameter parameter = functionCompletion.getParam(n2);
            String string = parameter.getType();
            String string2 = parameter.getName();
            if (string != null) {
                if (!bl) {
                    stringBuilder.append("<font color='").append(this.paramColor).append("'>");
                }
                stringBuilder.append(string);
                if (!bl) {
                    stringBuilder.append("</font>");
                }
                if (string2 != null) {
                    stringBuilder.append(' ');
                }
            }
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            if (n2 >= n3 - '\u0001') continue;
            stringBuilder.append(functionCompletion.getProvider().getParameterListSeparator());
        }
        n2 = functionCompletion.getProvider().getParameterListEnd();
        if (n2 != 0) {
            stringBuilder.append((char)n2);
        }
        if (this.getShowTypes() && functionCompletion.getType() != null) {
            stringBuilder.append(" : ");
            if (!bl) {
                stringBuilder.append("<font color='").append(this.typeColor).append("'>");
            }
            stringBuilder.append(functionCompletion.getType());
            if (!bl) {
                stringBuilder.append("</font>");
            }
        }
        this.setText(stringBuilder.toString());
    }

    protected void prepareForMarkupTagCompletion(JList jList, MarkupTagCompletion markupTagCompletion, int n, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(PREFIX);
        stringBuilder.append(markupTagCompletion.getName());
        this.setText(stringBuilder.toString());
    }

    protected void prepareForOtherCompletion(JList jList, Completion completion, int n, boolean bl, boolean bl2) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(PREFIX);
        stringBuilder.append(completion.getInputText());
        if (completion instanceof BasicCompletion && (string = ((BasicCompletion)completion).getShortDescription()) != null) {
            stringBuilder.append(" - ");
            if (!bl) {
                stringBuilder.append("<font color='").append(this.typeColor).append("'>");
            }
            stringBuilder.append(string);
            if (!bl) {
                stringBuilder.append("</font>");
            }
        }
        this.setText(stringBuilder.toString());
    }

    protected void prepareForTemplateCompletion(JList jList, TemplateCompletion templateCompletion, int n, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(PREFIX);
        stringBuilder.append(templateCompletion.getInputText());
        String string = templateCompletion.getShortDescription();
        if (string != null) {
            stringBuilder.append(" - ");
            if (!bl) {
                stringBuilder.append("<font color='").append(this.typeColor).append("'>");
            }
            stringBuilder.append(string);
            if (!bl) {
                stringBuilder.append("</font>");
            }
        }
        this.setText(stringBuilder.toString());
    }

    protected void prepareForVariableCompletion(JList jList, VariableCompletion variableCompletion, int n, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder(PREFIX);
        stringBuilder.append(variableCompletion.getName());
        if (this.getShowTypes() && variableCompletion.getType() != null) {
            stringBuilder.append(" : ");
            if (!bl) {
                stringBuilder.append("<font color='").append(this.typeColor).append("'>");
            }
            stringBuilder.append(variableCompletion.getType());
            if (!bl) {
                stringBuilder.append("</font>");
            }
        }
        this.setText(stringBuilder.toString());
    }

    public static void setAlternateBackground(Color color) {
        altBG = color;
    }

    public void setDelegateRenderer(DefaultListCellRenderer defaultListCellRenderer) {
        this.delegate = defaultListCellRenderer;
    }

    public void setDisplayFont(Font font) {
        this.font = font;
    }

    protected void setIconWithDefault(Completion completion) {
        this.setIconWithDefault(completion, this.getEmptyIcon());
    }

    protected void setIconWithDefault(Completion completion, Icon icon) {
        Icon icon2 = completion.getIcon();
        this.setIcon(icon2 != null ? icon2 : (icon != null ? icon : this.emptyIcon));
    }

    public void setParamColor(Color color) {
        if (color != null) {
            this.paramColor = Util.getHexString(color);
        }
    }

    public void setShowTypes(boolean bl) {
        this.showTypes = bl;
    }

    public void setTypeColor(Color color) {
        if (color != null) {
            this.typeColor = Util.getHexString(color);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.delegate != null) {
            SwingUtilities.updateComponentTreeUI(this.delegate);
        }
        this.paramColor = this.createParamColor();
    }
}

