/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicListUI;

class FastListUI
extends BasicListUI {
    private boolean overriddenBackground;
    private boolean overriddenForeground;
    private static final int ESTIMATION_THRESHOLD = 200;

    FastListUI() {
    }

    private Color determineSelectionBackground() {
        Color color = UIManager.getColor("List.selectionBackground");
        if (color == null && (color = UIManager.getColor("nimbusSelectionBackground")) == null && (color = UIManager.getColor("textHighlight")) == null) {
            color = SystemColor.textHighlight;
        }
        return new Color(color.getRGB());
    }

    private Color determineSelectionForeground() {
        Color color = UIManager.getColor("List.selectionForeground");
        if (color == null && (color = UIManager.getColor("nimbusSelectedText")) == null && (color = UIManager.getColor("textHighlightText")) == null) {
            color = SystemColor.textHighlightText;
        }
        return new Color(color.getRGB());
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        if (this.list.getSelectionBackground() == null) {
            this.list.setSelectionBackground(this.determineSelectionBackground());
            this.overriddenBackground = true;
        }
        if (this.list.getSelectionForeground() == null) {
            this.list.setSelectionForeground(this.determineSelectionForeground());
            this.overriddenForeground = true;
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        if (this.overriddenBackground) {
            this.list.setSelectionBackground(null);
        }
        if (this.overriddenForeground) {
            this.list.setSelectionForeground(null);
        }
    }

    @Override
    protected void updateLayoutState() {
        ListModel listModel = this.list.getModel();
        int n = listModel.getSize();
        if (n < 200) {
            super.updateLayoutState();
            return;
        }
        ListCellRenderer listCellRenderer = this.list.getCellRenderer();
        this.cellWidth = this.list.getWidth();
        if (this.list.getParent() instanceof JViewport) {
            this.cellWidth = this.list.getParent().getWidth();
        }
        this.cellHeights = null;
        if (listCellRenderer != null && n > 0) {
            Object e = listModel.getElementAt(0);
            Component component = listCellRenderer.getListCellRendererComponent(this.list, e, 0, false, false);
            this.rendererPane.add(component);
            Dimension dimension = component.getPreferredSize();
            this.cellHeight = dimension.height;
            this.cellWidth = Math.max(this.cellWidth, dimension.width);
        } else {
            this.cellHeight = 20;
        }
    }
}

