/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;
import org.fife.ui.autocomplete.ParameterizedCompletionInsertionInfo;
import org.fife.ui.autocomplete.VariableCompletion;

public class FunctionCompletion
extends VariableCompletion
implements ParameterizedCompletion {
    private List<ParameterizedCompletion.Parameter> params;
    private String returnValDesc;
    private String compareString;

    public FunctionCompletion(CompletionProvider completionProvider, String string, String string2) {
        super(completionProvider, string, string2);
    }

    @Override
    protected void addDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("<html><b>");
        stringBuilder.append(this.getDefinitionString());
        stringBuilder.append("</b>");
    }

    protected void addParameters(StringBuilder stringBuilder) {
        int n = this.getParamCount();
        if (n > 0) {
            stringBuilder.append("<b>Parameters:</b><br>");
            stringBuilder.append("<center><table width='90%'><tr><td>");
            for (int i = 0; i < n; ++i) {
                ParameterizedCompletion.Parameter parameter = this.getParam(i);
                stringBuilder.append("<b>");
                stringBuilder.append(parameter.getName() != null ? parameter.getName() : parameter.getType());
                stringBuilder.append("</b>&nbsp;");
                String string = parameter.getDescription();
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append("<br>");
            }
            stringBuilder.append("</td></tr></table></center><br><br>");
        }
        if (this.returnValDesc != null) {
            stringBuilder.append("<b>Returns:</b><br><center><table width='90%'><tr><td>");
            stringBuilder.append(this.returnValDesc);
            stringBuilder.append("</td></tr></table></center><br><br>");
        }
    }

    @Override
    public int compareTo(Completion completion) {
        int n = -1;
        n = completion == this ? 0 : (completion instanceof FunctionCompletion ? this.getCompareString().compareTo(((FunctionCompletion)completion).getCompareString()) : super.compareTo(completion));
        return n;
    }

    private String getCompareString() {
        if (this.compareString == null) {
            StringBuilder stringBuilder = new StringBuilder(this.getName());
            int n = this.getParamCount();
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
            for (int i = 0; i < n; ++i) {
                String string = this.getParam(i).getType();
                stringBuilder.append(string);
                if (i >= n - 1) continue;
                stringBuilder.append(',');
            }
            this.compareString = stringBuilder.toString();
        }
        return this.compareString;
    }

    @Override
    public String getDefinitionString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getType();
        if (string != null) {
            stringBuilder.append(string).append(' ');
        }
        stringBuilder.append(this.getName());
        CompletionProvider completionProvider = this.getProvider();
        char c = completionProvider.getParameterListStart();
        if (c != '\u0000') {
            stringBuilder.append(c);
        }
        for (n = 0; n < this.getParamCount(); ++n) {
            ParameterizedCompletion.Parameter parameter = this.getParam(n);
            string = parameter.getType();
            String string2 = parameter.getName();
            if (string != null) {
                stringBuilder.append(string);
                if (string2 != null) {
                    stringBuilder.append(' ');
                }
            }
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            if (n >= this.params.size() - 1) continue;
            stringBuilder.append(completionProvider.getParameterListSeparator());
        }
        n = completionProvider.getParameterListEnd();
        if (n != 0) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    @Override
    public ParameterizedCompletionInsertionInfo getInsertionInfo(JTextComponent jTextComponent, boolean bl) {
        int n;
        ParameterizedCompletionInsertionInfo parameterizedCompletionInsertionInfo = new ParameterizedCompletionInsertionInfo();
        StringBuilder stringBuilder = new StringBuilder();
        char c = this.getProvider().getParameterListStart();
        if (c != '\u0000') {
            stringBuilder.append(c);
        }
        int n2 = jTextComponent.getCaretPosition() + stringBuilder.length();
        int n3 = this.getParamCount();
        int n4 = n2;
        Position position = null;
        try {
            position = jTextComponent.getDocument().createPosition(n2 - stringBuilder.length() + 1);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        parameterizedCompletionInsertionInfo.setCaretRange(n4, position);
        int n5 = 0;
        int n6 = n2;
        for (n = 0; n < n3; ++n) {
            ParameterizedCompletion.Parameter parameter = this.getParam(n);
            String string = this.getParamText(parameter);
            if (n == 0) {
                n5 = string.length();
            }
            stringBuilder.append(string);
            int n7 = n6 + string.length();
            parameterizedCompletionInsertionInfo.addReplacementLocation(n6, n7);
            String string2 = this.getProvider().getParameterListSeparator();
            if (n >= n3 - 1 || string2 == null) continue;
            stringBuilder.append(string2);
            n6 = n7 + string2.length();
        }
        stringBuilder.append(this.getProvider().getParameterListEnd());
        n = n2 + stringBuilder.length();
        parameterizedCompletionInsertionInfo.addReplacementLocation(--n, n);
        parameterizedCompletionInsertionInfo.setDefaultEndOffs(n);
        int n8 = n3 > 0 ? n2 + n5 : n2;
        parameterizedCompletionInsertionInfo.setInitialSelection(n2, n8);
        parameterizedCompletionInsertionInfo.setTextToInsert(stringBuilder.toString());
        return parameterizedCompletionInsertionInfo;
    }

    @Override
    public ParameterizedCompletion.Parameter getParam(int n) {
        return this.params.get(n);
    }

    @Override
    public int getParamCount() {
        return this.params == null ? 0 : this.params.size();
    }

    @Override
    public boolean getShowParameterToolTip() {
        return true;
    }

    private String getParamText(ParameterizedCompletion.Parameter parameter) {
        String string = parameter.getName();
        if (string == null && (string = parameter.getType()) == null) {
            string = "arg";
        }
        return string;
    }

    public String getReturnValueDescription() {
        return this.returnValDesc;
    }

    @Override
    public String getSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addDefinitionString(stringBuilder);
        if (!this.possiblyAddDescription(stringBuilder)) {
            stringBuilder.append("<br><br><br>");
        }
        this.addParameters(stringBuilder);
        this.possiblyAddDefinedIn(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public String getToolTipText() {
        String string = this.getSummary();
        if (string == null) {
            string = this.getDefinitionString();
        }
        return string;
    }

    public void setParams(List<ParameterizedCompletion.Parameter> list) {
        if (list != null) {
            this.params = new ArrayList<ParameterizedCompletion.Parameter>(list);
        }
    }

    public void setReturnValueDescription(String string) {
        this.returnValDesc = string;
    }
}

