/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.util.ArrayList;
import java.util.List;
import org.fife.ui.autocomplete.AbstractCompletion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.ParameterizedCompletion;

public class MarkupTagCompletion
extends AbstractCompletion {
    private String name;
    private String desc;
    private String definedIn;
    private List<ParameterizedCompletion.Parameter> attrs;

    public MarkupTagCompletion(CompletionProvider completionProvider, String string) {
        super(completionProvider);
        this.name = string;
    }

    protected void addAttributes(StringBuilder stringBuilder) {
        int n = this.getAttributeCount();
        if (n > 0) {
            stringBuilder.append("<b>Attributes:</b><br>");
            stringBuilder.append("<center><table width='90%'><tr><td>");
            for (int i = 0; i < n; ++i) {
                ParameterizedCompletion.Parameter parameter = this.getAttribute(i);
                stringBuilder.append("&nbsp;&nbsp;&nbsp;<b>");
                stringBuilder.append(parameter.getName() != null ? parameter.getName() : parameter.getType());
                stringBuilder.append("</b>&nbsp;");
                String string = parameter.getDescription();
                if (string != null) {
                    stringBuilder.append(string);
                }
                stringBuilder.append("<br>");
            }
            stringBuilder.append("</td></tr></table></center><br><br>");
        }
    }

    protected void addDefinitionString(StringBuilder stringBuilder) {
        stringBuilder.append("<html><b>").append(this.name).append("</b>");
    }

    public List<ParameterizedCompletion.Parameter> getAttributes() {
        return this.attrs;
    }

    public ParameterizedCompletion.Parameter getAttribute(int n) {
        return this.attrs.get(n);
    }

    public int getAttributeCount() {
        return this.attrs == null ? 0 : this.attrs.size();
    }

    public String getDefinedIn() {
        return this.definedIn;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getReplacementText() {
        return this.getName();
    }

    @Override
    public String getSummary() {
        StringBuilder stringBuilder = new StringBuilder();
        this.addDefinitionString(stringBuilder);
        this.possiblyAddDescription(stringBuilder);
        this.addAttributes(stringBuilder);
        this.possiblyAddDefinedIn(stringBuilder);
        return stringBuilder.toString();
    }

    protected void possiblyAddDefinedIn(StringBuilder stringBuilder) {
        if (this.definedIn != null) {
            stringBuilder.append("<hr>Defined in:");
            stringBuilder.append(" <em>").append(this.definedIn).append("</em>");
        }
    }

    protected void possiblyAddDescription(StringBuilder stringBuilder) {
        if (this.desc != null) {
            stringBuilder.append("<hr><br>");
            stringBuilder.append(this.desc);
            stringBuilder.append("<br><br><br>");
        }
    }

    public void setDefinedIn(String string) {
        this.definedIn = string;
    }

    public void setDescription(String string) {
        this.desc = string;
    }

    public void setAttributes(List<? extends ParameterizedCompletion.Parameter> list) {
        this.attrs = new ArrayList<ParameterizedCompletion.Parameter>(list);
    }
}

