/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.TipUtil;
import org.fife.ui.autocomplete.Util;
import org.fife.ui.rsyntaxtextarea.PopupWindowDecorator;

public class NoMatchToolTip
implements CaretListener {
    private JWindow tooltip;
    private AutoCompletion ac;
    private Action originalEscAction;
    private Action escAction;
    private static final String ESC_KEY = "NoMatchToolTip.ESC_KEY";

    public NoMatchToolTip(Window window, AutoCompletion autoCompletion) {
        this.ac = autoCompletion;
        this.tooltip = new JWindow(window);
        JLabel jLabel = new JLabel("No Match");
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        jLabel.setOpaque(true);
        jLabel.setBackground(TipUtil.getToolTipBackground());
        jLabel.setForeground(Color.LIGHT_GRAY);
        this.tooltip.setContentPane(jLabel);
        PopupWindowDecorator popupWindowDecorator = PopupWindowDecorator.get();
        if (popupWindowDecorator != null) {
            popupWindowDecorator.decorate(this.tooltip);
        }
        this.tooltip.setFocusableWindowState(false);
        this.tooltip.pack();
    }

    public void setLocationRelativeTo(Rectangle rectangle) {
        Rectangle rectangle2 = Util.getScreenBoundsForPoint(rectangle.x, rectangle.y);
        int n = rectangle.y + rectangle.height;
        int n2 = rectangle.x;
        if (n2 < rectangle2.x) {
            n2 = rectangle2.x;
        } else if (n2 + this.tooltip.getWidth() > rectangle2.x + rectangle2.width) {
            n2 = rectangle2.x + rectangle2.width - this.tooltip.getWidth();
        }
        this.tooltip.setLocation(n2, n);
    }

    public void setVisible(boolean bl) {
        if (bl != this.tooltip.isVisible()) {
            if (bl) {
                this.install();
            } else {
                this.uninstall();
            }
            this.tooltip.setVisible(bl);
        }
    }

    private void install() {
        Object object;
        JTextComponent jTextComponent = this.ac.getTextComponent();
        if (this.escAction == null) {
            this.escAction = new EscAction();
        }
        if ((object = jTextComponent.getInputMap().get(KeyStroke.getKeyStroke(27, 0))) == null) {
            this.originalEscAction = null;
            object = ESC_KEY;
            jTextComponent.getInputMap().put(KeyStroke.getKeyStroke(27, 0), object);
        } else {
            this.originalEscAction = jTextComponent.getActionMap().get(object);
        }
        jTextComponent.getActionMap().put(object, this.escAction);
        jTextComponent.addCaretListener(this);
    }

    private void uninstall() {
        JTextComponent jTextComponent = this.ac.getTextComponent();
        if (this.originalEscAction == null) {
            jTextComponent.getInputMap().remove(KeyStroke.getKeyStroke(27, 0));
            jTextComponent.getActionMap().remove(ESC_KEY);
        } else {
            Object object = jTextComponent.getInputMap().get(KeyStroke.getKeyStroke(27, 0));
            jTextComponent.getActionMap().put(object, this.originalEscAction);
            this.originalEscAction = null;
        }
        jTextComponent.removeCaretListener(this);
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.tooltip.isVisible()) {
            this.setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.tooltip.isVisible();
    }

    private class EscAction
    extends AbstractAction {
        private EscAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            NoMatchToolTip.this.setVisible(false);
        }
    }
}

