/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.autocomplete;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.io.Serializable;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import javax.swing.text.html.HTMLDocument;
import org.fife.ui.autocomplete.Util;

class TipUtil {
    private TipUtil() {
    }

    public static Color getToolTipBackground() {
        Color color = UIManager.getColor("ToolTip.background");
        boolean bl = TipUtil.isNimbusLookAndFeel();
        if ((color == null || bl) && ((color = UIManager.getColor("info")) == null || bl && TipUtil.isDerivedColor(color))) {
            color = SystemColor.info;
        }
        if (color instanceof ColorUIResource) {
            color = new Color(color.getRGB());
        }
        return color;
    }

    public static Border getToolTipBorder() {
        Border border = UIManager.getBorder("ToolTip.border");
        if ((border == null || TipUtil.isNimbusLookAndFeel()) && (border = UIManager.getBorder("nimbusBorder")) == null) {
            border = BorderFactory.createLineBorder(SystemColor.controlDkShadow);
        }
        return border;
    }

    private static final boolean isDerivedColor(Color color) {
        return color != null && (color.getClass().getName().endsWith(".DerivedColor") || color.getClass().getName().endsWith(".DerivedColor$UIResource"));
    }

    private static final boolean isNimbusLookAndFeel() {
        return UIManager.getLookAndFeel().getName().equals("Nimbus");
    }

    public static void tweakTipEditorPane(JEditorPane jEditorPane) {
        Serializable serializable;
        Color color;
        boolean bl = TipUtil.isNimbusLookAndFeel();
        if (bl) {
            color = jEditorPane.getSelectionColor();
            serializable = jEditorPane.getSelectedTextColor();
            jEditorPane.setUI(new BasicEditorPaneUI());
            jEditorPane.setSelectedTextColor((Color)serializable);
            jEditorPane.setSelectionColor(color);
        }
        jEditorPane.setEditable(false);
        jEditorPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jEditorPane.getCaret().setSelectionVisible(true);
        color = UIManager.getColor("Label.foreground");
        if (color == null || bl && TipUtil.isDerivedColor(color)) {
            color = SystemColor.textText;
        }
        jEditorPane.setForeground(color);
        jEditorPane.setBackground(TipUtil.getToolTipBackground());
        serializable = UIManager.getFont("Label.font");
        if (serializable == null) {
            serializable = new Font("SansSerif", 0, 12);
        }
        HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
        hTMLDocument.getStyleSheet().addRule("body { font-family: " + ((Font)serializable).getFamily() + "; font-size: " + ((Font)serializable).getSize() + "pt; color: " + Util.getHexString(color) + "; }");
        Color color2 = Util.getHyperlinkForeground();
        hTMLDocument.getStyleSheet().addRule("a { color: " + Util.getHexString(color2) + "; }");
        URL uRL = TipUtil.class.getResource("bullet_black.png");
        if (uRL != null) {
            hTMLDocument.getStyleSheet().addRule("ul { list-style-image: '" + uRL.toString() + "'; }");
        }
    }
}

