/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenPainter;

class DefaultTokenPainter
implements TokenPainter {
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    private static char[] tabBuf;

    @Override
    public final float paint(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander) {
        return this.paint(token, graphics2D, f, f2, rSyntaxTextArea, tabExpander, 0.0f);
    }

    @Override
    public float paint(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f3) {
        return this.paintImpl(token, graphics2D, f, f2, rSyntaxTextArea, tabExpander, f3, false, false);
    }

    @Override
    public float paint(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f3, boolean bl) {
        return this.paintImpl(token, graphics2D, f, f2, rSyntaxTextArea, tabExpander, f3, !bl, false);
    }

    protected void paintBackground(float f, float f2, float f3, float f4, Graphics2D graphics2D, int n, RSyntaxTextArea rSyntaxTextArea, Color color) {
        graphics2D.setColor(color);
        this.bgRect.setRect(f, f2 - (float)n, f3, f4);
        graphics2D.fillRect((int)f, (int)(f2 - (float)n), (int)f3, (int)f4);
    }

    protected float paintImpl(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f3, boolean bl, boolean bl2) {
        int n = (int)f;
        int n2 = token.getTextOffset();
        char[] cArray = token.getTextArray();
        int n3 = n2 + token.length();
        float f4 = f;
        int n4 = 0;
        int n5 = n2;
        Color color = bl2 ? rSyntaxTextArea.getSelectedTextColor() : rSyntaxTextArea.getForegroundForToken(token);
        Color color2 = bl ? null : rSyntaxTextArea.getBackgroundForToken(token);
        graphics2D.setFont(rSyntaxTextArea.getFontForTokenType(token.getType()));
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(token.getType());
        block3: for (int i = n2; i < n3; ++i) {
            switch (cArray[i]) {
                case '\t': {
                    f4 = tabExpander.nextTabStop(f + (float)fontMetrics.charsWidth(cArray, n5, n4), 0);
                    if (color2 != null) {
                        this.paintBackground(f, f2, f4 - f, fontMetrics.getHeight(), graphics2D, fontMetrics.getAscent(), rSyntaxTextArea, color2);
                    }
                    if (n4 > 0) {
                        graphics2D.setColor(color);
                        this.drawChars(token, graphics2D, f, f2, rSyntaxTextArea, cArray, n4, n5);
                        n4 = 0;
                    }
                    n5 = i + 1;
                    f = f4;
                    continue block3;
                }
                default: {
                    ++n4;
                }
            }
        }
        f4 = f + (float)fontMetrics.charsWidth(cArray, n5, n4);
        Rectangle rectangle = rSyntaxTextArea.getMatchRectangle();
        if (n4 > 0 && f4 >= f3) {
            if (color2 != null) {
                this.paintBackground(f, f2, f4 - f, fontMetrics.getHeight(), graphics2D, fontMetrics.getAscent(), rSyntaxTextArea, color2);
                if (token.length() == 1 && rectangle != null && (float)rectangle.x == f) {
                    ((RSyntaxTextAreaUI)rSyntaxTextArea.getUI()).paintMatchedBracketImpl(graphics2D, rSyntaxTextArea, rectangle);
                }
            }
            graphics2D.setColor(color);
            this.drawChars(token, graphics2D, f, f2, rSyntaxTextArea, cArray, n4, n5);
        }
        if (rSyntaxTextArea.getUnderlineForToken(token)) {
            graphics2D.setColor(color);
            int n6 = (int)(f2 + 1.0f);
            graphics2D.drawLine(n, n6, (int)f4, n6);
        }
        if (rSyntaxTextArea.getPaintTabLines() && n == rSyntaxTextArea.getMargin().left) {
            this.paintTabLines(token, n, (int)f2, (int)f4, graphics2D, tabExpander, rSyntaxTextArea);
        }
        return f4;
    }

    protected void drawChars(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, char[] cArray, int n, int n2) {
        if (token.getType() == 39) {
            Element element = rSyntaxTextArea.getDocument().getDefaultRootElement();
            while (!element.isLeaf()) {
                element = element.getElement(element.getElementIndex(token.getOffset()));
            }
            AttributeSet attributeSet = element.getAttributes();
            if (attributeSet != null && attributeSet.isDefined(StyleConstants.ComposedTextAttribute)) {
                AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
                attributedString.addAttribute(TextAttribute.FONT, graphics2D.getFont());
                graphics2D.drawString(attributedString.getIterator(), f, f2);
            }
        } else {
            graphics2D.drawChars(cArray, n2, n, (int)f, (int)f2);
        }
    }

    @Override
    public float paintSelected(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, boolean bl) {
        return this.paintSelected(token, graphics2D, f, f2, rSyntaxTextArea, tabExpander, 0.0f, bl);
    }

    @Override
    public float paintSelected(Token token, Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f3, boolean bl) {
        return this.paintImpl(token, graphics2D, f, f2, rSyntaxTextArea, tabExpander, f3, true, bl);
    }

    protected void paintTabLines(Token token, int n, int n2, int n3, Graphics2D graphics2D, TabExpander tabExpander, RSyntaxTextArea rSyntaxTextArea) {
        Token token2;
        int n4;
        if (token.getType() != 21) {
            int n5;
            for (n5 = 0; n5 < token.length() && RSyntaxUtilities.isWhitespace(token.charAt(n5)); ++n5) {
            }
            if (n5 < 2) {
                return;
            }
            n3 = (int)token.getWidthUpTo(n5, rSyntaxTextArea, tabExpander, 0.0f);
        }
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(token.getType());
        int n6 = rSyntaxTextArea.getTabSize();
        if (tabBuf == null || tabBuf.length < n6) {
            tabBuf = new char[n6];
            for (n4 = 0; n4 < n6; ++n4) {
                DefaultTokenPainter.tabBuf[n4] = 32;
            }
        }
        n4 = fontMetrics.charsWidth(tabBuf, 0, n6);
        graphics2D.setColor(rSyntaxTextArea.getTabLineColor());
        int n7 = n + n4;
        int n8 = n2 - fontMetrics.getAscent();
        if ((n8 & 1) > 0) {
            ++n8;
        }
        if ((token2 = token.getNextToken()) == null || !token2.isPaintable()) {
            ++n3;
        }
        while (n7 < n3) {
            int n9 = n8 + rSyntaxTextArea.getLineHeight();
            for (int i = n8; i < n9; i += 2) {
                graphics2D.drawLine(n7, i, n7, i);
            }
            n7 += n4;
        }
    }

    @Override
    public void paintNewline(Graphics2D graphics2D, RSyntaxTextArea rSyntaxTextArea, float f, float f2, int n, int n2) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = rSyntaxTextArea.getForegroundForTokenType(21);
        color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 120);
        if (rSyntaxTextArea.getNewline(n2).equals("\r\n")) {
            int n3 = (int)f + 1;
            int n4 = n3 + 3;
            int n5 = n3 + 6;
            int n6 = (int)f2 - 5;
            int n7 = n6 - 2;
            int n8 = n6 + 2;
            int n9 = Math.max(n6 - 5, (int)f2 - n);
            graphics2D.setColor(color);
            graphics2D.drawLine(n3, n6, n4, n7);
            graphics2D.drawLine(n3, n6, n4, n8);
            graphics2D.drawLine(n3, n6, n5, n6);
            graphics2D.drawLine(n5, n6, n5, n9);
        } else {
            int n10 = (int)f + 4;
            int n11 = n10 - 2;
            int n12 = n10 + 2;
            int n13 = (int)f2 - Math.min(9, n);
            int n14 = (int)f2 - 1;
            int n15 = (int)f2 - 4;
            graphics2D.setColor(color);
            graphics2D.drawLine(n10, n13, n10, n14);
            graphics2D.drawLine(n11, n15, n10, n14);
            graphics2D.drawLine(n12, n15, n10, n14);
        }
    }
}

