/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

class MarkOccurrencesSupport
implements CaretListener,
ActionListener {
    private RSyntaxTextArea textArea;
    private Timer timer;
    private SmartHighlightPainter p;
    public static final Color DEFAULT_COLOR = new Color(224, 224, 224);
    private static final int DEFAULT_DELAY_MS = 1000;

    public MarkOccurrencesSupport() {
        this(1000);
    }

    public MarkOccurrencesSupport(int n) {
        this(n, DEFAULT_COLOR);
    }

    public MarkOccurrencesSupport(int n, Color color) {
        this.timer = new Timer(n, this);
        this.timer.setRepeats(false);
        this.p = new SmartHighlightPainter();
        this.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Caret caret = this.textArea.getCaret();
        if (caret.getDot() != caret.getMark()) {
            return;
        }
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.textArea.getDocument();
        OccurrenceMarker occurrenceMarker = rSyntaxDocument.getOccurrenceMarker();
        boolean bl = false;
        if (occurrenceMarker != null) {
            rSyntaxDocument.readLock();
            try {
                Token token = occurrenceMarker.getTokenToMark(this.textArea);
                if (token != null && occurrenceMarker.isValidType(this.textArea, token) && !RSyntaxUtilities.isNonWordChar(token)) {
                    this.clear();
                    RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
                    occurrenceMarker.markOccurrences(rSyntaxDocument, token, rSyntaxTextAreaHighlighter, this.p);
                    bl = true;
                }
            }
            finally {
                rSyntaxDocument.readUnlock();
            }
        }
        if (bl) {
            this.textArea.fireMarkedOccurrencesChanged();
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.timer.restart();
    }

    void clear() {
        if (this.textArea != null) {
            RSyntaxTextAreaHighlighter rSyntaxTextAreaHighlighter = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            rSyntaxTextAreaHighlighter.clearMarkOccurrencesHighlights();
        }
    }

    public void doMarkOccurrences() {
        this.timer.stop();
        this.actionPerformed(null);
    }

    public Color getColor() {
        return (Color)this.p.getPaint();
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public boolean getPaintBorder() {
        return this.p.getPaintBorder();
    }

    public void install(RSyntaxTextArea rSyntaxTextArea) {
        if (this.textArea != null) {
            this.uninstall();
        }
        this.textArea = rSyntaxTextArea;
        rSyntaxTextArea.addCaretListener(this);
        if (rSyntaxTextArea.getMarkOccurrencesColor() != null) {
            this.setColor(rSyntaxTextArea.getMarkOccurrencesColor());
        }
    }

    public void setColor(Color color) {
        this.p.setPaint(color);
        if (this.textArea != null) {
            this.clear();
            this.caretUpdate(null);
        }
    }

    public void setDelay(int n) {
        this.timer.setDelay(n);
    }

    public void setPaintBorder(boolean bl) {
        if (bl != this.p.getPaintBorder()) {
            this.p.setPaintBorder(bl);
            if (this.textArea != null) {
                this.textArea.repaint();
            }
        }
    }

    public void uninstall() {
        if (this.textArea != null) {
            this.timer.stop();
            this.clear();
            this.textArea.removeCaretListener(this);
        }
    }
}

