/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.AWTPermission;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import org.fife.ui.rsyntaxtextarea.ActiveLineRangeEvent;
import org.fife.ui.rsyntaxtextarea.ActiveLineRangeListener;
import org.fife.ui.rsyntaxtextarea.CodeTemplateManager;
import org.fife.ui.rsyntaxtextarea.DefaultTokenPainter;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesSupport;
import org.fife.ui.rsyntaxtextarea.ParserManager;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaUI;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.RtfGenerator;
import org.fife.ui.rsyntaxtextarea.RtfTransferable;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.SyntaxView;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenPainter;
import org.fife.ui.rsyntaxtextarea.VisibleWhitespaceTokenPainter;
import org.fife.ui.rsyntaxtextarea.focusabletip.FocusableTip;
import org.fife.ui.rsyntaxtextarea.folding.DefaultFoldManager;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ToolTipInfo;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaBase;
import org.fife.ui.rtextarea.RTextAreaUI;
import org.fife.ui.rtextarea.RecordableTextAction;

public class RSyntaxTextArea
extends RTextArea
implements SyntaxConstants {
    public static final String ANIMATE_BRACKET_MATCHING_PROPERTY = "RSTA.animateBracketMatching";
    public static final String ANTIALIAS_PROPERTY = "RSTA.antiAlias";
    public static final String AUTO_INDENT_PROPERTY = "RSTA.autoIndent";
    public static final String BRACKET_MATCHING_PROPERTY = "RSTA.bracketMatching";
    public static final String CLEAR_WHITESPACE_LINES_PROPERTY = "RSTA.clearWhitespaceLines";
    public static final String CLOSE_CURLY_BRACES_PROPERTY = "RSTA.closeCurlyBraces";
    public static final String CLOSE_MARKUP_TAGS_PROPERTY = "RSTA.closeMarkupTags";
    public static final String CODE_FOLDING_PROPERTY = "RSTA.codeFolding";
    public static final String EOL_VISIBLE_PROPERTY = "RSTA.eolMarkersVisible";
    public static final String FOCUSABLE_TIPS_PROPERTY = "RSTA.focusableTips";
    public static final String FRACTIONAL_FONTMETRICS_PROPERTY = "RSTA.fractionalFontMetrics";
    public static final String HIGHLIGHT_SECONDARY_LANGUAGES_PROPERTY = "RSTA.highlightSecondaryLanguages";
    public static final String HYPERLINKS_ENABLED_PROPERTY = "RSTA.hyperlinksEnabled";
    public static final String MARK_OCCURRENCES_PROPERTY = "RSTA.markOccurrences";
    public static final String MARKED_OCCURRENCES_CHANGED_PROPERTY = "RSTA.markedOccurrencesChanged";
    public static final String PAINT_MATCHED_BRACKET_PAIR_PROPERTY = "RSTA.paintMatchedBracketPair";
    public static final String PARSER_NOTICES_PROPERTY = "RSTA.parserNotices";
    public static final String SYNTAX_SCHEME_PROPERTY = "RSTA.syntaxScheme";
    public static final String SYNTAX_STYLE_PROPERTY = "RSTA.syntaxStyle";
    public static final String TAB_LINE_COLOR_PROPERTY = "RSTA.tabLineColor";
    public static final String TAB_LINES_PROPERTY = "RSTA.tabLines";
    public static final String USE_SELECTED_TEXT_COLOR_PROPERTY = "RSTA.useSelectedTextColor";
    public static final String VISIBLE_WHITESPACE_PROPERTY = "RSTA.visibleWhitespace";
    private static final Color DEFAULT_BRACKET_MATCH_BG_COLOR = new Color(234, 234, 255);
    private static final Color DEFAULT_BRACKET_MATCH_BORDER_COLOR = new Color(0, 0, 128);
    private static final Color DEFAULT_SELECTION_COLOR = new Color(200, 200, 255);
    private static final String MSG = "org.fife.ui.rsyntaxtextarea.RSyntaxTextArea";
    private JMenu foldingMenu;
    private static RecordableTextAction toggleCurrentFoldAction;
    private static RecordableTextAction collapseAllCommentFoldsAction;
    private static RecordableTextAction collapseAllFoldsAction;
    private static RecordableTextAction expandAllFoldsAction;
    private String syntaxStyleKey;
    private SyntaxScheme syntaxScheme;
    private static CodeTemplateManager codeTemplateManager;
    private static boolean templatesEnabled;
    private Rectangle match;
    private Rectangle dotRect;
    private Point bracketInfo;
    private Color matchedBracketBGColor;
    private Color matchedBracketBorderColor;
    private int lastBracketMatchPos;
    private boolean bracketMatchingEnabled;
    private boolean animateBracketMatching;
    private boolean paintMatchedBracketPair;
    private BracketMatchingTimer bracketRepaintTimer;
    private boolean metricsNeverRefreshed;
    private boolean autoIndentEnabled;
    private boolean closeCurlyBraces;
    private boolean closeMarkupTags;
    private boolean clearWhitespaceLines;
    private boolean whitespaceVisible;
    private boolean eolMarkersVisible;
    private boolean paintTabLines;
    private Color tabLineColor;
    private boolean hyperlinksEnabled;
    private Color hyperlinkFG;
    private int linkScanningMask;
    private boolean highlightSecondaryLanguages;
    private boolean useSelectedTextColor;
    private MarkOccurrencesSupport markOccurrencesSupport;
    private Color markOccurrencesColor;
    private boolean paintMarkOccurrencesBorder;
    private FontMetrics defaultFontMetrics;
    private ParserManager parserManager;
    private String cachedTip;
    private Point cachedTipLoc;
    private boolean isScanningForLinks;
    private int hoveredOverLinkOffset;
    private LinkGenerator linkGenerator;
    private LinkGeneratorResult linkGeneratorResult;
    private int rhsCorrection;
    private FoldManager foldManager;
    private boolean useFocusableTips;
    private FocusableTip focusableTip;
    private Map<?, ?> aaHints;
    private TokenPainter tokenPainter;
    private int lineHeight;
    private int maxAscent;
    private boolean fractionalFontMetricsEnabled;
    private Color[] secondaryLanguageBackgrounds;
    private String newline = "\n";
    private List<int[]> crlfRanges;

    public RSyntaxTextArea() {
    }

    public RSyntaxTextArea(RSyntaxDocument rSyntaxDocument) {
        super(rSyntaxDocument);
        this.setSyntaxEditingStyle(rSyntaxDocument.getSyntaxStyle());
    }

    public RSyntaxTextArea(String string) {
        super(string);
    }

    public RSyntaxTextArea(int n, int n2) {
        super(n, n2);
    }

    public RSyntaxTextArea(String string, int n, int n2) {
        super(string, n, n2);
    }

    public RSyntaxTextArea(RSyntaxDocument rSyntaxDocument, String string, int n, int n2) {
        super(rSyntaxDocument, string, n, n2);
    }

    public RSyntaxTextArea(int n) {
        super(n);
    }

    public void addActiveLineRangeListener(ActiveLineRangeListener activeLineRangeListener) {
        this.listenerList.add(ActiveLineRangeListener.class, activeLineRangeListener);
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(HyperlinkListener.class, hyperlinkListener);
    }

    @Override
    public void addNotify() {
        Window window;
        super.addNotify();
        if (this.metricsNeverRefreshed && (window = SwingUtilities.getWindowAncestor(this)) != null && window.getWidth() > 0 && window.getHeight() > 0) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            this.metricsNeverRefreshed = false;
        }
        if (this.parserManager != null) {
            this.parserManager.restartParsing();
        }
    }

    public void addParser(Parser parser) {
        if (this.parserManager == null) {
            this.parserManager = new ParserManager(this);
        }
        this.parserManager.addParser(parser);
    }

    public void reparse() {
        if (this.parserManager != null) {
            this.parserManager.restartParsing();
        }
    }

    protected void appendFoldingMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.addSeparator();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MSG);
        this.foldingMenu = new JMenu(resourceBundle.getString("ContextMenu.Folding"));
        this.foldingMenu.add(this.createPopupMenuItem(toggleCurrentFoldAction));
        this.foldingMenu.add(this.createPopupMenuItem(collapseAllCommentFoldsAction));
        this.foldingMenu.add(this.createPopupMenuItem(collapseAllFoldsAction));
        this.foldingMenu.add(this.createPopupMenuItem(expandAllFoldsAction));
        jPopupMenu.add(this.foldingMenu);
    }

    private void calculateLineHeight() {
        int n;
        Object object;
        this.maxAscent = 0;
        this.lineHeight = 0;
        for (int i = 0; i < this.syntaxScheme.getStyleCount(); ++i) {
            int n2;
            object = this.syntaxScheme.getStyle(i);
            if (object == null || ((Style)object).font == null) continue;
            FontMetrics fontMetrics = this.getFontMetrics(((Style)object).font);
            n = fontMetrics.getHeight();
            if (n > this.lineHeight) {
                this.lineHeight = n;
            }
            if ((n2 = fontMetrics.getMaxAscent()) <= this.maxAscent) continue;
            this.maxAscent = n2;
        }
        Font font = this.getFont();
        object = this.getFontMetrics(font);
        int n3 = ((FontMetrics)object).getHeight();
        if (n3 > this.lineHeight) {
            this.lineHeight = n3;
        }
        if ((n = ((FontMetrics)object).getMaxAscent()) > this.maxAscent) {
            this.maxAscent = n;
        }
    }

    public void clearParsers() {
        if (this.parserManager != null) {
            this.parserManager.clearParsers();
        }
    }

    private TokenImpl cloneTokenList(Token token) {
        TokenImpl tokenImpl;
        if (token == null) {
            return null;
        }
        TokenImpl tokenImpl2 = tokenImpl = new TokenImpl(token);
        while ((token = token.getNextToken()) != null) {
            TokenImpl tokenImpl3 = new TokenImpl(token);
            tokenImpl2.setNextToken(tokenImpl3);
            tokenImpl2 = tokenImpl3;
        }
        return tokenImpl;
    }

    @Override
    protected void configurePopupMenu(JPopupMenu jPopupMenu) {
        super.configurePopupMenu(jPopupMenu);
        if (jPopupMenu != null && jPopupMenu.getComponentCount() > 0 && this.foldingMenu != null) {
            this.foldingMenu.setEnabled(this.foldManager.isCodeFoldingSupportedAndEnabled());
        }
    }

    public void copyAsRtf() {
        Object object;
        int n;
        int n2 = this.getSelectionStart();
        if (n2 == (n = this.getSelectionEnd())) {
            return;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new AWTPermission("accessClipboard"));
            }
            catch (SecurityException securityException) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
                return;
            }
        }
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        RtfGenerator rtfGenerator = new RtfGenerator();
        Token token = this.getTokenListFor(n2, n);
        for (object = token; object != null; object = object.getNextToken()) {
            if (!object.isPaintable()) continue;
            if (object.length() == 1 && object.charAt(0) == '\n') {
                rtfGenerator.appendNewline();
                continue;
            }
            Font font = this.getFontForTokenType(object.getType());
            Color color = this.getBackgroundForToken((Token)object);
            boolean bl = this.getUnderlineForToken((Token)object);
            if (object.isWhitespace()) {
                rtfGenerator.appendToDocNoFG(object.getLexeme(), font, color, bl);
                continue;
            }
            Color color2 = this.getForegroundForToken((Token)object);
            rtfGenerator.appendToDoc(object.getLexeme(), font, color2, color, bl);
        }
        object = new RtfTransferable(rtfGenerator.getRtf().getBytes());
        try {
            clipboard.setContents((Transferable)object, null);
        }
        catch (IllegalStateException illegalStateException) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return;
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new RSyntaxDocument("text/plain");
    }

    @Override
    protected RTextAreaBase.RTAMouseListener createMouseListener() {
        return new RSyntaxTextAreaMutableCaretEvent((RTextArea)this);
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = super.createPopupMenu();
        this.appendFoldingMenu(jPopupMenu);
        return jPopupMenu;
    }

    private static void createRstaPopupMenuActions() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MSG);
        toggleCurrentFoldAction = new RSyntaxTextAreaEditorKit.ToggleCurrentFoldAction();
        toggleCurrentFoldAction.setProperties(resourceBundle, "Action.ToggleCurrentFold");
        collapseAllCommentFoldsAction = new RSyntaxTextAreaEditorKit.CollapseAllCommentFoldsAction();
        collapseAllCommentFoldsAction.setProperties(resourceBundle, "Action.CollapseCommentFolds");
        collapseAllFoldsAction = new RSyntaxTextAreaEditorKit.CollapseAllFoldsAction(true);
        expandAllFoldsAction = new RSyntaxTextAreaEditorKit.ExpandAllFoldsAction(true);
    }

    @Override
    protected RTextAreaUI createRTextAreaUI() {
        return new RSyntaxTextAreaUI(this);
    }

    protected final void doBracketMatching() {
        block9: {
            if (this.match != null) {
                this.repaint(this.match);
                if (this.dotRect != null) {
                    this.repaint(this.dotRect);
                }
            }
            int n = this.bracketInfo == null ? -1 : this.bracketInfo.x;
            this.bracketInfo = RSyntaxUtilities.getMatchingBracketPosition(this, this.bracketInfo);
            if (this.bracketInfo.y > -1 && (this.bracketInfo.y != this.lastBracketMatchPos || this.bracketInfo.x != n)) {
                try {
                    this.match = this.modelToView(this.bracketInfo.y);
                    if (this.match == null) break block9;
                    this.dotRect = this.getPaintMatchedBracketPair() ? this.modelToView(this.bracketInfo.x) : null;
                    if (this.getAnimateBracketMatching()) {
                        this.bracketRepaintTimer.restart();
                    }
                    this.repaint(this.match);
                    if (this.dotRect != null) {
                        this.repaint(this.dotRect);
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            } else if (this.bracketInfo.y == -1) {
                this.match = null;
                this.dotRect = null;
                this.bracketRepaintTimer.stop();
            }
        }
        this.lastBracketMatchPos = this.bracketInfo.y;
    }

    @Override
    protected void fireCaretUpdate(CaretEvent caretEvent) {
        super.fireCaretUpdate(caretEvent);
        if (this.isBracketMatchingEnabled()) {
            this.doBracketMatching();
        }
    }

    private void fireActiveLineRangeEvent(int n, int n2) {
        ActiveLineRangeEvent activeLineRangeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ActiveLineRangeListener.class) continue;
            if (activeLineRangeEvent == null) {
                activeLineRangeEvent = new ActiveLineRangeEvent(this, n, n2);
            }
            ((ActiveLineRangeListener)objectArray[i + 1]).activeLineRangeChanged(activeLineRangeEvent);
        }
    }

    private void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HyperlinkListener.class) continue;
            ((HyperlinkListener)objectArray[i + 1]).hyperlinkUpdate(hyperlinkEvent);
        }
    }

    void fireMarkedOccurrencesChanged() {
        this.firePropertyChange(MARKED_OCCURRENCES_CHANGED_PROPERTY, null, null);
    }

    void fireParserNoticesChange() {
        this.firePropertyChange(PARSER_NOTICES_PROPERTY, null, null);
    }

    public void foldToggled(Fold fold) {
        this.match = null;
        this.dotRect = null;
        if (this.getLineWrap()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RSyntaxTextArea.this.possiblyUpdateCurrentLineHighlightLocation();
                }
            });
        } else {
            this.possiblyUpdateCurrentLineHighlightLocation();
        }
        this.revalidate();
        this.repaint();
    }

    public void forceReparsing(int n) {
        this.parserManager.forceReparsing(n);
    }

    public boolean forceReparsing(Parser parser) {
        for (int i = 0; i < this.getParserCount(); ++i) {
            if (this.getParser(i) != parser) continue;
            this.forceReparsing(i);
            return true;
        }
        return false;
    }

    public boolean getAnimateBracketMatching() {
        return this.animateBracketMatching;
    }

    public boolean getAntiAliasingEnabled() {
        return this.aaHints != null;
    }

    public Color getBackgroundForToken(Token token) {
        int n;
        Color color = null;
        if (this.getHighlightSecondaryLanguages() && (n = token.getLanguageIndex() - 1) >= 0 && n < this.secondaryLanguageBackgrounds.length) {
            color = this.secondaryLanguageBackgrounds[n];
        }
        if (color == null) {
            color = this.syntaxScheme.getStyle((int)token.getType()).background;
        }
        return color;
    }

    public boolean getCloseCurlyBraces() {
        return this.closeCurlyBraces;
    }

    public boolean getCloseMarkupTags() {
        return this.closeMarkupTags;
    }

    public static synchronized CodeTemplateManager getCodeTemplateManager() {
        if (codeTemplateManager == null) {
            codeTemplateManager = new CodeTemplateManager();
        }
        return codeTemplateManager;
    }

    public static final Color getDefaultBracketMatchBGColor() {
        return DEFAULT_BRACKET_MATCH_BG_COLOR;
    }

    public static final Color getDefaultBracketMatchBorderColor() {
        return DEFAULT_BRACKET_MATCH_BORDER_COLOR;
    }

    public static Color getDefaultSelectionColor() {
        return DEFAULT_SELECTION_COLOR;
    }

    public SyntaxScheme getDefaultSyntaxScheme() {
        return new SyntaxScheme(this.getFont());
    }

    public boolean getEOLMarkersVisible() {
        return this.eolMarkersVisible;
    }

    public FoldManager getFoldManager() {
        return this.foldManager;
    }

    public Font getFontForTokenType(int n) {
        Font font = this.syntaxScheme.getStyle((int)n).font;
        return font != null ? font : this.getFont();
    }

    public FontMetrics getFontMetricsForTokenType(int n) {
        FontMetrics fontMetrics = this.syntaxScheme.getStyle((int)n).fontMetrics;
        return fontMetrics != null ? fontMetrics : this.defaultFontMetrics;
    }

    public Color getForegroundForToken(Token token) {
        if (this.getHyperlinksEnabled() && this.hoveredOverLinkOffset == token.getOffset() && (token.isHyperlink() || this.linkGeneratorResult != null)) {
            return this.hyperlinkFG;
        }
        return this.getForegroundForTokenType(token.getType());
    }

    public Color getForegroundForTokenType(int n) {
        Color color = this.syntaxScheme.getStyle((int)n).foreground;
        return color != null ? color : this.getForeground();
    }

    public boolean getFractionalFontMetricsEnabled() {
        return this.fractionalFontMetricsEnabled;
    }

    private final Graphics2D getGraphics2D(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.aaHints != null) {
            graphics2D.addRenderingHints(this.aaHints);
        }
        if (this.fractionalFontMetricsEnabled) {
            graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        return graphics2D;
    }

    public boolean getHighlightSecondaryLanguages() {
        return this.highlightSecondaryLanguages;
    }

    public Color getHyperlinkForeground() {
        return this.hyperlinkFG;
    }

    public boolean getHyperlinksEnabled() {
        return this.hyperlinksEnabled;
    }

    public int getLastVisibleOffset() {
        int n;
        if (this.isCodeFoldingEnabled() && (n = this.foldManager.getLastVisibleLine()) < this.getLineCount() - 1) {
            try {
                return this.getLineEndOffset(n) - 1;
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return this.getDocument().getLength();
    }

    @Override
    public int getLineHeight() {
        return this.lineHeight;
    }

    public LinkGenerator getLinkGenerator() {
        return this.linkGenerator;
    }

    public List<DocumentRange> getMarkAllHighlightRanges() {
        return ((RSyntaxTextAreaHighlighter)this.getHighlighter()).getMarkAllHighlightRanges();
    }

    public List<DocumentRange> getMarkedOccurrences() {
        return ((RSyntaxTextAreaHighlighter)this.getHighlighter()).getMarkedOccurrences();
    }

    public boolean getMarkOccurrences() {
        return this.markOccurrencesSupport != null;
    }

    public Color getMarkOccurrencesColor() {
        return this.markOccurrencesColor;
    }

    boolean getMarkOccurrencesOfTokenType(int n) {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
        return rSyntaxDocument.getMarkOccurrencesOfTokenType(n);
    }

    public Color getMatchedBracketBGColor() {
        return this.matchedBracketBGColor;
    }

    public Color getMatchedBracketBorderColor() {
        return this.matchedBracketBorderColor;
    }

    Rectangle getDotRectangle() {
        return this.dotRect;
    }

    Rectangle getMatchRectangle() {
        return this.match;
    }

    @Override
    public int getMaxAscent() {
        return this.maxAscent;
    }

    public boolean getPaintMatchedBracketPair() {
        return this.paintMatchedBracketPair;
    }

    public boolean getPaintTabLines() {
        return this.paintTabLines;
    }

    boolean getPaintTokenBackgrounds(int n, float f) {
        int n2 = (int)f;
        int n3 = this.getCurrentCaretY();
        return n2 < n3 || n2 >= n3 + this.getLineHeight() || !this.getHighlightCurrentLine();
    }

    public Parser getParser(int n) {
        return this.parserManager.getParser(n);
    }

    public int getParserCount() {
        return this.parserManager == null ? 0 : this.parserManager.getParserCount();
    }

    public int getParserDelay() {
        return this.parserManager.getDelay();
    }

    public List<ParserNotice> getParserNotices() {
        if (this.parserManager == null) {
            return Collections.emptyList();
        }
        return this.parserManager.getParserNotices();
    }

    public int getRightHandSideCorrection() {
        return this.rhsCorrection;
    }

    public boolean getShouldIndentNextLine(int n) {
        if (this.isAutoIndentEnabled()) {
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)this.getDocument();
            return rSyntaxDocument.getShouldIndentNextLine(n);
        }
        return false;
    }

    public String getSyntaxEditingStyle() {
        return this.syntaxStyleKey;
    }

    public SyntaxScheme getSyntaxScheme() {
        return this.syntaxScheme;
    }

    public Color getTabLineColor() {
        return this.tabLineColor;
    }

    public boolean getPaintMarkOccurrencesBorder() {
        return this.paintMarkOccurrencesBorder;
    }

    public Color getSecondaryLanguageBackground(int n) {
        return this.secondaryLanguageBackgrounds[n - 1];
    }

    public int getSecondaryLanguageCount() {
        return this.secondaryLanguageBackgrounds.length;
    }

    public static synchronized boolean getTemplatesEnabled() {
        return templatesEnabled;
    }

    private Token getTokenListFor(int n, int n2) {
        TokenImpl tokenImpl;
        TokenImpl tokenImpl2 = null;
        TokenImpl tokenImpl3 = null;
        Element element = this.getDocument().getDefaultRootElement();
        int n3 = element.getElementIndex(n);
        int n4 = element.getElementIndex(n2);
        for (int i = n3; i <= n4; ++i) {
            TokenImpl tokenImpl4 = (TokenImpl)this.getTokenListForLine(i);
            tokenImpl4 = this.cloneTokenList(tokenImpl4);
            if (tokenImpl2 == null) {
                tokenImpl3 = tokenImpl2 = tokenImpl4;
            } else {
                tokenImpl3.setNextToken(tokenImpl4);
            }
            while (tokenImpl3.getNextToken() != null && tokenImpl3.getNextToken().isPaintable()) {
                tokenImpl3 = (TokenImpl)tokenImpl3.getNextToken();
            }
            if (i >= n4) continue;
            int n5 = element.getElement(i).getEndOffset() - 1;
            tokenImpl4 = new TokenImpl(new char[]{'\n'}, 0, 0, n5, 21, 0);
            tokenImpl3.setNextToken(tokenImpl4);
            tokenImpl3 = tokenImpl4;
        }
        if (n >= tokenImpl2.getOffset()) {
            while (!tokenImpl2.containsPosition(n)) {
                tokenImpl2 = (TokenImpl)tokenImpl2.getNextToken();
            }
            tokenImpl2.makeStartAt(n);
        }
        for (tokenImpl = tokenImpl2; tokenImpl != null && !tokenImpl.containsPosition(n2); tokenImpl = (TokenImpl)tokenImpl.getNextToken()) {
        }
        if (tokenImpl != null) {
            tokenImpl.textCount = n2 - tokenImpl.getOffset();
            tokenImpl.setNextToken(null);
        }
        return tokenImpl2;
    }

    public Token getTokenListForLine(int n) {
        return ((RSyntaxDocument)this.getDocument()).getTokenListForLine(n);
    }

    TokenPainter getTokenPainter() {
        return this.tokenPainter;
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        if (RSyntaxUtilities.getOS() == 2) {
            Point point = mouseEvent.getPoint();
            if (point != null && point.equals(this.cachedTipLoc)) {
                return this.cachedTip;
            }
            this.cachedTipLoc = point;
        }
        this.cachedTip = this.getToolTipTextImpl(mouseEvent);
        return this.cachedTip;
    }

    protected String getToolTipTextImpl(MouseEvent mouseEvent) {
        ToolTipInfo toolTipInfo;
        String string = null;
        URL uRL = null;
        if (this.parserManager != null && (toolTipInfo = this.parserManager.getToolTipText(mouseEvent)) != null) {
            string = toolTipInfo.getToolTipText();
            uRL = toolTipInfo.getImageBase();
        }
        if (string == null) {
            string = super.getToolTipText(mouseEvent);
        }
        if (this.getUseFocusableTips()) {
            if (string != null) {
                if (this.focusableTip == null) {
                    this.focusableTip = new FocusableTip(this, this.parserManager);
                }
                this.focusableTip.setImageBase(uRL);
                this.focusableTip.toolTipRequested(mouseEvent, string);
            } else if (this.focusableTip != null) {
                this.focusableTip.possiblyDisposeOfTipWindow();
            }
            return null;
        }
        return string;
    }

    public boolean getUnderlineForToken(Token token) {
        return this.getHyperlinksEnabled() && (token.isHyperlink() || this.linkGeneratorResult != null && this.linkGeneratorResult.getSourceOffset() == token.getOffset()) || this.syntaxScheme.getStyle((int)token.getType()).underline;
    }

    public boolean getUseFocusableTips() {
        return this.useFocusableTips;
    }

    public boolean getUseSelectedTextColor() {
        return this.useSelectedTextColor;
    }

    @Override
    protected void init() {
        super.init();
        this.metricsNeverRefreshed = true;
        this.tokenPainter = new DefaultTokenPainter();
        if (toggleCurrentFoldAction == null) {
            RSyntaxTextArea.createRstaPopupMenuActions();
        }
        this.syntaxStyleKey = "text/plain";
        this.setMatchedBracketBGColor(RSyntaxTextArea.getDefaultBracketMatchBGColor());
        this.setMatchedBracketBorderColor(RSyntaxTextArea.getDefaultBracketMatchBorderColor());
        this.setBracketMatchingEnabled(true);
        this.setAnimateBracketMatching(true);
        this.lastBracketMatchPos = -1;
        this.setSelectionColor(RSyntaxTextArea.getDefaultSelectionColor());
        this.setTabLineColor(null);
        this.setMarkOccurrencesColor(MarkOccurrencesSupport.DEFAULT_COLOR);
        this.foldManager = new DefaultFoldManager(this);
        this.setAutoIndentEnabled(true);
        this.setCloseCurlyBraces(true);
        this.setCloseMarkupTags(true);
        this.setClearWhitespaceLinesEnabled(true);
        this.setHyperlinksEnabled(true);
        this.setLinkScanningMask(128);
        this.setHyperlinkForeground(Color.BLUE);
        this.isScanningForLinks = false;
        this.setUseFocusableTips(true);
        this.setDefaultAntiAliasingState();
        this.restoreDefaultSyntaxScheme();
        this.setHighlightSecondaryLanguages(true);
        this.secondaryLanguageBackgrounds = new Color[3];
        this.secondaryLanguageBackgrounds[0] = new Color(0xFFF0CC);
        this.secondaryLanguageBackgrounds[1] = new Color(14352090);
        this.secondaryLanguageBackgrounds[2] = new Color(0xFFE0F0);
        this.setRightHandSideCorrection(0);
    }

    public boolean isAutoIndentEnabled() {
        return this.autoIndentEnabled;
    }

    public final boolean isBracketMatchingEnabled() {
        return this.bracketMatchingEnabled;
    }

    public boolean isClearWhitespaceLinesEnabled() {
        return this.clearWhitespaceLines;
    }

    public boolean isCodeFoldingEnabled() {
        return this.foldManager.isCodeFoldingEnabled();
    }

    public boolean isWhitespaceVisible() {
        return this.whitespaceVisible;
    }

    public Token modelToToken(int n) {
        if (n >= 0) {
            try {
                int n2 = this.getLineOfOffset(n);
                Token token = this.getTokenListForLine(n2);
                return RSyntaxUtilities.getTokenAtOffset(token, n);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.metricsNeverRefreshed) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            this.metricsNeverRefreshed = false;
        }
        super.paintComponent(this.getGraphics2D(graphics));
    }

    private void refreshFontMetrics(Graphics2D graphics2D) {
        this.defaultFontMetrics = graphics2D.getFontMetrics(this.getFont());
        this.syntaxScheme.refreshFontMetrics(graphics2D);
        if (!this.getLineWrap()) {
            SyntaxView syntaxView = (SyntaxView)this.getUI().getRootView(this).getView(0);
            syntaxView.calculateLongestLine();
        }
    }

    @Override
    public void redoLastAction() {
        super.redoLastAction();
        ((RSyntaxTextAreaHighlighter)this.getHighlighter()).clearMarkOccurrencesHighlights();
    }

    public void removeActiveLineRangeListener(ActiveLineRangeListener activeLineRangeListener) {
        this.listenerList.remove(ActiveLineRangeListener.class, activeLineRangeListener);
    }

    public void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(HyperlinkListener.class, hyperlinkListener);
    }

    @Override
    public void removeNotify() {
        if (this.parserManager != null) {
            this.parserManager.stopParsing();
        }
        super.removeNotify();
    }

    public boolean removeParser(Parser parser) {
        boolean bl = false;
        if (this.parserManager != null) {
            bl = this.parserManager.removeParser(parser);
        }
        return bl;
    }

    public void restoreDefaultSyntaxScheme() {
        this.setSyntaxScheme(this.getDefaultSyntaxScheme());
    }

    public static synchronized boolean saveTemplates() {
        if (!RSyntaxTextArea.getTemplatesEnabled()) {
            return false;
        }
        return RSyntaxTextArea.getCodeTemplateManager().saveTemplates();
    }

    public void setActiveLineRange(int n, int n2) {
        if (n == -1) {
            n2 = -1;
        }
        this.fireActiveLineRangeEvent(n, n2);
    }

    public void setAnimateBracketMatching(boolean bl) {
        if (bl != this.animateBracketMatching) {
            this.animateBracketMatching = bl;
            if (bl && this.bracketRepaintTimer == null) {
                this.bracketRepaintTimer = new BracketMatchingTimer();
            }
            this.firePropertyChange(ANIMATE_BRACKET_MATCHING_PROPERTY, !bl, bl);
        }
    }

    public void setAntiAliasingEnabled(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.aaHints != null;
        if (bl != bl2) {
            if (bl) {
                this.aaHints = RSyntaxUtilities.getDesktopAntiAliasHints();
                if (this.aaHints == null) {
                    HashMap hashMap = new HashMap();
                    hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    this.aaHints = hashMap;
                }
            } else {
                this.aaHints = null;
            }
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(ANTIALIAS_PROPERTY, !bl, bl);
            this.repaint();
        }
    }

    public void setAutoIndentEnabled(boolean bl) {
        if (this.autoIndentEnabled != bl) {
            this.autoIndentEnabled = bl;
            this.firePropertyChange(AUTO_INDENT_PROPERTY, !bl, bl);
        }
    }

    public void setBracketMatchingEnabled(boolean bl) {
        if (bl != this.bracketMatchingEnabled) {
            this.bracketMatchingEnabled = bl;
            this.repaint();
            this.firePropertyChange(BRACKET_MATCHING_PROPERTY, !bl, bl);
        }
    }

    public void setClearWhitespaceLinesEnabled(boolean bl) {
        if (bl != this.clearWhitespaceLines) {
            this.clearWhitespaceLines = bl;
            this.firePropertyChange(CLEAR_WHITESPACE_LINES_PROPERTY, !bl, bl);
        }
    }

    public void setCloseCurlyBraces(boolean bl) {
        if (bl != this.closeCurlyBraces) {
            this.closeCurlyBraces = bl;
            this.firePropertyChange(CLOSE_CURLY_BRACES_PROPERTY, !bl, bl);
        }
    }

    public void setCloseMarkupTags(boolean bl) {
        if (bl != this.closeMarkupTags) {
            this.closeMarkupTags = bl;
            this.firePropertyChange(CLOSE_MARKUP_TAGS_PROPERTY, !bl, bl);
        }
    }

    public void setCodeFoldingEnabled(boolean bl) {
        if (bl != this.foldManager.isCodeFoldingEnabled()) {
            this.foldManager.setCodeFoldingEnabled(bl);
            this.firePropertyChange(CODE_FOLDING_PROPERTY, !bl, bl);
        }
    }

    private final void setDefaultAntiAliasingState() {
        this.aaHints = RSyntaxUtilities.getDesktopAntiAliasHints();
        if (this.aaHints == null) {
            Object object;
            HashMap hashMap = new HashMap();
            JLabel jLabel = new JLabel();
            FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
            Object object2 = null;
            try {
                object = FontMetrics.class.getMethod("getFontRenderContext", new Class[0]);
                FontRenderContext fontRenderContext = (FontRenderContext)((Method)object).invoke((Object)fontMetrics, new Object[0]);
                object = FontRenderContext.class.getMethod("getAntiAliasingHint", new Class[0]);
                object2 = ((Method)object).invoke((Object)fontRenderContext, new Object[0]);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object2 == null) {
                object = System.getProperty("os.name").toLowerCase();
                object2 = ((String)object).contains("windows") ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            }
            hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, object2);
            this.aaHints = hashMap;
        }
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
        }
        this.repaint();
    }

    @Override
    public void setDocument(Document document) {
        if (!(document instanceof RSyntaxDocument)) {
            throw new IllegalArgumentException("Documents for RSyntaxTextArea must be instances of RSyntaxDocument!");
        }
        if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.clear();
        }
        super.setDocument(document);
        this.setSyntaxEditingStyle(((RSyntaxDocument)document).getSyntaxStyle());
        if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.doMarkOccurrences();
        }
    }

    public void setEOLMarkersVisible(boolean bl) {
        if (bl != this.eolMarkersVisible) {
            this.eolMarkersVisible = bl;
            this.repaint();
            this.firePropertyChange(EOL_VISIBLE_PROPERTY, !bl, bl);
        }
    }

    public void setNewline(String string) {
        if (!this.newline.equals(string)) {
            this.newline = string;
            this.repaint();
        }
    }

    public void setCrlfRanges(List<int[]> list) {
        this.crlfRanges = list;
    }

    public String getNewline(int n) {
        if (this.crlfRanges == null) {
            return this.newline;
        }
        for (int[] nArray : this.crlfRanges) {
            if (n < nArray[0] || n > nArray[1]) continue;
            return "\r\n";
        }
        return "\n";
    }

    @Override
    public void setFont(Font font) {
        Font font2 = super.getFont();
        super.setFont(font);
        SyntaxScheme syntaxScheme = this.getSyntaxScheme();
        if (syntaxScheme != null && font2 != null) {
            syntaxScheme.changeBaseFont(font2, font);
            this.calculateLineHeight();
        }
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            this.updateMarginLineX();
            this.forceCurrentLineHighlightRepaint();
            this.firePropertyChange("font", font2, font);
            this.revalidate();
        }
    }

    public void setFractionalFontMetricsEnabled(boolean bl) {
        if (this.fractionalFontMetricsEnabled != bl) {
            this.fractionalFontMetricsEnabled = bl;
            if (this.isDisplayable()) {
                this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
            }
            this.firePropertyChange(FRACTIONAL_FONTMETRICS_PROPERTY, !bl, bl);
        }
    }

    @Override
    public void setHighlighter(Highlighter highlighter) {
        if (!(highlighter instanceof RSyntaxTextAreaHighlighter)) {
            throw new IllegalArgumentException("RSyntaxTextArea requires an RSyntaxTextAreaHighlighter for its Highlighter");
        }
        super.setHighlighter(highlighter);
    }

    public void setHighlightSecondaryLanguages(boolean bl) {
        if (this.highlightSecondaryLanguages != bl) {
            this.highlightSecondaryLanguages = bl;
            this.repaint();
            this.firePropertyChange(HIGHLIGHT_SECONDARY_LANGUAGES_PROPERTY, !bl, bl);
        }
    }

    public void setHyperlinkForeground(Color color) {
        if (color == null) {
            throw new NullPointerException("fg cannot be null");
        }
        this.hyperlinkFG = color;
    }

    public void setHyperlinksEnabled(boolean bl) {
        if (this.hyperlinksEnabled != bl) {
            this.hyperlinksEnabled = bl;
            this.repaint();
            this.firePropertyChange(HYPERLINKS_ENABLED_PROPERTY, !bl, bl);
        }
    }

    public void setLinkGenerator(LinkGenerator linkGenerator) {
        this.linkGenerator = linkGenerator;
    }

    public void setLinkScanningMask(int n) {
        if ((n &= 0x3C0) == 0) {
            throw new IllegalArgumentException("mask argument should be some combination of InputEvent.*_DOWN_MASK fields");
        }
        this.linkScanningMask = n;
    }

    public void setMarkOccurrences(boolean bl) {
        if (bl) {
            if (this.markOccurrencesSupport == null) {
                this.markOccurrencesSupport = new MarkOccurrencesSupport();
                this.markOccurrencesSupport.install(this);
                this.firePropertyChange(MARK_OCCURRENCES_PROPERTY, false, true);
            }
        } else if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.uninstall();
            this.markOccurrencesSupport = null;
            this.firePropertyChange(MARK_OCCURRENCES_PROPERTY, true, false);
        }
    }

    public void setMarkOccurrencesColor(Color color) {
        this.markOccurrencesColor = color;
        if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.setColor(color);
        }
    }

    public void setMatchedBracketBGColor(Color color) {
        this.matchedBracketBGColor = color;
        if (this.match != null) {
            this.repaint();
        }
    }

    public void setMatchedBracketBorderColor(Color color) {
        this.matchedBracketBorderColor = color;
        if (this.match != null) {
            this.repaint();
        }
    }

    public void setPaintMarkOccurrencesBorder(boolean bl) {
        this.paintMarkOccurrencesBorder = bl;
        if (this.markOccurrencesSupport != null) {
            this.markOccurrencesSupport.setPaintBorder(bl);
        }
    }

    public void setPaintMatchedBracketPair(boolean bl) {
        if (bl != this.paintMatchedBracketPair) {
            this.paintMatchedBracketPair = bl;
            this.doBracketMatching();
            this.repaint();
            this.firePropertyChange(PAINT_MATCHED_BRACKET_PAIR_PROPERTY, !this.paintMatchedBracketPair, this.paintMatchedBracketPair);
        }
    }

    public void setPaintTabLines(boolean bl) {
        if (bl != this.paintTabLines) {
            this.paintTabLines = bl;
            this.repaint();
            this.firePropertyChange(TAB_LINES_PROPERTY, !bl, bl);
        }
    }

    public void setParserDelay(int n) {
        if (this.parserManager == null) {
            this.parserManager = new ParserManager(this);
        }
        this.parserManager.setDelay(n);
    }

    public void setRightHandSideCorrection(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("correction should be > 0");
        }
        if (n != this.rhsCorrection) {
            this.rhsCorrection = n;
            this.revalidate();
            this.repaint();
        }
    }

    public void setSecondaryLanguageBackground(int n, Color color) {
        Color color2 = this.secondaryLanguageBackgrounds[--n];
        if (color == null && color2 != null || color != null && !color.equals(color2)) {
            this.secondaryLanguageBackgrounds[n] = color;
            if (this.getHighlightSecondaryLanguages()) {
                this.repaint();
            }
        }
    }

    public void setSyntaxEditingStyle(String string) {
        if (string == null) {
            string = "text/plain";
        }
        if (!string.equals(this.syntaxStyleKey)) {
            String string2 = this.syntaxStyleKey;
            this.syntaxStyleKey = string;
            ((RSyntaxDocument)this.getDocument()).setSyntaxStyle(string);
            this.firePropertyChange(SYNTAX_STYLE_PROPERTY, string2, string);
            this.setActiveLineRange(-1, -1);
        }
    }

    public void setSyntaxScheme(SyntaxScheme syntaxScheme) {
        SyntaxScheme syntaxScheme2 = this.syntaxScheme;
        this.syntaxScheme = syntaxScheme;
        this.calculateLineHeight();
        if (this.isDisplayable()) {
            this.refreshFontMetrics(this.getGraphics2D(this.getGraphics()));
        }
        this.updateMarginLineX();
        this.lastBracketMatchPos = -1;
        this.doBracketMatching();
        this.forceCurrentLineHighlightRepaint();
        this.revalidate();
        this.firePropertyChange(SYNTAX_SCHEME_PROPERTY, syntaxScheme2, this.syntaxScheme);
    }

    public static synchronized boolean setTemplateDirectory(String string) {
        if (RSyntaxTextArea.getTemplatesEnabled() && string != null) {
            File file = new File(string);
            if (file.isDirectory()) {
                return RSyntaxTextArea.getCodeTemplateManager().setTemplateDirectory(file) > -1;
            }
            boolean bl = file.mkdir();
            if (bl) {
                return RSyntaxTextArea.getCodeTemplateManager().setTemplateDirectory(file) > -1;
            }
        }
        return false;
    }

    public static synchronized void setTemplatesEnabled(boolean bl) {
        templatesEnabled = bl;
    }

    public void setTabLineColor(Color color) {
        if (color == null) {
            color = Color.gray;
        }
        if (!color.equals(this.tabLineColor)) {
            Color color2 = this.tabLineColor;
            this.tabLineColor = color;
            if (this.getPaintTabLines()) {
                this.repaint();
            }
            this.firePropertyChange(TAB_LINE_COLOR_PROPERTY, color2, this.tabLineColor);
        }
    }

    public void setUseFocusableTips(boolean bl) {
        if (bl != this.useFocusableTips) {
            this.useFocusableTips = bl;
            this.firePropertyChange(FOCUSABLE_TIPS_PROPERTY, !bl, bl);
        }
    }

    public void setUseSelectedTextColor(boolean bl) {
        if (bl != this.useSelectedTextColor) {
            this.useSelectedTextColor = bl;
            this.firePropertyChange(USE_SELECTED_TEXT_COLOR_PROPERTY, !bl, bl);
        }
    }

    public void setWhitespaceVisible(boolean bl) {
        if (this.whitespaceVisible != bl) {
            this.whitespaceVisible = bl;
            this.tokenPainter = bl ? new VisibleWhitespaceTokenPainter() : new DefaultTokenPainter();
            this.repaint();
            this.firePropertyChange(VISIBLE_WHITESPACE_PROPERTY, !bl, bl);
        }
    }

    private void stopScanningForLinks() {
        if (this.isScanningForLinks) {
            Cursor cursor = this.getCursor();
            this.isScanningForLinks = false;
            this.linkGeneratorResult = null;
            this.hoveredOverLinkOffset = -1;
            if (cursor != null && cursor.getType() == 12) {
                this.setCursor(Cursor.getPredefinedCursor(2));
                this.repaint();
            }
        }
    }

    @Override
    public void undoLastAction() {
        super.undoLastAction();
        ((RSyntaxTextAreaHighlighter)this.getHighlighter()).clearMarkOccurrencesHighlights();
    }

    public void clearMarkOccurrencesHighlights() {
        ((RSyntaxTextAreaHighlighter)this.getHighlighter()).clearMarkOccurrencesHighlights();
    }

    public Token viewToToken(Point point) {
        return this.modelToToken(this.viewToModel(point));
    }

    public class RSyntaxTextAreaMutableCaretEvent
    extends RTextArea.RTextAreaMutableCaretEvent {
        private Insets insets;

        protected RSyntaxTextAreaMutableCaretEvent(RTextArea rTextArea) {
            super(RSyntaxTextArea.this, rTextArea);
            this.insets = new Insets(0, 0, 0, 0);
        }

        private HyperlinkEvent createHyperlinkEvent() {
            HyperlinkEvent hyperlinkEvent = null;
            if (RSyntaxTextArea.this.linkGeneratorResult != null) {
                hyperlinkEvent = RSyntaxTextArea.this.linkGeneratorResult.execute();
                RSyntaxTextArea.this.linkGeneratorResult = null;
            } else {
                Token token = RSyntaxTextArea.this.modelToToken(RSyntaxTextArea.this.hoveredOverLinkOffset);
                URL uRL = null;
                String string = null;
                try {
                    Object object = token.getLexeme();
                    if (((String)object).startsWith("www.")) {
                        object = "http://" + (String)object;
                    }
                    uRL = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    string = malformedURLException.getMessage();
                }
                hyperlinkEvent = new HyperlinkEvent(RSyntaxTextArea.this, HyperlinkEvent.EventType.ACTIVATED, uRL, string);
            }
            return hyperlinkEvent;
        }

        private final boolean equal(LinkGeneratorResult linkGeneratorResult, LinkGeneratorResult linkGeneratorResult2) {
            return linkGeneratorResult.getSourceOffset() == linkGeneratorResult2.getSourceOffset();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (RSyntaxTextArea.this.getHyperlinksEnabled() && RSyntaxTextArea.this.isScanningForLinks && RSyntaxTextArea.this.hoveredOverLinkOffset > -1) {
                HyperlinkEvent hyperlinkEvent = this.createHyperlinkEvent();
                if (hyperlinkEvent != null) {
                    RSyntaxTextArea.this.fireHyperlinkUpdate(hyperlinkEvent);
                }
                RSyntaxTextArea.this.stopScanningForLinks();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            if (!RSyntaxTextArea.this.getHyperlinksEnabled()) {
                return;
            }
            if ((mouseEvent.getModifiersEx() & RSyntaxTextArea.this.linkScanningMask) == RSyntaxTextArea.this.linkScanningMask) {
                this.insets = RSyntaxTextArea.this.getInsets(this.insets);
                if (this.insets != null) {
                    int n = mouseEvent.getX();
                    int n2 = mouseEvent.getY();
                    if (n <= this.insets.left || n2 < this.insets.top) {
                        if (RSyntaxTextArea.this.isScanningForLinks) {
                            RSyntaxTextArea.this.stopScanningForLinks();
                        }
                        return;
                    }
                }
                RSyntaxTextArea.this.isScanningForLinks = true;
                Token token = RSyntaxTextArea.this.viewToToken(mouseEvent.getPoint());
                if (token != null) {
                    token = new TokenImpl(token);
                }
                Cursor cursor = null;
                if (token != null && token.isHyperlink()) {
                    if (RSyntaxTextArea.this.hoveredOverLinkOffset == -1 || RSyntaxTextArea.this.hoveredOverLinkOffset != token.getOffset()) {
                        RSyntaxTextArea.this.hoveredOverLinkOffset = token.getOffset();
                        RSyntaxTextArea.this.repaint();
                    }
                    cursor = Cursor.getPredefinedCursor(12);
                } else if (token != null && RSyntaxTextArea.this.linkGenerator != null) {
                    int n = RSyntaxTextArea.this.viewToModel(mouseEvent.getPoint());
                    LinkGeneratorResult linkGeneratorResult = RSyntaxTextArea.this.linkGenerator.isLinkAtOffset(RSyntaxTextArea.this, n);
                    if (linkGeneratorResult != null) {
                        if (RSyntaxTextArea.this.linkGeneratorResult == null || !this.equal(linkGeneratorResult, RSyntaxTextArea.this.linkGeneratorResult)) {
                            RSyntaxTextArea.this.repaint();
                        }
                        RSyntaxTextArea.this.linkGeneratorResult = linkGeneratorResult;
                        RSyntaxTextArea.this.hoveredOverLinkOffset = token.getOffset();
                        cursor = Cursor.getPredefinedCursor(12);
                    } else {
                        if (RSyntaxTextArea.this.linkGeneratorResult != null) {
                            RSyntaxTextArea.this.repaint();
                        }
                        cursor = Cursor.getPredefinedCursor(2);
                        RSyntaxTextArea.this.hoveredOverLinkOffset = -1;
                        RSyntaxTextArea.this.linkGeneratorResult = null;
                    }
                } else {
                    cursor = Cursor.getPredefinedCursor(2);
                    RSyntaxTextArea.this.hoveredOverLinkOffset = -1;
                    RSyntaxTextArea.this.linkGeneratorResult = null;
                }
                if (RSyntaxTextArea.this.getCursor() != cursor) {
                    RSyntaxTextArea.this.setCursor(cursor);
                    RSyntaxTextArea.this.repaint();
                }
            } else if (RSyntaxTextArea.this.isScanningForLinks) {
                RSyntaxTextArea.this.stopScanningForLinks();
            }
        }
    }

    private class BracketMatchingTimer
    extends Timer
    implements ActionListener {
        private int pulseCount;

        public BracketMatchingTimer() {
            super(20, null);
            this.addActionListener(this);
            this.setCoalesce(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RSyntaxTextArea.this.isBracketMatchingEnabled()) {
                if (RSyntaxTextArea.this.match != null) {
                    this.updateAndInvalidate(RSyntaxTextArea.this.match);
                }
                if (RSyntaxTextArea.this.dotRect != null && RSyntaxTextArea.this.getPaintMatchedBracketPair()) {
                    this.updateAndInvalidate(RSyntaxTextArea.this.dotRect);
                }
                if (++this.pulseCount == 8) {
                    this.pulseCount = 0;
                    this.stop();
                }
            }
        }

        private void init(Rectangle rectangle) {
            rectangle.x += 3;
            rectangle.y += 3;
            rectangle.width -= 6;
            rectangle.height -= 6;
        }

        @Override
        public void start() {
            this.init(RSyntaxTextArea.this.match);
            if (RSyntaxTextArea.this.dotRect != null && RSyntaxTextArea.this.getPaintMatchedBracketPair()) {
                this.init(RSyntaxTextArea.this.dotRect);
            }
            this.pulseCount = 0;
            super.start();
        }

        private void updateAndInvalidate(Rectangle rectangle) {
            if (this.pulseCount < 5) {
                --rectangle.x;
                --rectangle.y;
                rectangle.width += 2;
                rectangle.height += 2;
                RSyntaxTextArea.this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            } else if (this.pulseCount < 7) {
                ++rectangle.x;
                ++rectangle.y;
                rectangle.width -= 2;
                rectangle.height -= 2;
                RSyntaxTextArea.this.repaint(rectangle.x - 2, rectangle.y - 2, rectangle.width + 5, rectangle.height + 5);
            }
        }
    }
}

