/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenImpl;
import org.fife.ui.rsyntaxtextarea.TokenOrientedView;
import org.fife.ui.rsyntaxtextarea.TokenUtils;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class RSyntaxUtilities
implements SwingConstants {
    public static final int OS_WINDOWS = 1;
    public static final int OS_MAC_OSX = 2;
    public static final int OS_LINUX = 4;
    public static final int OS_OTHER = 8;
    private static final Color LIGHT_HYPERLINK_FG = new Color(0xD8FFFF);
    private static final int OS = RSyntaxUtilities.getOSImpl();
    private static final int LETTER_MASK = 2;
    private static final int HEX_CHARACTER_MASK = 16;
    private static final int LETTER_OR_DIGIT_MASK = 32;
    private static final int BRACKET_MASK = 64;
    private static final int JAVA_OPERATOR_MASK = 128;
    private static final int[] dataTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 128, 0, 0, 0, 128, 128, 0, 64, 64, 128, 128, 0, 128, 0, 128, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 128, 0, 128, 128, 128, 128, 0, 58, 58, 58, 58, 58, 58, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 42, 64, 0, 64, 128, 0, 0, 50, 50, 50, 50, 50, 50, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 34, 64, 128, 64, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static Segment charSegment = new Segment();
    private static final TokenImpl tempToken = new TokenImpl();
    private static final char[] JS_KEYWORD_RETURN = new char[]{'r', 'e', 't', 'u', 'r', 'n'};
    private static final char[] JS_AND = new char[]{'&', '&'};
    private static final char[] JS_OR = new char[]{'|', '|'};
    private static final String BRACKETS = "{([})]";

    public static final String escapeForHtml(String string, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            string2 = "";
        }
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (bl || !bl2) {
                        stringBuilder.append(' ');
                    } else {
                        stringBuilder.append("&nbsp;");
                    }
                    bl2 = true;
                    continue block8;
                }
                case '\n': {
                    stringBuilder.append(string2);
                    bl2 = false;
                    continue block8;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    bl2 = false;
                    continue block8;
                }
                case '\t': {
                    stringBuilder.append("   ");
                    bl2 = false;
                    continue block8;
                }
                case '<': {
                    stringBuilder.append("&lt;");
                    bl2 = false;
                    continue block8;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    bl2 = false;
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                    bl2 = false;
                }
            }
        }
        return stringBuilder.toString();
    }

    public static Map<?, ?> getDesktopAntiAliasHints() {
        return (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    }

    public static Color getFoldedLineBottomColor(RSyntaxTextArea rSyntaxTextArea) {
        Color color = Color.gray;
        Gutter gutter = RSyntaxUtilities.getGutter(rSyntaxTextArea);
        if (gutter != null) {
            color = gutter.getFoldIndicatorForeground();
        }
        return color;
    }

    public static Gutter getGutter(RTextArea rTextArea) {
        Gutter gutter = null;
        Container container = rTextArea.getParent();
        if (container instanceof JViewport && (container = container.getParent()) instanceof RTextScrollPane) {
            RTextScrollPane rTextScrollPane = (RTextScrollPane)container;
            gutter = rTextScrollPane.getGutter();
        }
        return gutter;
    }

    public static final Color getHyperlinkForeground() {
        Color color = UIManager.getColor("Label.foreground");
        if (color == null) {
            color = new JLabel().getForeground();
        }
        return RSyntaxUtilities.isLightForeground(color) ? LIGHT_HYPERLINK_FG : Color.blue;
    }

    public static String getLeadingWhitespace(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && RSyntaxUtilities.isWhitespace(string.charAt(n)); ++n) {
        }
        return string.substring(0, n);
    }

    public static String getLeadingWhitespace(Document document, int n) throws BadLocationException {
        Element element = document.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        int n4 = element2.getEndOffset() - 1;
        String string = document.getText(n3, n4 - n3);
        return RSyntaxUtilities.getLeadingWhitespace(string);
    }

    private static final Element getLineElem(Document document, int n) {
        int n2;
        Element element = document.getDefaultRootElement();
        Element element2 = element.getElement(n2 = element.getElementIndex(n));
        if (n >= element2.getStartOffset() && n < element2.getEndOffset()) {
            return element2;
        }
        return null;
    }

    public static Rectangle getLineWidthUpTo(RSyntaxTextArea rSyntaxTextArea, Segment segment, int n, int n2, TabExpander tabExpander, Rectangle rectangle, int n3) throws BadLocationException {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
        if (n < 0) {
            throw new BadLocationException("Invalid document position", n);
        }
        if (n2 > rSyntaxDocument.getLength()) {
            throw new BadLocationException("Invalid document position", n2);
        }
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n4 = element.getElementIndex(n);
        if (Math.abs(n4 - element.getElementIndex(n2)) > 1) {
            throw new IllegalArgumentException("p0 and p1 are not on the same line (" + n + ", " + n2 + ").");
        }
        Token token = rSyntaxDocument.getTokenListForLine(n4);
        TokenUtils.TokenSubList tokenSubList = TokenUtils.getSubTokenList(token, n, tabExpander, rSyntaxTextArea, 0.0f, tempToken);
        token = tokenSubList.tokenList;
        rectangle = token.listOffsetToView(rSyntaxTextArea, tabExpander, n2, n3, rectangle);
        return rectangle;
    }

    public static Point getMatchingBracketPosition(RSyntaxTextArea rSyntaxTextArea, Point point) {
        if (point == null) {
            point = new Point();
        }
        point.setLocation(-1, -1);
        try {
            char c;
            boolean bl;
            int n;
            int n2 = rSyntaxTextArea.getCaretPosition() - 1;
            RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
            char c2 = '\u0000';
            if (n2 >= 0) {
                c2 = rSyntaxDocument.charAt(n2);
            }
            if ((n = BRACKETS.indexOf(c2)) == -1 && n2 < rSyntaxDocument.getLength() - 1) {
                c2 = rSyntaxDocument.charAt(++n2);
            }
            if (n == -1 && (n = BRACKETS.indexOf(c2)) == -1) {
                return point;
            }
            Element element = rSyntaxDocument.getDefaultRootElement();
            int n3 = element.getElementIndex(n2);
            Element element2 = element.getElement(n3);
            int n4 = element2.getStartOffset();
            int n5 = element2.getEndOffset();
            Token token = rSyntaxDocument.getTokenListForLine(n3);
            if ((token = RSyntaxUtilities.getTokenAtOffset(token, n2)).getType() != 22) {
                return point;
            }
            int n6 = token.getLanguageIndex();
            if (n < 3) {
                bl = true;
                c = BRACKETS.charAt(n + 3);
            } else {
                bl = false;
                c = BRACKETS.charAt(n - 3);
            }
            if (bl) {
                int n7 = element.getElementCount();
                n4 = n2 + 1;
                int n8 = 0;
                boolean bl2 = false;
                while (true) {
                    int n9;
                    rSyntaxDocument.getText(n4, n5 - n4, charSegment);
                    for (int i = n9 = RSyntaxUtilities.charSegment.offset; i < n9 + RSyntaxUtilities.charSegment.count; ++i) {
                        int n10;
                        char c3 = RSyntaxUtilities.charSegment.array[i];
                        if (c3 == c2) {
                            if (!bl2) {
                                token = rSyntaxDocument.getTokenListForLine(n3);
                                bl2 = true;
                            }
                            if ((token = RSyntaxUtilities.getTokenAtOffset(token, n10 = n4 + (i - n9))).getType() != 22 || token.getLanguageIndex() != n6) continue;
                            ++n8;
                            continue;
                        }
                        if (c3 != c) continue;
                        if (!bl2) {
                            token = rSyntaxDocument.getTokenListForLine(n3);
                            bl2 = true;
                        }
                        if ((token = RSyntaxUtilities.getTokenAtOffset(token, n10 = n4 + (i - n9))).getType() != 22 || token.getLanguageIndex() != n6) continue;
                        if (n8 == 0) {
                            if (rSyntaxTextArea.isCodeFoldingEnabled() && rSyntaxTextArea.getFoldManager().isLineHidden(n3)) {
                                return point;
                            }
                            point.setLocation(n2, n10);
                            return point;
                        }
                        --n8;
                    }
                    if (++n3 == n7) {
                        return point;
                    }
                    bl2 = false;
                    element2 = element.getElement(n3);
                    n4 = element2.getStartOffset();
                    n5 = element2.getEndOffset();
                }
            }
            n5 = n2;
            int n11 = 0;
            boolean bl3 = false;
            while (true) {
                int n12;
                rSyntaxDocument.getText(n4, n5 - n4, charSegment);
                int n13 = RSyntaxUtilities.charSegment.offset;
                for (int i = n12 = n13 + RSyntaxUtilities.charSegment.count - 1; i >= n13; --i) {
                    int n14;
                    Token token2;
                    char c4 = RSyntaxUtilities.charSegment.array[i];
                    if (c4 == c2) {
                        if (!bl3) {
                            token = rSyntaxDocument.getTokenListForLine(n3);
                            bl3 = true;
                        }
                        if ((token2 = RSyntaxUtilities.getTokenAtOffset(token, n14 = n4 + (i - n13))).getType() != 22 || token.getLanguageIndex() != n6) continue;
                        ++n11;
                        continue;
                    }
                    if (c4 != c) continue;
                    if (!bl3) {
                        token = rSyntaxDocument.getTokenListForLine(n3);
                        bl3 = true;
                    }
                    if ((token2 = RSyntaxUtilities.getTokenAtOffset(token, n14 = n4 + (i - n13))).getType() != 22 || token.getLanguageIndex() != n6) continue;
                    if (n11 == 0) {
                        point.setLocation(n2, n14);
                        return point;
                    }
                    --n11;
                }
                if (--n3 == -1) {
                    return point;
                }
                bl3 = false;
                element2 = element.getElement(n3);
                n4 = element2.getStartOffset();
                n5 = element2.getEndOffset();
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return point;
        }
    }

    public static final Token getNextImportantToken(Token token, RSyntaxTextArea rSyntaxTextArea, int n) {
        while (token != null && token.isPaintable() && token.isCommentOrWhitespace()) {
            token = token.getNextToken();
        }
        if (!(token != null && token.isPaintable() || n >= rSyntaxTextArea.getLineCount() - 1)) {
            token = rSyntaxTextArea.getTokenListForLine(++n);
            return RSyntaxUtilities.getNextImportantToken(token, rSyntaxTextArea, n);
        }
        return token;
    }

    public static int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray, View view) throws BadLocationException {
        RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)view.getContainer();
        biasArray[0] = Position.Bias.Forward;
        switch (n2) {
            case 1: 
            case 5: {
                Rectangle rectangle;
                if (n == -1) {
                    n = n2 == 1 ? Math.max(0, view.getEndOffset() - 1) : view.getStartOffset();
                    break;
                }
                Caret caret = rSyntaxTextArea != null ? rSyntaxTextArea.getCaret() : null;
                Point point = caret != null ? caret.getMagicCaretPosition() : null;
                int n3 = point == null ? ((rectangle = rSyntaxTextArea.modelToView(n)) == null ? 0 : rectangle.x) : point.x;
                if (n2 == 1) {
                    n = RSyntaxUtilities.getPositionAbove(rSyntaxTextArea, n, n3, (TabExpander)((Object)view));
                    break;
                }
                n = RSyntaxUtilities.getPositionBelow(rSyntaxTextArea, n, n3, (TabExpander)((Object)view));
                break;
            }
            case 7: {
                FoldManager foldManager;
                int n4;
                int n5;
                int n6 = view.getEndOffset();
                if (n == -1) {
                    n = Math.max(0, n6 - 1);
                    break;
                }
                n = Math.max(0, n - 1);
                if (!rSyntaxTextArea.isCodeFoldingEnabled() || (n5 = n == n6 - 1 ? rSyntaxTextArea.getLineCount() - 1 : rSyntaxTextArea.getLineOfOffset(n + 1)) == (n4 = rSyntaxTextArea.getLineOfOffset(n)) || !(foldManager = rSyntaxTextArea.getFoldManager()).isLineHidden(n4)) break;
                while (--n4 > 0 && foldManager.isLineHidden(n4)) {
                }
                n = rSyntaxTextArea.getLineEndOffset(n4) - 1;
                break;
            }
            case 3: {
                FoldManager foldManager;
                int n7;
                int n8;
                if (n == -1) {
                    n = view.getStartOffset();
                    break;
                }
                n = Math.min(n + 1, view.getDocument().getLength());
                if (!rSyntaxTextArea.isCodeFoldingEnabled() || (n8 = n == 0 ? 0 : rSyntaxTextArea.getLineOfOffset(n - 1)) == (n7 = rSyntaxTextArea.getLineOfOffset(n)) || !(foldManager = rSyntaxTextArea.getFoldManager()).isLineHidden(n7)) break;
                int n9 = rSyntaxTextArea.getLineCount();
                while (++n7 < n9 && foldManager.isLineHidden(n7)) {
                }
                n = n7 == n9 ? rSyntaxTextArea.getLineEndOffset(n8) - 1 : rSyntaxTextArea.getLineStartOffset(n7);
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + n2);
            }
        }
        return n;
    }

    public static final int getOS() {
        return OS;
    }

    private static final int getOSImpl() {
        int n = 8;
        String string = System.getProperty("os.name");
        if (string != null) {
            n = (string = string.toLowerCase()).indexOf("windows") > -1 ? 1 : (string.indexOf("mac os x") > -1 ? 2 : (string.indexOf("linux") > -1 ? 4 : 8));
        }
        return n;
    }

    public static final int getPatternFlags(boolean bl, int n) {
        if (!bl) {
            n |= 0x42;
        }
        return n;
    }

    public static final int getPositionAbove(RSyntaxTextArea rSyntaxTextArea, int n, float f, TabExpander tabExpander) throws BadLocationException {
        TokenOrientedView tokenOrientedView = (TokenOrientedView)((Object)tabExpander);
        Token token = tokenOrientedView.getTokenListForPhysicalLineAbove(n);
        if (token == null) {
            return -1;
        }
        if (token.getType() == 0) {
            int n2 = rSyntaxTextArea.getLineOfOffset(n);
            return rSyntaxTextArea.getLineStartOffset(n2 - 1);
        }
        return token.getListOffset(rSyntaxTextArea, tabExpander, rSyntaxTextArea.getMargin().left, f);
    }

    public static final int getPositionBelow(RSyntaxTextArea rSyntaxTextArea, int n, float f, TabExpander tabExpander) throws BadLocationException {
        TokenOrientedView tokenOrientedView = (TokenOrientedView)((Object)tabExpander);
        Token token = tokenOrientedView.getTokenListForPhysicalLineBelow(n);
        if (token == null) {
            return -1;
        }
        if (token.getType() == 0) {
            int n2 = rSyntaxTextArea.getLineOfOffset(n);
            FoldManager foldManager = rSyntaxTextArea.getFoldManager();
            n2 = foldManager.getVisibleLineBelow(n2);
            return rSyntaxTextArea.getLineStartOffset(n2);
        }
        return token.getListOffset(rSyntaxTextArea, tabExpander, rSyntaxTextArea.getMargin().left, f);
    }

    public static final Token getPreviousImportantToken(RSyntaxDocument rSyntaxDocument, int n) {
        if (n < 0) {
            return null;
        }
        Token token = rSyntaxDocument.getTokenListForLine(n);
        if (token != null && (token = token.getLastNonCommentNonWhitespaceToken()) != null) {
            return token;
        }
        return RSyntaxUtilities.getPreviousImportantToken(rSyntaxDocument, n - 1);
    }

    public static final Token getPreviousImportantTokenFromOffs(RSyntaxDocument rSyntaxDocument, int n) {
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Token token = null;
        for (Token token2 = rSyntaxDocument.getTokenListForLine(n2); token2 != null && token2.isPaintable() && !token2.containsPosition(n); token2 = token2.getNextToken()) {
            if (token2.isCommentOrWhitespace()) continue;
            token = token2;
        }
        if (token == null) {
            token = RSyntaxUtilities.getPreviousImportantToken(rSyntaxDocument, n2 - 1);
        }
        return token;
    }

    public static final Token getTokenAtOffset(RSyntaxTextArea rSyntaxTextArea, int n) {
        RSyntaxDocument rSyntaxDocument = (RSyntaxDocument)rSyntaxTextArea.getDocument();
        return RSyntaxUtilities.getTokenAtOffset(rSyntaxDocument, n);
    }

    public static final Token getTokenAtOffset(RSyntaxDocument rSyntaxDocument, int n) {
        Element element = rSyntaxDocument.getDefaultRootElement();
        int n2 = element.getElementIndex(n);
        Token token = rSyntaxDocument.getTokenListForLine(n2);
        return RSyntaxUtilities.getTokenAtOffset(token, n);
    }

    public static final Token getTokenAtOffset(Token token, int n) {
        for (Token token2 = token; token2 != null && token2.isPaintable(); token2 = token2.getNextToken()) {
            if (!token2.containsPosition(n)) continue;
            return token2;
        }
        return null;
    }

    public static int getWordEnd(RSyntaxTextArea rSyntaxTextArea, int n) throws BadLocationException {
        Document document = rSyntaxTextArea.getDocument();
        int n2 = rSyntaxTextArea.getLineEndOffsetOfCurrentLine();
        int n3 = Math.min(n2, document.getLength());
        if (n == n3) {
            return n;
        }
        String string = document.getText(n, n3 - n - 1);
        if (string != null && string.length() > 0) {
            int n4 = 0;
            int n5 = string.length();
            char c = string.charAt(n4);
            if (Character.isWhitespace(c)) {
                while (n4 < n5 && Character.isWhitespace(string.charAt(n4++))) {
                }
            } else if (Character.isLetterOrDigit(c)) {
                while (n4 < n5 && Character.isLetterOrDigit(string.charAt(n4++))) {
                }
            } else {
                n4 = 2;
            }
            n += n4 - 1;
        }
        return n;
    }

    public static int getWordStart(RSyntaxTextArea rSyntaxTextArea, int n) throws BadLocationException {
        Document document = rSyntaxTextArea.getDocument();
        Element element = RSyntaxUtilities.getLineElem(document, n);
        if (element == null) {
            throw new BadLocationException("No word at " + n, n);
        }
        int n2 = element.getStartOffset();
        if (n == n2) {
            return n;
        }
        int n3 = Math.min(n + 1, document.getLength());
        String string = document.getText(n2, n3 - n2);
        if (string != null && string.length() > 0) {
            int n4 = string.length() - 1;
            char c = string.charAt(n4);
            if (Character.isWhitespace(c)) {
                while (n4 > 0 && Character.isWhitespace(string.charAt(n4 - 1))) {
                    --n4;
                }
                n = n2 + n4;
            } else if (Character.isLetterOrDigit(c)) {
                while (n4 > 0 && Character.isLetterOrDigit(string.charAt(n4 - 1))) {
                    --n4;
                }
                n = n2 + n4;
            }
        }
        return n;
    }

    public static final float getTokenListWidth(Token token, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander) {
        return RSyntaxUtilities.getTokenListWidth(token, rSyntaxTextArea, tabExpander, 0.0f);
    }

    public static final float getTokenListWidth(Token token, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        float f2 = f;
        for (Token token2 = token; token2 != null && token2.isPaintable(); token2 = token2.getNextToken()) {
            f2 += token2.getWidth(rSyntaxTextArea, tabExpander, f2);
        }
        return f2 - f;
    }

    public static final float getTokenListWidthUpTo(Token token, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, int n) {
        float f2 = 0.0f;
        for (Token token2 = token; token2 != null && token2.isPaintable(); token2 = token2.getNextToken()) {
            if (token2.containsPosition(n)) {
                return f2 + token2.getWidthUpTo(n - token2.getOffset(), rSyntaxTextArea, tabExpander, f + f2);
            }
            f2 += token2.getWidth(rSyntaxTextArea, tabExpander, f + f2);
        }
        return f2;
    }

    public static final boolean isBracket(char c) {
        return c <= '}' && (dataTable[c] & 0x40) > 0;
    }

    public static final boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static final boolean isHexCharacter(char c) {
        return c <= 'f' && (dataTable[c] & 0x10) > 0;
    }

    public static final boolean isJavaOperator(char c) {
        return c <= '~' && (dataTable[c] & 0x80) > 0;
    }

    public static final boolean isLetter(char c) {
        return c <= 'z' && (dataTable[c] & 2) > 0;
    }

    public static final boolean isLetterOrDigit(char c) {
        return c <= 'z' && (dataTable[c] & 0x20) > 0;
    }

    public static final boolean isLightForeground(Color color) {
        return color.getRed() > 160 && color.getGreen() > 160 && color.getBlue() > 160;
    }

    public static final boolean isNonWordChar(Token token) {
        return token.length() == 1 && !RSyntaxUtilities.isLetter(token.charAt(0));
    }

    public static final boolean isWhitespace(char c) {
        return c == ' ' || c == '\t';
    }

    public static boolean regexCanFollowInJavaScript(Token token) {
        char c;
        return token == null || token.length() == 1 && ((c = token.charAt(0)) == '=' || c == '(' || c == ',' || c == '?' || c == ':' || c == '[' || c == '!' || c == '&') || token.getType() == 23 && (token.charAt(token.length() - 1) == '=' || token.is(JS_AND) || token.is(JS_OR)) || token.is(7, JS_KEYWORD_RETURN);
    }

    public static final void selectAndPossiblyCenter(JTextArea jTextArea, DocumentRange documentRange, boolean bl) {
        Serializable serializable;
        Object object;
        int n = documentRange.getStartOffset();
        int n2 = documentRange.getEndOffset();
        boolean bl2 = false;
        if (jTextArea instanceof RSyntaxTextArea && (object = ((RSyntaxTextArea)(serializable = (RSyntaxTextArea)jTextArea)).getFoldManager()).isCodeFoldingSupportedAndEnabled()) {
            bl2 = object.ensureOffsetNotInClosedFold(n);
            bl2 |= object.ensureOffsetNotInClosedFold(n2);
        }
        if (bl) {
            jTextArea.setSelectionStart(n);
            jTextArea.setSelectionEnd(n2);
        }
        serializable = null;
        try {
            serializable = jTextArea.modelToView(n);
            if (serializable == null) {
                return;
            }
            if (n2 != n) {
                serializable = ((Rectangle)serializable).union(jTextArea.modelToView(n2));
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            if (bl) {
                jTextArea.setSelectionStart(n);
                jTextArea.setSelectionEnd(n2);
            }
            return;
        }
        object = jTextArea.getVisibleRect();
        if (!bl2 && ((Rectangle)object).contains((Rectangle)serializable)) {
            if (bl) {
                jTextArea.setSelectionStart(n);
                jTextArea.setSelectionEnd(n2);
            }
            return;
        }
        ((Rectangle)object).x = ((Rectangle)serializable).x - (((Rectangle)object).width - ((Rectangle)serializable).width) / 2;
        ((Rectangle)object).y = ((Rectangle)serializable).y - (((Rectangle)object).height - ((Rectangle)serializable).height) / 2;
        Rectangle rectangle = jTextArea.getBounds();
        Insets insets = jTextArea.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        if (((Rectangle)object).x < rectangle.x) {
            ((Rectangle)object).x = rectangle.x;
        }
        if (((Rectangle)object).x + ((Rectangle)object).width > rectangle.x + rectangle.width) {
            ((Rectangle)object).x = rectangle.x + rectangle.width - ((Rectangle)object).width;
        }
        if (((Rectangle)object).y < rectangle.y) {
            ((Rectangle)object).y = rectangle.y;
        }
        if (((Rectangle)object).y + ((Rectangle)object).height > rectangle.y + rectangle.height) {
            ((Rectangle)object).y = rectangle.y + rectangle.height - ((Rectangle)object).height;
        }
        jTextArea.scrollRectToVisible((Rectangle)object);
    }

    public static final char toLowerCase(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c | 0x20);
        }
        return c;
    }

    public static Pattern wildcardToPattern(String string, boolean bl, boolean bl2) {
        int n = RSyntaxUtilities.getPatternFlags(bl, 0);
        StringBuilder stringBuilder = new StringBuilder();
        block8: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': {
                    stringBuilder.append(".*");
                    continue block8;
                }
                case '?': {
                    stringBuilder.append('.');
                    continue block8;
                }
                case '^': {
                    if (i > 0 || bl2) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append('^');
                    continue block8;
                }
                case '$': 
                case '(': 
                case ')': 
                case '+': 
                case '-': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '{': 
                case '|': 
                case '}': {
                    stringBuilder.append('\\').append(c);
                    continue block8;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(stringBuilder.toString(), n);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            patternSyntaxException.printStackTrace();
            pattern = Pattern.compile(".+");
        }
        return pattern;
    }
}

