/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Style;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.Token;

public class TokenImpl
implements Token {
    public char[] text = null;
    public int textOffset = -1;
    public int textCount = -1;
    private int offset;
    private int type;
    private boolean hyperlink;
    private Token nextToken;
    private int languageIndex;

    public TokenImpl() {
        this.setType(0);
        this.setOffset(-1);
        this.hyperlink = false;
        this.nextToken = null;
    }

    public TokenImpl(Segment segment, int n, int n2, int n3, int n4, int n5) {
        this(segment.array, n, n2, n3, n4, n5);
    }

    public TokenImpl(char[] cArray, int n, int n2, int n3, int n4, int n5) {
        this();
        this.set(cArray, n, n2, n3, n4);
        this.setLanguageIndex(n5);
    }

    public TokenImpl(Token token) {
        this();
        this.copyFrom(token);
    }

    @Override
    public StringBuilder appendHTMLRepresentation(StringBuilder stringBuilder, RSyntaxTextArea rSyntaxTextArea, boolean bl) {
        return this.appendHTMLRepresentation(stringBuilder, rSyntaxTextArea, bl, false);
    }

    @Override
    public StringBuilder appendHTMLRepresentation(StringBuilder stringBuilder, RSyntaxTextArea rSyntaxTextArea, boolean bl, boolean bl2) {
        SyntaxScheme syntaxScheme = rSyntaxTextArea.getSyntaxScheme();
        Style style = syntaxScheme.getStyle(this.getType());
        Font font = rSyntaxTextArea.getFontForTokenType(this.getType());
        if (font.isBold()) {
            stringBuilder.append("<b>");
        }
        if (font.isItalic()) {
            stringBuilder.append("<em>");
        }
        if (style.underline || this.isHyperlink()) {
            stringBuilder.append("<u>");
        }
        if (!this.isWhitespace()) {
            stringBuilder.append("<font");
            if (bl) {
                stringBuilder.append(" face=\"").append(font.getFamily()).append("\"");
            }
            stringBuilder.append(" color=\"").append(TokenImpl.getHTMLFormatForColor(style.foreground)).append("\">");
        }
        this.appendHtmlLexeme(rSyntaxTextArea, stringBuilder, bl2);
        if (!this.isWhitespace()) {
            stringBuilder.append("</font>");
        }
        if (style.underline || this.isHyperlink()) {
            stringBuilder.append("</u>");
        }
        if (font.isItalic()) {
            stringBuilder.append("</em>");
        }
        if (font.isBold()) {
            stringBuilder.append("</b>");
        }
        return stringBuilder;
    }

    private final StringBuilder appendHtmlLexeme(RSyntaxTextArea rSyntaxTextArea, StringBuilder stringBuilder, boolean bl) {
        int n;
        boolean bl2 = false;
        int n2 = n = this.textOffset;
        Object object = null;
        while (n < this.textOffset + this.textCount) {
            char c = this.text[n];
            switch (c) {
                case ' ': {
                    stringBuilder.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuilder.append(bl2 ? "&nbsp;" : " ");
                    bl2 = true;
                    break;
                }
                case '\t': {
                    stringBuilder.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    if (bl && object == null) {
                        object = "";
                        for (int i = 0; i < rSyntaxTextArea.getTabSize(); ++i) {
                            object = (String)object + "&nbsp;";
                        }
                    }
                    stringBuilder.append((String)(bl ? object : "&#09;"));
                    bl2 = false;
                    break;
                }
                case '<': {
                    stringBuilder.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuilder.append("&lt;");
                    bl2 = false;
                    break;
                }
                case '>': {
                    stringBuilder.append(this.text, n2, n - n2);
                    n2 = n + 1;
                    stringBuilder.append("&gt;");
                    bl2 = false;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            ++n;
        }
        if (n2 < this.textOffset + this.textCount) {
            stringBuilder.append(this.text, n2, this.textOffset + this.textCount - n2);
        }
        return stringBuilder;
    }

    @Override
    public char charAt(int n) {
        return this.text[this.textOffset + n];
    }

    @Override
    public boolean containsPosition(int n) {
        return n >= this.getOffset() && n < this.getOffset() + this.textCount;
    }

    public void copyFrom(Token token) {
        this.text = token.getTextArray();
        this.textOffset = token.getTextOffset();
        this.textCount = token.length();
        this.setOffset(token.getOffset());
        this.setType(token.getType());
        this.hyperlink = token.isHyperlink();
        this.languageIndex = token.getLanguageIndex();
        this.nextToken = token.getNextToken();
    }

    @Override
    public int documentToToken(int n) {
        return n + (this.textOffset - this.getOffset());
    }

    @Override
    public boolean endsWith(char[] cArray) {
        if (cArray == null || cArray.length > this.textCount) {
            return false;
        }
        int n = this.textOffset + this.textCount - cArray.length;
        for (int i = 0; i < cArray.length; ++i) {
            if (this.text[n + i] == cArray[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Token)) {
            return false;
        }
        Token token = (Token)object;
        return this.offset == token.getOffset() && this.type == token.getType() && this.languageIndex == token.getLanguageIndex() && this.hyperlink == token.isHyperlink() && (this.getLexeme() == null && token.getLexeme() == null || this.getLexeme() != null && this.getLexeme().equals(token.getLexeme()));
    }

    @Override
    public int getEndOffset() {
        return this.offset + this.textCount;
    }

    private static final String getHTMLFormatForColor(Color color) {
        Object object;
        Object object2;
        if (color == null) {
            return "black";
        }
        Object object3 = Integer.toHexString(color.getRed());
        if (((String)object3).length() == 1) {
            object3 = "0" + (String)object3;
        }
        if (((String)(object2 = Integer.toHexString(color.getGreen()))).length() == 1) {
            object2 = "0" + (String)object2;
        }
        if (((String)(object = Integer.toHexString(color.getBlue()))).length() == 1) {
            object = "0" + (String)object;
        }
        return "#" + (String)object3 + (String)object2 + (String)object;
    }

    @Override
    public String getHTMLRepresentation(RSyntaxTextArea rSyntaxTextArea) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendHTMLRepresentation(stringBuilder, rSyntaxTextArea, true);
        return stringBuilder.toString();
    }

    @Override
    public int getLanguageIndex() {
        return this.languageIndex;
    }

    @Override
    public Token getLastNonCommentNonWhitespaceToken() {
        TokenImpl tokenImpl = null;
        block3: for (Token token = this; token != null && token.isPaintable(); token = token.getNextToken()) {
            switch (token.getType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 21: {
                    continue block3;
                }
                default: {
                    tokenImpl = token;
                }
            }
        }
        return tokenImpl;
    }

    @Override
    public Token getLastPaintableToken() {
        Token token = this;
        while (token.isPaintable()) {
            Token token2 = token.getNextToken();
            if (token2 == null || !token2.isPaintable()) {
                return token;
            }
            token = token2;
        }
        return null;
    }

    @Override
    public String getLexeme() {
        return this.text == null ? null : new String(this.text, this.textOffset, this.textCount);
    }

    @Override
    public int getListOffset(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, float f2) {
        if (f >= f2) {
            return this.getOffset();
        }
        float f3 = f;
        float f4 = f;
        float f5 = f;
        int n = this.getOffset();
        FontMetrics fontMetrics = null;
        for (TokenImpl tokenImpl = this; tokenImpl != null && tokenImpl.isPaintable(); tokenImpl = (TokenImpl)tokenImpl.getNextToken()) {
            fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(tokenImpl.getType());
            char[] cArray = tokenImpl.text;
            int n2 = tokenImpl.textOffset;
            int n3 = n2 + tokenImpl.textCount;
            for (int i = n2; i < n3; ++i) {
                f3 = f4;
                if (cArray[i] == '\t') {
                    f5 = f4 = tabExpander.nextTabStop(f4, 0);
                    n2 = i + 1;
                } else {
                    f4 = f5 + (float)fontMetrics.charsWidth(cArray, n2, i - n2 + 1);
                }
                if (!(f2 >= f3) || !(f2 < f4)) continue;
                if (f2 - f3 < f4 - f2) {
                    return n + i - tokenImpl.textOffset;
                }
                return n + i + 1 - tokenImpl.textOffset;
            }
            f5 = f4;
            n += tokenImpl.textCount;
        }
        return n;
    }

    @Override
    public Token getNextToken() {
        return this.nextToken;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetBeforeX(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, float f2) {
        int n;
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.getType());
        int n2 = n + this.textCount;
        float f3 = f;
        for (n = this.textOffset; n < n2; ++n) {
            f3 = this.text[n] == '\t' ? tabExpander.nextTabStop(f3, 0) : (f3 += (float)fontMetrics.charWidth(this.text[n]));
            if (!(f3 > f2)) continue;
            int n3 = Math.max(n - this.textOffset, 1);
            return this.getOffset() + n3;
        }
        return this.getOffset() + this.textCount - 1;
    }

    @Override
    public char[] getTextArray() {
        return this.text;
    }

    @Override
    public int getTextOffset() {
        return this.textOffset;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public float getWidth(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        return this.getWidthUpTo(this.textCount, rSyntaxTextArea, tabExpander, f);
    }

    @Override
    public float getWidthUpTo(int n, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        float f2 = f;
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.getType());
        if (fontMetrics != null) {
            int n2;
            int n3 = this.textOffset;
            int n4 = this.textOffset + n;
            for (int i = n3; i < n4; ++i) {
                if (this.text[i] != '\t') continue;
                n2 = i - n3;
                if (n2 > 0) {
                    f2 += (float)fontMetrics.charsWidth(this.text, n3, n2);
                }
                n3 = i + 1;
                f2 = tabExpander.nextTabStop(f2, 0);
            }
            n2 = n4 - n3;
            if (n2 > 0) {
                f2 += (float)fontMetrics.charsWidth(this.text, n3, n2);
            }
        }
        return f2 - f;
    }

    public int hashCode() {
        return this.offset + (this.getLexeme() == null ? 0 : this.getLexeme().hashCode());
    }

    @Override
    public boolean is(char[] cArray) {
        if (this.textCount == cArray.length) {
            for (int i = 0; i < this.textCount; ++i) {
                if (this.text[this.textOffset + i] == cArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean is(int n, char[] cArray) {
        if (this.getType() == n && this.textCount == cArray.length) {
            for (int i = 0; i < this.textCount; ++i) {
                if (this.text[this.textOffset + i] == cArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean is(int n, String string) {
        return this.getType() == n && this.textCount == string.length() && string.equals(this.getLexeme());
    }

    @Override
    public boolean isComment() {
        return this.getType() >= 1 && this.getType() <= 5;
    }

    @Override
    public boolean isCommentOrWhitespace() {
        return this.isComment() || this.isWhitespace();
    }

    @Override
    public boolean isHyperlink() {
        return this.hyperlink;
    }

    @Override
    public boolean isIdentifier() {
        return this.getType() == 20;
    }

    @Override
    public boolean isLeftCurly() {
        return this.getType() == 22 && this.isSingleChar('{');
    }

    @Override
    public boolean isRightCurly() {
        return this.getType() == 22 && this.isSingleChar('}');
    }

    @Override
    public boolean isPaintable() {
        return this.getType() > 0;
    }

    @Override
    public boolean isSingleChar(char c) {
        return this.textCount == 1 && this.text[this.textOffset] == c;
    }

    @Override
    public boolean isSingleChar(int n, char c) {
        return this.getType() == n && this.isSingleChar(c);
    }

    @Override
    public boolean isWhitespace() {
        return this.getType() == 21;
    }

    @Override
    public int length() {
        return this.textCount;
    }

    @Override
    public Rectangle listOffsetToView(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, int n, int n2, Rectangle rectangle) {
        int n3 = n2;
        FontMetrics fontMetrics = null;
        Segment segment = new Segment();
        for (TokenImpl tokenImpl = this; tokenImpl != null && tokenImpl.isPaintable(); tokenImpl = (TokenImpl)tokenImpl.getNextToken()) {
            fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(tokenImpl.getType());
            if (fontMetrics == null) {
                return rectangle;
            }
            char[] cArray = tokenImpl.text;
            int n4 = tokenImpl.textOffset;
            int n5 = n4 + tokenImpl.textCount;
            if (tokenImpl.containsPosition(n)) {
                segment.array = tokenImpl.text;
                segment.offset = tokenImpl.textOffset;
                segment.count = n - tokenImpl.getOffset();
                int n6 = Utilities.getTabbedTextWidth(segment, fontMetrics, n3, tabExpander, tokenImpl.getOffset());
                rectangle.x = n3 + n6;
                n5 = tokenImpl.documentToToken(n);
                rectangle.width = cArray[n5] == '\t' ? fontMetrics.charWidth(' ') : fontMetrics.charWidth(cArray[n5]);
                return rectangle;
            }
            segment.array = tokenImpl.text;
            segment.offset = tokenImpl.textOffset;
            segment.count = tokenImpl.textCount;
            n3 += Utilities.getTabbedTextWidth(segment, fontMetrics, n3, tabExpander, tokenImpl.getOffset());
        }
        rectangle.x = n3;
        rectangle.width = 1;
        return rectangle;
    }

    public void makeStartAt(int n) {
        if (n < this.getOffset() || n >= this.getOffset() + this.textCount) {
            throw new IllegalArgumentException("pos " + n + " is not in range " + this.getOffset() + "-" + (this.getOffset() + this.textCount - 1));
        }
        int n2 = n - this.getOffset();
        this.setOffset(n);
        this.textOffset += n2;
        this.textCount -= n2;
    }

    public void moveOffset(int n) {
        if (n < 0 || n > this.textCount) {
            throw new IllegalArgumentException("amt " + n + " is not in range 0-" + this.textCount);
        }
        this.setOffset(this.getOffset() + n);
        this.textOffset += n;
        this.textCount -= n;
    }

    public void set(char[] cArray, int n, int n2, int n3, int n4) {
        this.text = cArray;
        this.textOffset = n;
        this.textCount = n2 - n + 1;
        this.setType(n4);
        this.setOffset(n3);
        this.nextToken = null;
    }

    @Override
    public void setHyperlink(boolean bl) {
        this.hyperlink = bl;
    }

    @Override
    public void setLanguageIndex(int n) {
        this.languageIndex = n;
    }

    @Override
    public void setNextToken(Token token) {
        this.nextToken = token;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    @Override
    public void setType(int n) {
        this.type = n;
    }

    @Override
    public boolean startsWith(char[] cArray) {
        if (cArray.length <= this.textCount) {
            for (int i = 0; i < cArray.length; ++i) {
                if (this.text[this.textOffset + i] == cArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int tokenToDocument(int n) {
        return n + (this.getOffset() - this.textOffset);
    }

    public String toString() {
        return "[Token: " + (String)(this.getType() == 0 ? "<null token>" : "text: '" + (String)(this.text == null ? "<null>" : this.getLexeme() + "'; offset: " + this.getOffset() + "; type: " + this.getType() + "; isPaintable: " + this.isPaintable() + "; nextToken==null: " + (this.nextToken == null))) + "]";
    }
}

