/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.ActiveLineRangeEvent;
import org.fife.ui.rsyntaxtextarea.ActiveLineRangeListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.AbstractGutterComponent;
import org.fife.ui.rtextarea.FoldIndicator;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.IconRowHeader;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RDocument;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class Gutter
extends JPanel {
    public static final Color DEFAULT_ACTIVE_LINE_RANGE_COLOR = new Color(51, 153, 255);
    private RTextArea textArea;
    private LineNumberList lineNumberList;
    private Color lineNumberColor;
    private int lineNumberingStartIndex = 1;
    private Font lineNumberFont;
    private IconRowHeader iconArea;
    private boolean iconRowHeaderInheritsGutterBackground = false;
    private FoldIndicator foldIndicator;
    private TextAreaListener listener = new TextAreaListener();

    public Gutter(RTextArea rTextArea) {
        Serializable serializable;
        this.lineNumberColor = Color.gray;
        this.lineNumberFont = RTextArea.getDefaultFont();
        this.setTextArea(rTextArea);
        this.setLayout(new BorderLayout());
        if (this.textArea != null) {
            this.setLineNumbersEnabled(true);
            if (this.textArea instanceof RSyntaxTextArea) {
                serializable = (RSyntaxTextArea)this.textArea;
                this.setFoldIndicatorEnabled(serializable.isCodeFoldingEnabled());
            }
        }
        this.setBorder(new GutterBorder(0, 0, 0, 1));
        serializable = null;
        if (rTextArea != null) {
            serializable = rTextArea.getBackground();
        }
        this.setBackground((Color)(serializable != null ? serializable : Color.WHITE));
    }

    public IconRowHeader getIconArea() {
        return this.iconArea;
    }

    public LineNumberList getLineNumberList() {
        return this.lineNumberList;
    }

    public FoldIndicator getFoldIndicator() {
        return this.foldIndicator;
    }

    public GutterIconInfo addLineTrackingIcon(int n, Icon icon) throws BadLocationException {
        return this.addLineTrackingIcon(n, icon, null);
    }

    public GutterIconInfo addLineTrackingIcon(int n, Icon icon, String string) throws BadLocationException {
        int n2 = this.textArea.getLineStartOffset(n);
        return this.addOffsetTrackingIcon(n2, icon, string);
    }

    public GutterIconInfo addOffsetTrackingIcon(int n, Icon icon) throws BadLocationException {
        return this.addOffsetTrackingIcon(n, icon, null);
    }

    public GutterIconInfo addOffsetTrackingIcon(int n, Icon icon, String string) throws BadLocationException {
        return this.iconArea.addOffsetTrackingIcon(n, icon, string);
    }

    private void clearActiveLineRange() {
        this.iconArea.clearActiveLineRange();
    }

    public Color getActiveLineRangeColor() {
        return this.iconArea.getActiveLineRangeColor();
    }

    public Icon getBookmarkIcon() {
        return this.iconArea.getBookmarkIcon();
    }

    public GutterIconInfo[] getBookmarks() {
        return this.iconArea.getBookmarks();
    }

    public Color getBorderColor() {
        return ((GutterBorder)this.getBorder()).getColor();
    }

    public Color getFoldBackground() {
        return this.foldIndicator.getFoldIconBackground();
    }

    public Color getFoldIndicatorForeground() {
        return this.foldIndicator.getForeground();
    }

    public boolean getIconRowHeaderInheritsGutterBackground() {
        return this.iconRowHeaderInheritsGutterBackground;
    }

    public Color getLineNumberColor() {
        return this.lineNumberColor;
    }

    public Font getLineNumberFont() {
        return this.lineNumberFont;
    }

    public int getLineNumberingStartIndex() {
        return this.lineNumberingStartIndex;
    }

    public boolean getLineNumbersEnabled() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != this.lineNumberList) continue;
            return true;
        }
        return false;
    }

    public boolean getShowCollapsedRegionToolTips() {
        return this.foldIndicator.getShowCollapsedRegionToolTips();
    }

    public GutterIconInfo[] getTrackingIcons(Point point) throws BadLocationException {
        int n = this.textArea.viewToModel(new Point(0, point.y));
        int n2 = this.textArea.getLineOfOffset(n);
        return this.iconArea.getTrackingIcons(n2);
    }

    public boolean isFoldIndicatorEnabled() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != this.foldIndicator) continue;
            return true;
        }
        return false;
    }

    public boolean isBookmarkingEnabled() {
        return this.iconArea.isBookmarkingEnabled();
    }

    public boolean isIconRowHeaderEnabled() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i) != this.iconArea) continue;
            return true;
        }
        return false;
    }

    public void removeAllTrackingIcons() {
        this.iconArea.removeAllTrackingIcons();
    }

    public void removeTrackingIcon(GutterIconInfo gutterIconInfo) {
        this.iconArea.removeTrackingIcon(gutterIconInfo);
    }

    public void setActiveLineRangeColor(Color color) {
        this.iconArea.setActiveLineRangeColor(color);
    }

    private void setActiveLineRange(int n, int n2) {
        this.iconArea.setActiveLineRange(n, n2);
    }

    public void setBookmarkIcon(Icon icon) {
        this.iconArea.setBookmarkIcon(icon);
    }

    public void setBookmarkingEnabled(boolean bl) {
        this.iconArea.setBookmarkingEnabled(bl);
        if (bl && !this.isIconRowHeaderEnabled()) {
            this.setIconRowHeaderEnabled(true);
        }
    }

    public void setBorderColor(Color color) {
        ((GutterBorder)this.getBorder()).setColor(color);
        this.repaint();
    }

    @Override
    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        if (componentOrientation.isLeftToRight()) {
            ((GutterBorder)this.getBorder()).setEdges(0, 0, 0, 1);
        } else {
            ((GutterBorder)this.getBorder()).setEdges(0, 1, 0, 0);
        }
        super.setComponentOrientation(componentOrientation);
    }

    public void setFoldIcons(Icon icon, Icon icon2) {
        if (this.foldIndicator != null) {
            this.foldIndicator.setFoldIcons(icon, icon2);
        }
    }

    public void setFoldIndicatorEnabled(boolean bl) {
        if (this.foldIndicator != null) {
            if (bl) {
                this.add((Component)this.foldIndicator, "After");
            } else {
                this.remove(this.foldIndicator);
            }
            this.revalidate();
        }
    }

    public void setFoldBackground(Color color) {
        if (color == null) {
            color = FoldIndicator.DEFAULT_FOLD_BACKGROUND;
        }
        this.foldIndicator.setFoldIconBackground(color);
    }

    public void setFoldIndicatorForeground(Color color) {
        if (color == null) {
            color = FoldIndicator.DEFAULT_FOREGROUND;
        }
        this.foldIndicator.setForeground(color);
    }

    void setIconRowHeaderEnabled(boolean bl) {
        if (this.iconArea != null) {
            if (bl) {
                this.add((Component)this.iconArea, "Before");
            } else {
                this.remove(this.iconArea);
            }
            this.revalidate();
        }
    }

    public void setIconRowHeaderInheritsGutterBackground(boolean bl) {
        if (bl != this.iconRowHeaderInheritsGutterBackground) {
            this.iconRowHeaderInheritsGutterBackground = bl;
            if (this.iconArea != null) {
                this.iconArea.setInheritsGutterBackground(bl);
            }
        }
    }

    public void setLineNumberColor(Color color) {
        if (color != null && !color.equals(this.lineNumberColor)) {
            this.lineNumberColor = color;
            if (this.lineNumberList != null) {
                this.lineNumberList.setForeground(color);
            }
        }
    }

    public void setLineNumberFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font cannot be null");
        }
        if (!font.equals(this.lineNumberFont)) {
            this.lineNumberFont = font;
            if (this.lineNumberList != null) {
                this.lineNumberList.setFont(font);
            }
        }
    }

    public void setLineNumberingStartIndex(int n) {
        if (n != this.lineNumberingStartIndex) {
            this.lineNumberingStartIndex = n;
            this.lineNumberList.setLineNumberingStartIndex(n);
        }
    }

    void setLineNumbersEnabled(boolean bl) {
        if (this.lineNumberList != null) {
            if (bl) {
                this.add(this.lineNumberList);
            } else {
                this.remove(this.lineNumberList);
            }
            this.revalidate();
        }
    }

    public void setShowCollapsedRegionToolTips(boolean bl) {
        if (this.foldIndicator != null) {
            this.foldIndicator.setShowCollapsedRegionToolTips(bl);
        }
    }

    void setTextArea(RTextArea rTextArea) {
        if (this.textArea != null) {
            this.listener.uninstall();
        }
        if (rTextArea != null) {
            RTextAreaEditorKit rTextAreaEditorKit = (RTextAreaEditorKit)rTextArea.getUI().getEditorKit(rTextArea);
            if (this.lineNumberList == null) {
                this.lineNumberList = rTextAreaEditorKit.createLineNumberList(rTextArea);
                this.lineNumberList.setFont(this.getLineNumberFont());
                this.lineNumberList.setForeground(this.getLineNumberColor());
                this.lineNumberList.setLineNumberingStartIndex(this.getLineNumberingStartIndex());
            } else {
                this.lineNumberList.setTextArea(rTextArea);
            }
            if (this.iconArea == null) {
                this.iconArea = rTextAreaEditorKit.createIconRowHeader(rTextArea);
                this.iconArea.setInheritsGutterBackground(this.getIconRowHeaderInheritsGutterBackground());
            } else {
                this.iconArea.setTextArea(rTextArea);
            }
            if (this.foldIndicator == null) {
                this.foldIndicator = new FoldIndicator(rTextArea);
            } else {
                this.foldIndicator.setTextArea(rTextArea);
            }
            this.listener.install(rTextArea);
        }
        this.textArea = rTextArea;
    }

    public boolean toggleBookmark(int n) throws BadLocationException {
        return this.iconArea.toggleBookmark(n);
    }

    @Override
    public void setBorder(Border border) {
        if (border instanceof GutterBorder) {
            super.setBorder(border);
        }
    }

    private class TextAreaListener
    extends ComponentAdapter
    implements DocumentListener,
    PropertyChangeListener,
    ActiveLineRangeListener {
        private boolean installed;

        private TextAreaListener() {
        }

        @Override
        public void activeLineRangeChanged(ActiveLineRangeEvent activeLineRangeEvent) {
            if (activeLineRangeEvent.getMin() == -1) {
                Gutter.this.clearActiveLineRange();
            } else {
                Gutter.this.setActiveLineRange(activeLineRangeEvent.getMin(), activeLineRangeEvent.getMax());
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            Gutter.this.revalidate();
        }

        protected void handleDocumentEvent(DocumentEvent documentEvent) {
            for (int i = 0; i < Gutter.this.getComponentCount(); ++i) {
                AbstractGutterComponent abstractGutterComponent = (AbstractGutterComponent)Gutter.this.getComponent(i);
                abstractGutterComponent.handleDocumentEvent(documentEvent);
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        public void install(RTextArea rTextArea) {
            if (this.installed) {
                this.uninstall();
            }
            rTextArea.addComponentListener(this);
            rTextArea.getDocument().addDocumentListener(this);
            rTextArea.addPropertyChangeListener(this);
            if (rTextArea instanceof RSyntaxTextArea) {
                RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)rTextArea;
                rSyntaxTextArea.addActiveLineRangeListener(this);
                rSyntaxTextArea.getFoldManager().addPropertyChangeListener(this);
            }
            this.installed = true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("font".equals(string) || "RSTA.syntaxScheme".equals(string)) {
                for (int i = 0; i < Gutter.this.getComponentCount(); ++i) {
                    AbstractGutterComponent abstractGutterComponent = (AbstractGutterComponent)Gutter.this.getComponent(i);
                    abstractGutterComponent.lineHeightsChanged();
                }
            } else if ("RSTA.codeFolding".equals(string)) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                if (Gutter.this.lineNumberList != null) {
                    Gutter.this.lineNumberList.updateCellWidths();
                }
                Gutter.this.setFoldIndicatorEnabled(bl);
            } else if ("FoldsUpdated".equals(string)) {
                Gutter.this.repaint();
            } else if ("document".equals(string)) {
                RDocument rDocument;
                RDocument rDocument2 = (RDocument)propertyChangeEvent.getOldValue();
                if (rDocument2 != null) {
                    rDocument2.removeDocumentListener(this);
                }
                if ((rDocument = (RDocument)propertyChangeEvent.getNewValue()) != null) {
                    rDocument.addDocumentListener(this);
                    RDocument rDocument3 = rDocument;
                    Objects.requireNonNull(rDocument3);
                    this.handleDocumentEvent(new AbstractDocument.DefaultDocumentEvent(rDocument3, 0, rDocument.getLength(), DocumentEvent.EventType.INSERT));
                }
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.handleDocumentEvent(documentEvent);
        }

        public void uninstall() {
            if (this.installed) {
                Gutter.this.textArea.removeComponentListener(this);
                Gutter.this.textArea.getDocument().removeDocumentListener(this);
                Gutter.this.textArea.removePropertyChangeListener(this);
                if (Gutter.this.textArea instanceof RSyntaxTextArea) {
                    RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)Gutter.this.textArea;
                    rSyntaxTextArea.removeActiveLineRangeListener(this);
                    rSyntaxTextArea.getFoldManager().removePropertyChangeListener(this);
                }
                this.installed = false;
            }
        }
    }

    private static class GutterBorder
    extends EmptyBorder {
        private Color color = new Color(221, 221, 221);
        private Rectangle visibleRect = new Rectangle();

        public GutterBorder(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        public Color getColor() {
            return this.color;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            this.visibleRect = graphics.getClipBounds(this.visibleRect);
            if (this.visibleRect == null) {
                this.visibleRect = ((JComponent)component).getVisibleRect();
            }
            graphics.setColor(this.color);
            if (this.left == 1) {
                graphics.drawLine(0, this.visibleRect.y, 0, this.visibleRect.y + this.visibleRect.height);
            } else {
                graphics.drawLine(n3 - 1, this.visibleRect.y, n3 - 1, this.visibleRect.y + this.visibleRect.height);
            }
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public void setEdges(int n, int n2, int n3, int n4) {
            this.top = n;
            this.left = n2;
            this.bottom = n3;
            this.right = n4;
        }
    }
}

