/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.im.InputContext;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.fife.ui.rtextarea.ClipboardHistory;
import org.fife.ui.rtextarea.RTextArea;

public class RTATextTransferHandler
extends TransferHandler {
    private JTextComponent exportComp;
    private boolean shouldRemove;
    private int p0;
    private int p1;
    private boolean withinSameComponent;

    protected DataFlavor getImportFlavor(DataFlavor[] dataFlavorArray, JTextComponent jTextComponent) {
        DataFlavor dataFlavor = null;
        DataFlavor dataFlavor2 = null;
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            String string = dataFlavorArray[i].getMimeType();
            if (string.startsWith("text/plain")) {
                return dataFlavorArray[i];
            }
            if (dataFlavor == null && string.startsWith("application/x-java-jvm-local-objectref") && dataFlavorArray[i].getRepresentationClass() == String.class) {
                dataFlavor = dataFlavorArray[i];
                continue;
            }
            if (dataFlavor2 != null || !dataFlavorArray[i].equals(DataFlavor.stringFlavor)) continue;
            dataFlavor2 = dataFlavorArray[i];
        }
        if (dataFlavor != null) {
            return dataFlavor;
        }
        if (dataFlavor2 != null) {
            return dataFlavor2;
        }
        return null;
    }

    protected void handleReaderImport(Reader reader, JTextComponent jTextComponent) throws BadLocationException, IOException {
        int n;
        char[] cArray = new char[1024];
        boolean bl = false;
        StringBuilder stringBuilder = null;
        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(n);
            }
            int n2 = 0;
            block5: for (int i = 0; i < n; ++i) {
                switch (cArray[i]) {
                    case '\r': {
                        if (bl) {
                            if (i == 0) {
                                stringBuilder.append('\n');
                                continue block5;
                            }
                            cArray[i - 1] = 10;
                            continue block5;
                        }
                        bl = true;
                        continue block5;
                    }
                    case '\n': {
                        if (!bl) continue block5;
                        if (i > n2 + 1) {
                            stringBuilder.append(cArray, n2, i - n2 - 1);
                        }
                        bl = false;
                        n2 = i;
                        continue block5;
                    }
                    default: {
                        if (!bl) continue block5;
                        if (i == 0) {
                            stringBuilder.append('\n');
                        } else {
                            cArray[i - 1] = 10;
                        }
                        bl = false;
                    }
                }
            }
            if (n2 >= n) continue;
            if (bl) {
                if (n2 >= n - 1) continue;
                stringBuilder.append(cArray, n2, n - n2 - 1);
                continue;
            }
            stringBuilder.append(cArray, n2, n - n2);
        }
        if (this.withinSameComponent) {
            ((RTextArea)jTextComponent).beginAtomicEdit();
        }
        if (bl) {
            stringBuilder.append('\n');
        }
        this.replaceSelection(jTextComponent, stringBuilder != null ? stringBuilder.toString() : "");
    }

    protected void replaceSelection(JTextComponent jTextComponent, String string) {
        jTextComponent.replaceSelection(string);
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        if (((JTextComponent)jComponent).isEditable()) {
            return 3;
        }
        return 1;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        this.exportComp = (JTextComponent)jComponent;
        this.shouldRemove = true;
        this.p0 = this.exportComp.getSelectionStart();
        this.p1 = this.exportComp.getSelectionEnd();
        return this.p0 != this.p1 ? new TextTransferable(this.exportComp, this.p0, this.p1) : null;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (this.shouldRemove && n == 2) {
            TextTransferable textTransferable = (TextTransferable)transferable;
            textTransferable.removeText();
            if (this.withinSameComponent) {
                ((RTextArea)jComponent).endAtomicEdit();
                this.withinSameComponent = false;
            }
        }
        this.exportComp = null;
        if (transferable instanceof TextTransferable) {
            ClipboardHistory.get().add(((TextTransferable)transferable).getPlainData());
        }
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        boolean bl = this.withinSameComponent = jTextComponent == this.exportComp;
        if (this.withinSameComponent && jTextComponent.getCaretPosition() >= this.p0 && jTextComponent.getCaretPosition() <= this.p1) {
            this.shouldRemove = false;
            return true;
        }
        boolean bl2 = false;
        DataFlavor dataFlavor = this.getImportFlavor(transferable.getTransferDataFlavors(), jTextComponent);
        if (dataFlavor != null) {
            try {
                InputContext inputContext = jTextComponent.getInputContext();
                if (inputContext != null) {
                    inputContext.endComposition();
                }
                Reader reader = dataFlavor.getReaderForText(transferable);
                this.handleReaderImport(reader, jTextComponent);
                bl2 = true;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return bl2;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
            return false;
        }
        return this.getImportFlavor(dataFlavorArray, jTextComponent) != null;
    }

    static class TextTransferable
    implements Transferable {
        Position p0;
        Position p1;
        JTextComponent c;
        protected String plainData;
        private static DataFlavor[] stringFlavors;
        private static DataFlavor[] plainFlavors;

        TextTransferable(JTextComponent jTextComponent, int n, int n2) {
            this.c = jTextComponent;
            Document document = jTextComponent.getDocument();
            try {
                this.p0 = document.createPosition(n);
                this.p1 = document.createPosition(n2);
                this.plainData = jTextComponent.getSelectedText();
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        protected String getPlainData() {
            return this.plainData;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (this.isPlainFlavor(dataFlavor)) {
                String string = this.getPlainData();
                String string2 = string = string == null ? "" : string;
                if (String.class.equals(dataFlavor.getRepresentationClass())) {
                    return string;
                }
                if (Reader.class.equals(dataFlavor.getRepresentationClass())) {
                    return new StringReader(string);
                }
            } else if (this.isStringFlavor(dataFlavor)) {
                String string = this.getPlainData();
                string = string == null ? "" : string;
                return string;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            int n = this.isPlainSupported() ? plainFlavors.length : 0;
            int n2 = this.isPlainSupported() ? stringFlavors.length : 0;
            int n3 = n + n2;
            DataFlavor[] dataFlavorArray = new DataFlavor[n3];
            int n4 = 0;
            if (n > 0) {
                System.arraycopy(plainFlavors, 0, dataFlavorArray, n4, n);
                n4 += n;
            }
            if (n2 > 0) {
                System.arraycopy(stringFlavors, 0, dataFlavorArray, n4, n2);
            }
            return dataFlavorArray;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = this.getTransferDataFlavors();
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = plainFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainSupported() {
            return this.plainData != null;
        }

        protected boolean isStringFlavor(DataFlavor dataFlavor) {
            DataFlavor[] dataFlavorArray = stringFlavors;
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                if (!dataFlavorArray[i].equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        void removeText() {
            if (this.p0 != null && this.p1 != null && this.p0.getOffset() != this.p1.getOffset()) {
                try {
                    Document document = this.c.getDocument();
                    document.remove(this.p0.getOffset(), this.p1.getOffset() - this.p0.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        static {
            try {
                plainFlavors = new DataFlavor[2];
                TextTransferable.plainFlavors[0] = new DataFlavor("text/plain;class=java.lang.String");
                TextTransferable.plainFlavors[1] = new DataFlavor("text/plain;class=java.io.Reader");
                stringFlavors = new DataFlavor[2];
                TextTransferable.stringFlavors[0] = new DataFlavor("application/x-java-jvm-local-objectref;class=java.lang.String");
                TextTransferable.stringFlavors[1] = DataFlavor.stringFlavor;
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Error initializing org.fife.ui.RTATextTransferHandler");
            }
        }
    }
}

