/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rtextarea.ClipboardHistory;
import org.fife.ui.rtextarea.ClipboardHistoryPopup;
import org.fife.ui.rtextarea.Gutter;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.IconRowHeader;
import org.fife.ui.rtextarea.LineNumberList;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;

public class RTextAreaEditorKit
extends DefaultEditorKit {
    public static final String rtaBeginRecordingMacroAction = "RTA.BeginRecordingMacroAction";
    public static final String rtaDecreaseFontSizeAction = "RTA.DecreaseFontSizeAction";
    public static final String rtaDeleteLineAction = "RTA.DeleteLineAction";
    public static final String rtaDeletePrevWordAction = "RTA.DeletePrevWordAction";
    public static final String rtaDeleteRestOfLineAction = "RTA.DeleteRestOfLineAction";
    public static final String rtaDumbCompleteWordAction = "RTA.DumbCompleteWordAction";
    public static final String rtaEndRecordingMacroAction = "RTA.EndRecordingMacroAction";
    public static final String rtaIncreaseFontSizeAction = "RTA.IncreaseFontSizeAction";
    public static final String rtaInvertSelectionCaseAction = "RTA.InvertCaseAction";
    public static final String rtaJoinLinesAction = "RTA.JoinLinesAction";
    public static final String rtaLineDownAction = "RTA.LineDownAction";
    public static final String rtaLineUpAction = "RTA.LineUpAction";
    public static final String rtaLowerSelectionCaseAction = "RTA.LowerCaseAction";
    public static final String rtaNextOccurrenceAction = "RTA.NextOccurrenceAction";
    public static final String rtaPrevOccurrenceAction = "RTA.PrevOccurrenceAction";
    public static final String rtaNextBookmarkAction = "RTA.NextBookmarkAction";
    public static final String clipboardHistoryAction = "RTA.PasteHistoryAction";
    public static final String rtaPrevBookmarkAction = "RTA.PrevBookmarkAction";
    public static final String rtaPlaybackLastMacroAction = "RTA.PlaybackLastMacroAction";
    public static final String rtaRedoAction = "RTA.RedoAction";
    public static final String rtaScrollDownAction = "RTA.ScrollDownAction";
    public static final String rtaScrollUpAction = "RTA.ScrollUpAction";
    public static final String rtaSelectionPageUpAction = "RTA.SelectionPageUpAction";
    public static final String rtaSelectionPageDownAction = "RTA.SelectionPageDownAction";
    public static final String rtaSelectionPageLeftAction = "RTA.SelectionPageLeftAction";
    public static final String rtaSelectionPageRightAction = "RTA.SelectionPageRightAction";
    public static final String rtaTimeDateAction = "RTA.TimeDateAction";
    public static final String rtaToggleBookmarkAction = "RTA.ToggleBookmarkAction";
    public static final String rtaToggleTextModeAction = "RTA.ToggleTextModeAction";
    public static final String rtaUndoAction = "RTA.UndoAction";
    public static final String rtaUnselectAction = "RTA.UnselectAction";
    public static final String rtaUpperSelectionCaseAction = "RTA.UpperCaseAction";
    private static final RecordableTextAction[] defaultActions = new RecordableTextAction[]{new BeginAction("caret-begin", false), new BeginAction("selection-begin", true), new BeginLineAction("caret-begin-line", false), new BeginLineAction("selection-begin-line", true), new BeginRecordingMacroAction(), new BeginWordAction("caret-begin-word", false), new BeginWordAction("selection-begin-word", true), new ClipboardHistoryAction(), new CopyAction(), new CutAction(), new DefaultKeyTypedAction(), new DeleteLineAction(), new DeleteNextCharAction(), new DeletePrevCharAction(), new DeletePrevWordAction(), new DeleteRestOfLineAction(), new DumbCompleteWordAction(), new EndAction("caret-end", false), new EndAction("selection-end", true), new EndLineAction("caret-end-line", false), new EndLineAction("selection-end-line", true), new EndRecordingMacroAction(), new EndWordAction("caret-end-word", false), new EndWordAction("caret-end-word", true), new InsertBreakAction(), new InsertContentAction(), new InsertTabAction(), new InvertSelectionCaseAction(), new JoinLinesAction(), new LowerSelectionCaseAction(), new LineMoveAction("RTA.LineUpAction", -1), new LineMoveAction("RTA.LineDownAction", 1), new NextBookmarkAction("RTA.NextBookmarkAction", true), new NextBookmarkAction("RTA.PrevBookmarkAction", false), new NextVisualPositionAction("caret-forward", false, 3), new NextVisualPositionAction("caret-backward", false, 7), new NextVisualPositionAction("selection-forward", true, 3), new NextVisualPositionAction("selection-backward", true, 7), new NextVisualPositionAction("caret-up", false, 1), new NextVisualPositionAction("caret-down", false, 5), new NextVisualPositionAction("selection-up", true, 1), new NextVisualPositionAction("selection-down", true, 5), new NextOccurrenceAction("RTA.NextOccurrenceAction"), new PreviousOccurrenceAction("RTA.PrevOccurrenceAction"), new NextWordAction("caret-next-word", false), new NextWordAction("selection-next-word", true), new PageAction("RTA.SelectionPageLeftAction", true, true), new PageAction("RTA.SelectionPageRightAction", false, true), new PasteAction(), new PlaybackLastMacroAction(), new PreviousWordAction("caret-previous-word", false), new PreviousWordAction("selection-previous-word", true), new RedoAction(), new ScrollAction("RTA.ScrollUpAction", -1), new ScrollAction("RTA.ScrollDownAction", 1), new SelectAllAction(), new SelectLineAction(), new SelectWordAction(), new SetReadOnlyAction(), new SetWritableAction(), new ToggleBookmarkAction(), new ToggleTextModeAction(), new UndoAction(), new UnselectAction(), new UpperSelectionCaseAction(), new VerticalPageAction("page-up", -1, false), new VerticalPageAction("page-down", 1, false), new VerticalPageAction("RTA.SelectionPageUpAction", -1, true), new VerticalPageAction("RTA.SelectionPageDownAction", 1, true)};
    private static final int READBUFFER_SIZE = 32768;

    public IconRowHeader createIconRowHeader(RTextArea rTextArea) {
        return new IconRowHeader(rTextArea);
    }

    public LineNumberList createLineNumberList(RTextArea rTextArea) {
        return new LineNumberList(rTextArea);
    }

    @Override
    public Action[] getActions() {
        return defaultActions;
    }

    @Override
    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        int n2;
        boolean bl;
        char[] cArray = new char[32768];
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = bl = document.getLength() == 0;
        while ((n2 = reader.read(cArray, 0, cArray.length)) != -1) {
            int n3 = 0;
            block5: for (int i = 0; i < n2; ++i) {
                switch (cArray[i]) {
                    case '\r': {
                        if (bl2) {
                            bl4 = true;
                            if (i == 0) {
                                document.insertString(n, "\n", null);
                                ++n;
                                continue block5;
                            }
                            cArray[i - 1] = 10;
                            continue block5;
                        }
                        bl2 = true;
                        continue block5;
                    }
                    case '\n': {
                        if (!bl2) continue block5;
                        if (i > n3 + 1) {
                            document.insertString(n, new String(cArray, n3, i - n3 - 1), null);
                            n += i - n3 - 1;
                        }
                        bl2 = false;
                        n3 = i;
                        bl3 = true;
                        continue block5;
                    }
                    default: {
                        if (!bl2) continue block5;
                        bl4 = true;
                        if (i == 0) {
                            document.insertString(n, "\n", null);
                            ++n;
                        } else {
                            cArray[i - 1] = 10;
                        }
                        bl2 = false;
                    }
                }
            }
            if (n3 >= n2) continue;
            if (bl2) {
                if (n3 >= n2 - 1) continue;
                document.insertString(n, new String(cArray, n3, n2 - n3 - 1), null);
                n += n2 - n3 - 1;
                continue;
            }
            document.insertString(n, new String(cArray, n3, n2 - n3), null);
            n += n2 - n3;
        }
        if (bl2) {
            document.insertString(n, "\n", null);
            bl4 = true;
        }
        if (bl) {
            if (bl3) {
                document.putProperty("__EndOfLine__", "\r\n");
            } else if (bl4) {
                document.putProperty("__EndOfLine__", "\r");
            } else {
                document.putProperty("__EndOfLine__", "\n");
            }
        }
    }

    public static class BeginAction
    extends RecordableTextAction {
        private boolean select;

        public BeginAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (this.select) {
                rTextArea.moveCaretPosition(0);
            } else {
                rTextArea.setCaretPosition(0);
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class BeginLineAction
    extends RecordableTextAction {
        private Segment currentLine = new Segment();
        private boolean select;

        public BeginLineAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            int n = 0;
            try {
                if (rTextArea.getLineWrap()) {
                    int n2;
                    int n3 = rTextArea.getCaretPosition();
                    n = n2 = Utilities.getRowStart(rTextArea, n3);
                } else {
                    int n4 = rTextArea.getCaretPosition();
                    Document document = rTextArea.getDocument();
                    Element element = document.getDefaultRootElement();
                    int n5 = element.getElementIndex(n4);
                    Element element2 = element.getElement(n5);
                    int n6 = element2.getStartOffset();
                    int n7 = element2.getEndOffset();
                    int n8 = n7 - n6;
                    if (n8 > 0) {
                        document.getText(n6, n8, this.currentLine);
                        int n9 = this.getFirstNonWhitespacePos();
                        n9 = n6 + (n9 - this.currentLine.offset);
                        n = n4 != n9 ? n9 : n6;
                    } else {
                        n = n6;
                    }
                }
                if (this.select) {
                    rTextArea.moveCaretPosition(n);
                } else {
                    rTextArea.setCaretPosition(n);
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                badLocationException.printStackTrace();
            }
        }

        private final int getFirstNonWhitespacePos() {
            int n = this.currentLine.offset;
            int n2 = n + this.currentLine.count - 1;
            int n3 = n;
            char[] cArray = this.currentLine.array;
            char c = cArray[n3];
            while ((c == '\t' || c == ' ') && ++n3 < n2) {
                c = cArray[n3];
            }
            return n3;
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class BeginRecordingMacroAction
    extends RecordableTextAction {
        public BeginRecordingMacroAction() {
            super(RTextAreaEditorKit.rtaBeginRecordingMacroAction);
        }

        public BeginRecordingMacroAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            RTextArea.beginRecordingMacro();
        }

        @Override
        public boolean isRecordable() {
            return false;
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaBeginRecordingMacroAction;
        }
    }

    protected static class BeginWordAction
    extends RecordableTextAction {
        private boolean select;

        protected BeginWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            try {
                int n = rTextArea.getCaretPosition();
                int n2 = this.getWordStart(rTextArea, n);
                if (this.select) {
                    rTextArea.moveCaretPosition(n2);
                } else {
                    rTextArea.setCaretPosition(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }

        protected int getWordStart(RTextArea rTextArea, int n) throws BadLocationException {
            return Utilities.getWordStart(rTextArea, n);
        }
    }

    public static class ClipboardHistoryAction
    extends RecordableTextAction {
        private ClipboardHistory clipboardHistory = ClipboardHistory.get();

        public ClipboardHistoryAction() {
            super(RTextAreaEditorKit.clipboardHistoryAction);
        }

        public ClipboardHistoryAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            Window window = SwingUtilities.getWindowAncestor(rTextArea);
            ClipboardHistoryPopup clipboardHistoryPopup = new ClipboardHistoryPopup(window, rTextArea);
            clipboardHistoryPopup.setContents(this.clipboardHistory.getHistory());
            clipboardHistoryPopup.setVisible(true);
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.clipboardHistoryAction;
        }
    }

    public static class CopyAction
    extends RecordableTextAction {
        public CopyAction() {
            super("copy-to-clipboard");
        }

        public CopyAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            rTextArea.copy();
            rTextArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return "copy-to-clipboard";
        }
    }

    public static class CutAction
    extends RecordableTextAction {
        public CutAction() {
            super("cut-to-clipboard");
        }

        public CutAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            rTextArea.cut();
            rTextArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return "cut-to-clipboard";
        }
    }

    public static class DefaultKeyTypedAction
    extends RecordableTextAction {
        private Action delegate = new DefaultEditorKit.DefaultKeyTypedAction();

        public DefaultKeyTypedAction() {
            super("default-typed", null, null, null, null);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            this.delegate.actionPerformed(actionEvent);
        }

        @Override
        public final String getMacroID() {
            return "default-typed";
        }
    }

    public static class DeleteLineAction
    extends RecordableTextAction {
        public DeleteLineAction() {
            super(RTextAreaEditorKit.rtaDeleteLineAction, null, null, null, null);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            int n = rTextArea.getSelectionStart();
            int n2 = rTextArea.getSelectionEnd();
            try {
                int n3 = rTextArea.getLineOfOffset(n);
                int n4 = rTextArea.getLineStartOffset(n3);
                int n5 = rTextArea.getLineOfOffset(n2);
                int n6 = rTextArea.getLineEndOffset(n5);
                if (n5 > n3 && n2 == rTextArea.getLineStartOffset(n5)) {
                    n6 = n2;
                }
                rTextArea.replaceRange(null, n4, n6);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaDeleteLineAction;
        }
    }

    public static class DeleteNextCharAction
    extends RecordableTextAction {
        public DeleteNextCharAction() {
            super("delete-next", null, null, null, null);
        }

        public DeleteNextCharAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            boolean bl = true;
            if (rTextArea != null && rTextArea.isEditable()) {
                try {
                    Document document = rTextArea.getDocument();
                    Caret caret = rTextArea.getCaret();
                    int n = caret.getDot();
                    int n2 = caret.getMark();
                    if (n != n2) {
                        document.remove(Math.min(n, n2), Math.abs(n - n2));
                        bl = false;
                    } else if (n < document.getLength()) {
                        int n3 = 1;
                        if (n < document.getLength() - 1) {
                            String string = document.getText(n, 2);
                            char c = string.charAt(0);
                            char c2 = string.charAt(1);
                            if (c >= '\ud800' && c <= '\udbff' && c2 >= '\udc00' && c2 <= '\udfff') {
                                n3 = 2;
                            }
                        }
                        document.remove(n, n3);
                        bl = false;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (bl) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
            rTextArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return "delete-next";
        }
    }

    public static class DeletePrevCharAction
    extends RecordableTextAction {
        public DeletePrevCharAction() {
            super("delete-previous");
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            boolean bl = true;
            if (rTextArea != null && rTextArea.isEditable()) {
                try {
                    Document document = rTextArea.getDocument();
                    Caret caret = rTextArea.getCaret();
                    int n = caret.getDot();
                    int n2 = caret.getMark();
                    if (n != n2) {
                        document.remove(Math.min(n, n2), Math.abs(n - n2));
                        bl = false;
                    } else if (n > 0) {
                        int n3 = 1;
                        if (n > 1) {
                            String string = document.getText(n - 2, 2);
                            char c = string.charAt(0);
                            char c2 = string.charAt(1);
                            if (c >= '\ud800' && c <= '\udbff' && c2 >= '\udc00' && c2 <= '\udfff') {
                                n3 = 2;
                            }
                        }
                        document.remove(n - n3, n3);
                        bl = false;
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            if (bl) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
        }

        @Override
        public final String getMacroID() {
            return "delete-previous";
        }
    }

    public static class DeletePrevWordAction
    extends RecordableTextAction {
        public DeletePrevWordAction() {
            super(RTextAreaEditorKit.rtaDeletePrevWordAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            try {
                int n = rTextArea.getSelectionStart();
                int n2 = this.getPreviousWordStart(rTextArea, n);
                if (n > n2) {
                    rTextArea.getDocument().remove(n2, n - n2);
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
        }

        @Override
        public String getMacroID() {
            return RTextAreaEditorKit.rtaDeletePrevWordAction;
        }

        protected int getPreviousWordStart(RTextArea rTextArea, int n) throws BadLocationException {
            return Utilities.getPreviousWord(rTextArea, n);
        }
    }

    public static class DeleteRestOfLineAction
    extends RecordableTextAction {
        public DeleteRestOfLineAction() {
            super(RTextAreaEditorKit.rtaDeleteRestOfLineAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            try {
                Document document = rTextArea.getDocument();
                int n = rTextArea.getCaretPosition();
                Element element = document.getDefaultRootElement();
                int n2 = element.getElementIndex(n);
                Element element2 = element.getElement(n2);
                int n3 = element2.getEndOffset() - 1;
                if (n < n3) {
                    document.remove(n, n3 - n);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaDeleteRestOfLineAction;
        }
    }

    public static class DumbCompleteWordAction
    extends RecordableTextAction {
        private int lastWordStart = -1;
        private int lastDot = -1;
        private int searchOffs = -1;
        private String lastPrefix;

        public DumbCompleteWordAction() {
            super(RTextAreaEditorKit.rtaDumbCompleteWordAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                return;
            }
            try {
                int n = rTextArea.getCaretPosition();
                if (n == 0) {
                    return;
                }
                int n2 = this.getWordStart(rTextArea, n);
                if (this.lastWordStart != n2 || n != this.lastDot) {
                    this.lastPrefix = rTextArea.getText(n2, n - n2);
                    if (!this.isAcceptablePrefix(this.lastPrefix)) {
                        UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                        return;
                    }
                    this.lastWordStart = n - this.lastPrefix.length();
                    this.searchOffs = Math.max(this.lastWordStart - 1, 0);
                }
                while (this.searchOffs > 0) {
                    int n3 = 0;
                    try {
                        n3 = this.getPreviousWord(rTextArea, this.searchOffs);
                    }
                    catch (BadLocationException badLocationException) {
                        n3 = -1;
                    }
                    if (n3 == -1) {
                        UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                    } else {
                        int n4 = this.getWordEnd(rTextArea, n3);
                        String string = rTextArea.getText(n3, n4 - n3);
                        this.searchOffs = n3;
                        if (!string.startsWith(this.lastPrefix)) continue;
                        rTextArea.replaceRange(string, this.lastWordStart, n);
                        this.lastDot = rTextArea.getCaretPosition();
                    }
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }

        protected int getPreviousWord(RTextArea rTextArea, int n) throws BadLocationException {
            return Utilities.getPreviousWord(rTextArea, n);
        }

        protected int getWordEnd(RTextArea rTextArea, int n) throws BadLocationException {
            return Utilities.getWordEnd(rTextArea, n);
        }

        protected int getWordStart(RTextArea rTextArea, int n) throws BadLocationException {
            return Utilities.getWordStart(rTextArea, n);
        }

        protected boolean isAcceptablePrefix(String string) {
            return string.length() > 0 && Character.isLetter(string.charAt(string.length() - 1));
        }
    }

    public static class EndAction
    extends RecordableTextAction {
        private boolean select;

        public EndAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            int n = this.getVisibleEnd(rTextArea);
            if (this.select) {
                rTextArea.moveCaretPosition(n);
            } else {
                rTextArea.setCaretPosition(n);
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }

        protected int getVisibleEnd(RTextArea rTextArea) {
            return rTextArea.getDocument().getLength();
        }
    }

    public static class EndLineAction
    extends RecordableTextAction {
        private boolean select;

        public EndLineAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            int n = rTextArea.getCaretPosition();
            int n2 = 0;
            try {
                if (rTextArea.getLineWrap()) {
                    n2 = Utilities.getRowEnd(rTextArea, n);
                } else {
                    Element element = rTextArea.getDocument().getDefaultRootElement();
                    int n3 = element.getElementIndex(n);
                    n2 = element.getElement(n3).getEndOffset() - 1;
                }
                if (this.select) {
                    rTextArea.moveCaretPosition(n2);
                } else {
                    rTextArea.setCaretPosition(n2);
                }
            }
            catch (Exception exception) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class EndRecordingMacroAction
    extends RecordableTextAction {
        public EndRecordingMacroAction() {
            super(RTextAreaEditorKit.rtaEndRecordingMacroAction);
        }

        public EndRecordingMacroAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            RTextArea.endRecordingMacro();
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaEndRecordingMacroAction;
        }

        @Override
        public boolean isRecordable() {
            return false;
        }
    }

    protected static class EndWordAction
    extends RecordableTextAction {
        private boolean select;

        protected EndWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            try {
                int n = rTextArea.getCaretPosition();
                int n2 = this.getWordEnd(rTextArea, n);
                if (this.select) {
                    rTextArea.moveCaretPosition(n2);
                } else {
                    rTextArea.setCaretPosition(n2);
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }

        protected int getWordEnd(RTextArea rTextArea, int n) throws BadLocationException {
            return Utilities.getWordEnd(rTextArea, n);
        }
    }

    public static class InsertBreakAction
    extends RecordableTextAction {
        public InsertBreakAction() {
            super("insert-break");
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            rTextArea.replaceSelection("\n");
        }

        @Override
        public final String getMacroID() {
            return "insert-break";
        }

        @Override
        public boolean isEnabled() {
            JTextComponent jTextComponent = this.getTextComponent(null);
            return jTextComponent == null || jTextComponent.isEditable() ? super.isEnabled() : false;
        }
    }

    public static class InsertContentAction
    extends RecordableTextAction {
        public InsertContentAction() {
            super("insert-content", null, null, null, null);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            String string = actionEvent.getActionCommand();
            if (string != null) {
                rTextArea.replaceSelection(string);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
        }

        @Override
        public final String getMacroID() {
            return "insert-content";
        }
    }

    public static class InsertTabAction
    extends RecordableTextAction {
        public InsertTabAction() {
            super("insert-tab");
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            rTextArea.replaceSelection("\t");
        }

        @Override
        public final String getMacroID() {
            return "insert-tab";
        }
    }

    public static class InvertSelectionCaseAction
    extends RecordableTextAction {
        public InvertSelectionCaseAction() {
            super(RTextAreaEditorKit.rtaInvertSelectionCaseAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            String string = rTextArea.getSelectedText();
            if (string != null) {
                StringBuilder stringBuilder = new StringBuilder(string);
                int n = stringBuilder.length();
                for (int i = 0; i < n; ++i) {
                    char c = stringBuilder.charAt(i);
                    if (Character.isUpperCase(c)) {
                        stringBuilder.setCharAt(i, Character.toLowerCase(c));
                        continue;
                    }
                    if (!Character.isLowerCase(c)) continue;
                    stringBuilder.setCharAt(i, Character.toUpperCase(c));
                }
                rTextArea.replaceSelection(stringBuilder.toString());
            }
            rTextArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class JoinLinesAction
    extends RecordableTextAction {
        public JoinLinesAction() {
            super(RTextAreaEditorKit.rtaJoinLinesAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            try {
                Caret caret = rTextArea.getCaret();
                int n = caret.getDot();
                Document document = rTextArea.getDocument();
                Element element = document.getDefaultRootElement();
                int n2 = element.getElementCount();
                int n3 = element.getElementIndex(n);
                if (n3 == n2 - 1) {
                    UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                    return;
                }
                Element element2 = element.getElement(n3);
                n = element2.getEndOffset() - 1;
                caret.setDot(n);
                document.remove(n, 1);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            rTextArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class LowerSelectionCaseAction
    extends RecordableTextAction {
        public LowerSelectionCaseAction() {
            super(RTextAreaEditorKit.rtaLowerSelectionCaseAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            String string = rTextArea.getSelectedText();
            if (string != null) {
                rTextArea.replaceSelection(string.toLowerCase());
            }
            rTextArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class LineMoveAction
    extends RecordableTextAction {
        private int moveAmt;

        public LineMoveAction(String string, int n) {
            super(string);
            this.moveAmt = n;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            block5: {
                if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                    UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                    return;
                }
                try {
                    int n = rTextArea.getCaretPosition();
                    Document document = rTextArea.getDocument();
                    Element element = document.getDefaultRootElement();
                    int n2 = element.getElementIndex(n);
                    if (this.moveAmt == -1 && n2 > 0) {
                        this.moveLineUp(rTextArea, n2);
                        break block5;
                    }
                    if (this.moveAmt == 1 && n2 < element.getElementCount() - 1) {
                        this.moveLineDown(rTextArea, n2);
                        break block5;
                    }
                    UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                    return;
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                    UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                    return;
                }
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }

        private final void moveLineDown(RTextArea rTextArea, int n) throws BadLocationException {
            Document document = rTextArea.getDocument();
            Element element = document.getDefaultRootElement();
            Element element2 = element.getElement(n);
            int n2 = element2.getStartOffset();
            int n3 = element2.getEndOffset();
            int n4 = rTextArea.getCaretPosition();
            int n5 = n4 - n2;
            String string = document.getText(n2, n3 - n2);
            document.remove(n2, n3 - n2);
            Element element3 = element.getElement(n);
            int n6 = element3.getEndOffset();
            document.insertString(n6, string, null);
            element2 = element.getElement(n + 1);
            rTextArea.setCaretPosition(element2.getStartOffset() + n5);
        }

        private final void moveLineUp(RTextArea rTextArea, int n) throws BadLocationException {
            Document document = rTextArea.getDocument();
            Element element = document.getDefaultRootElement();
            int n2 = element.getElementCount();
            Element element2 = element.getElement(n);
            int n3 = element2.getStartOffset();
            int n4 = n == n2 - 1 ? element2.getEndOffset() - 1 : element2.getEndOffset();
            int n5 = rTextArea.getCaretPosition();
            int n6 = n5 - n3;
            Object object = document.getText(n3, n4 - n3);
            if (n == n2 - 1) {
                --n3;
            }
            document.remove(n3, n4 - n3);
            Element element3 = element.getElement(n - 1);
            int n7 = element3.getStartOffset();
            if (n == n2 - 1) {
                object = (String)object + "\n";
            }
            document.insertString(n7, (String)object, null);
            rTextArea.setCaretPosition(n7 + n6);
        }
    }

    public static class NextBookmarkAction
    extends RecordableTextAction {
        private boolean forward;

        public NextBookmarkAction(String string, boolean bl) {
            super(string);
            this.forward = bl;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            Gutter gutter = RSyntaxUtilities.getGutter(rTextArea);
            if (gutter != null) {
                try {
                    Object object;
                    int n;
                    GutterIconInfo[] gutterIconInfoArray = gutter.getBookmarks();
                    if (gutterIconInfoArray.length == 0) {
                        UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                        return;
                    }
                    Object object2 = null;
                    int n2 = rTextArea.getCaretLineNumber();
                    if (this.forward) {
                        for (n = 0; n < gutterIconInfoArray.length; ++n) {
                            object = gutterIconInfoArray[n];
                            int n3 = object.getMarkedOffset();
                            int n4 = rTextArea.getLineOfOffset(n3);
                            if (n4 <= n2) continue;
                            object2 = object;
                            break;
                        }
                        if (object2 == null) {
                            object2 = gutterIconInfoArray[0];
                        }
                    } else {
                        for (n = gutterIconInfoArray.length - 1; n >= 0; --n) {
                            object = gutterIconInfoArray[n];
                            int n5 = object.getMarkedOffset();
                            int n6 = rTextArea.getLineOfOffset(n5);
                            if (n6 >= n2) continue;
                            object2 = object;
                            break;
                        }
                        if (object2 == null) {
                            object2 = gutterIconInfoArray[gutterIconInfoArray.length - 1];
                        }
                    }
                    n = object2.getMarkedOffset();
                    if (rTextArea instanceof RSyntaxTextArea && ((RSyntaxTextArea)(object = (RSyntaxTextArea)rTextArea)).isCodeFoldingEnabled()) {
                        ((RSyntaxTextArea)object).getFoldManager().ensureOffsetNotInClosedFold(n);
                    }
                    int n7 = rTextArea.getLineOfOffset(n);
                    n = rTextArea.getLineStartOffset(n7);
                    rTextArea.setCaretPosition(n);
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                    badLocationException.printStackTrace();
                }
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class NextVisualPositionAction
    extends RecordableTextAction {
        private boolean select;
        private int direction;

        public NextVisualPositionAction(String string, boolean bl, int n) {
            super(string);
            this.select = bl;
            this.direction = n;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            Caret caret = rTextArea.getCaret();
            int n = caret.getDot();
            if (!this.select) {
                switch (this.direction) {
                    case 3: {
                        int n2 = caret.getMark();
                        if (n == n2) break;
                        caret.setDot(Math.max(n, n2));
                        return;
                    }
                    case 7: {
                        int n2 = caret.getMark();
                        if (n == n2) break;
                        caret.setDot(Math.min(n, n2));
                        return;
                    }
                }
            }
            Position.Bias[] biasArray = new Position.Bias[1];
            Point point = caret.getMagicCaretPosition();
            try {
                Object object;
                if (point == null && (this.direction == 1 || this.direction == 5)) {
                    object = rTextArea.modelToView(n);
                    point = new Point(((Rectangle)object).x, ((Rectangle)object).y);
                }
                n = (object = rTextArea.getNavigationFilter()) != null ? ((NavigationFilter)object).getNextVisualPositionFrom(rTextArea, n, Position.Bias.Forward, this.direction, biasArray) : rTextArea.getUI().getNextVisualPositionFrom(rTextArea, n, Position.Bias.Forward, this.direction, biasArray);
                if (this.select) {
                    caret.moveDot(n);
                } else {
                    caret.setDot(n);
                }
                if (point != null && (this.direction == 1 || this.direction == 5)) {
                    caret.setMagicCaretPosition(point);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class NextOccurrenceAction
    extends RecordableTextAction {
        public NextOccurrenceAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            String string = rTextArea.getSelectedText();
            if (!(string != null && string.length() != 0 || (string = RTextArea.getSelectedOccurrenceText()) != null && string.length() != 0)) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            SearchContext searchContext = new SearchContext(string);
            if (!SearchEngine.find(rTextArea, searchContext).wasFound()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
            RTextArea.setSelectedOccurrenceText(string);
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class PreviousOccurrenceAction
    extends RecordableTextAction {
        public PreviousOccurrenceAction(String string) {
            super(string);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            String string = rTextArea.getSelectedText();
            if (!(string != null && string.length() != 0 || (string = RTextArea.getSelectedOccurrenceText()) != null && string.length() != 0)) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            SearchContext searchContext = new SearchContext(string);
            searchContext.setSearchForward(false);
            if (!SearchEngine.find(rTextArea, searchContext).wasFound()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
            RTextArea.setSelectedOccurrenceText(string);
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class NextWordAction
    extends RecordableTextAction {
        private boolean select;

        public NextWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            int n;
            block5: {
                int n2 = n = rTextArea.getCaretPosition();
                Element element = Utilities.getParagraphElement(rTextArea, n);
                try {
                    n = this.getNextWord(rTextArea, n);
                    if (n >= element.getEndOffset() && n2 != element.getEndOffset() - 1) {
                        n = element.getEndOffset() - 1;
                    }
                }
                catch (BadLocationException badLocationException) {
                    int n3 = rTextArea.getDocument().getLength();
                    if (n == n3) break block5;
                    n = n2 != element.getEndOffset() - 1 ? element.getEndOffset() - 1 : n3;
                }
            }
            if (this.select) {
                rTextArea.moveCaretPosition(n);
            } else {
                rTextArea.setCaretPosition(n);
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }

        protected int getNextWord(RTextArea rTextArea, int n) throws BadLocationException {
            return Utilities.getNextWord(rTextArea, n);
        }
    }

    static class PageAction
    extends RecordableTextAction {
        private boolean select;
        private boolean left;

        public PageAction(String string, boolean bl, boolean bl2) {
            super(string);
            this.select = bl2;
            this.left = bl;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            Rectangle rectangle = new Rectangle();
            rTextArea.computeVisibleRect(rectangle);
            rectangle.x = this.left ? Math.max(0, rectangle.x - rectangle.width) : (rectangle.x += rectangle.width);
            int n = rTextArea.getCaretPosition();
            if (n != -1) {
                n = this.left ? rTextArea.viewToModel(new Point(rectangle.x, rectangle.y)) : rTextArea.viewToModel(new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1));
                Document document = rTextArea.getDocument();
                if (n != 0 && n > document.getLength() - 1) {
                    n = document.getLength() - 1;
                } else if (n < 0) {
                    n = 0;
                }
                if (this.select) {
                    rTextArea.moveCaretPosition(n);
                } else {
                    rTextArea.setCaretPosition(n);
                }
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class PasteAction
    extends RecordableTextAction {
        public PasteAction() {
            super("paste-from-clipboard");
        }

        public PasteAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            rTextArea.paste();
            rTextArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return "paste-from-clipboard";
        }
    }

    public static class PlaybackLastMacroAction
    extends RecordableTextAction {
        public PlaybackLastMacroAction() {
            super(RTextAreaEditorKit.rtaPlaybackLastMacroAction);
        }

        public PlaybackLastMacroAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            rTextArea.playbackLastMacro();
        }

        @Override
        public boolean isRecordable() {
            return false;
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaPlaybackLastMacroAction;
        }
    }

    public static class PreviousWordAction
    extends RecordableTextAction {
        private boolean select;

        public PreviousWordAction(String string, boolean bl) {
            super(string);
            this.select = bl;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            int n = rTextArea.getCaretPosition();
            boolean bl = false;
            try {
                Element element = Utilities.getParagraphElement(rTextArea, n);
                n = this.getPreviousWord(rTextArea, n);
                if (n < element.getStartOffset()) {
                    n = Utilities.getParagraphElement(rTextArea, n).getEndOffset() - 1;
                }
            }
            catch (BadLocationException badLocationException) {
                if (n != 0) {
                    n = 0;
                }
                bl = true;
            }
            if (!bl) {
                if (this.select) {
                    rTextArea.moveCaretPosition(n);
                } else {
                    rTextArea.setCaretPosition(n);
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }

        protected int getPreviousWord(RTextArea rTextArea, int n) throws BadLocationException {
            return Utilities.getPreviousWord(rTextArea, n);
        }
    }

    public static class RedoAction
    extends RecordableTextAction {
        public RedoAction() {
            super(RTextAreaEditorKit.rtaRedoAction);
        }

        public RedoAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (rTextArea.isEnabled() && rTextArea.isEditable()) {
                rTextArea.redoLastAction();
                rTextArea.requestFocusInWindow();
            }
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaRedoAction;
        }
    }

    public static class ScrollAction
    extends RecordableTextAction {
        private int delta;

        public ScrollAction(String string, int n) {
            super(string);
            this.delta = n;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            Container container = rTextArea.getParent();
            if (container instanceof JViewport) {
                JViewport jViewport = (JViewport)container;
                Point point = jViewport.getViewPosition();
                point.y += this.delta * rTextArea.getLineHeight();
                if (point.y < 0) {
                    point.y = 0;
                } else {
                    Rectangle rectangle = jViewport.getViewRect();
                    int n = point.y + rectangle.height;
                    if (n >= rTextArea.getHeight()) {
                        point.y = rTextArea.getHeight() - rectangle.height;
                    }
                }
                jViewport.setViewPosition(point);
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class SelectAllAction
    extends RecordableTextAction {
        public SelectAllAction() {
            super("select-all");
        }

        public SelectAllAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            Document document = rTextArea.getDocument();
            rTextArea.setCaretPosition(0);
            rTextArea.moveCaretPosition(document.getLength());
        }

        @Override
        public final String getMacroID() {
            return "select-all";
        }
    }

    public static class SelectLineAction
    extends RecordableTextAction {
        private Action start = new BeginLineAction("pigdog", false);
        private Action end = new EndLineAction("pigdog", true);

        public SelectLineAction() {
            super("select-line");
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }

        @Override
        public final String getMacroID() {
            return "select-line";
        }
    }

    public static class SelectWordAction
    extends RecordableTextAction {
        protected Action start;
        protected Action end;

        public SelectWordAction() {
            super("select-word");
            this.createActions();
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            this.start.actionPerformed(actionEvent);
            this.end.actionPerformed(actionEvent);
        }

        protected void createActions() {
            this.start = new BeginWordAction("pigdog", false);
            this.end = new EndWordAction("pigdog", true);
        }

        @Override
        public final String getMacroID() {
            return "select-word";
        }
    }

    public static class SetReadOnlyAction
    extends RecordableTextAction {
        public SetReadOnlyAction() {
            super("set-read-only");
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            rTextArea.setEditable(false);
        }

        @Override
        public final String getMacroID() {
            return "set-read-only";
        }

        @Override
        public boolean isRecordable() {
            return false;
        }
    }

    public static class SetWritableAction
    extends RecordableTextAction {
        public SetWritableAction() {
            super("set-writable");
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            rTextArea.setEditable(true);
        }

        @Override
        public final String getMacroID() {
            return "set-writable";
        }

        @Override
        public boolean isRecordable() {
            return false;
        }
    }

    public static class ToggleBookmarkAction
    extends RecordableTextAction {
        public ToggleBookmarkAction() {
            super(RTextAreaEditorKit.rtaToggleBookmarkAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            Gutter gutter = RSyntaxUtilities.getGutter(rTextArea);
            if (gutter != null) {
                int n = rTextArea.getCaretLineNumber();
                try {
                    gutter.toggleBookmark(n);
                }
                catch (BadLocationException badLocationException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                    badLocationException.printStackTrace();
                }
            }
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaToggleBookmarkAction;
        }
    }

    public static class ToggleTextModeAction
    extends RecordableTextAction {
        public ToggleTextModeAction() {
            super(RTextAreaEditorKit.rtaToggleTextModeAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            int n = rTextArea.getTextMode();
            if (n == 0) {
                rTextArea.setTextMode(1);
            } else {
                rTextArea.setTextMode(0);
            }
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaToggleTextModeAction;
        }
    }

    public static class UndoAction
    extends RecordableTextAction {
        public UndoAction() {
            super(RTextAreaEditorKit.rtaUndoAction);
        }

        public UndoAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (rTextArea.isEnabled() && rTextArea.isEditable()) {
                rTextArea.undoLastAction();
                rTextArea.requestFocusInWindow();
            }
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaUndoAction;
        }
    }

    public static class UnselectAction
    extends RecordableTextAction {
        public UnselectAction() {
            super(RTextAreaEditorKit.rtaUnselectAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            rTextArea.setCaretPosition(rTextArea.getCaretPosition());
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaUnselectAction;
        }
    }

    public static class UpperSelectionCaseAction
    extends RecordableTextAction {
        public UpperSelectionCaseAction() {
            super(RTextAreaEditorKit.rtaUpperSelectionCaseAction);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            String string = rTextArea.getSelectedText();
            if (string != null) {
                rTextArea.replaceSelection(string.toUpperCase());
            }
            rTextArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class VerticalPageAction
    extends RecordableTextAction {
        private boolean select;
        private int direction;

        public VerticalPageAction(String string, int n, boolean bl) {
            super(string);
            this.select = bl;
            this.direction = n;
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            Point point;
            Caret caret;
            Rectangle rectangle;
            block6: {
                Rectangle rectangle2 = rTextArea.getVisibleRect();
                rectangle = new Rectangle(rectangle2);
                int n = rTextArea.getCaretPosition();
                int n2 = rTextArea.getScrollableBlockIncrement(rectangle2, 1, this.direction);
                int n3 = rectangle2.y;
                caret = rTextArea.getCaret();
                point = caret.getMagicCaretPosition();
                if (n != -1) {
                    try {
                        Rectangle rectangle3 = rTextArea.modelToView(n);
                        int n4 = point != null ? point.x : rectangle3.x;
                        int n5 = rectangle3.height;
                        int n6 = this.direction * ((int)Math.ceil((double)n2 / (double)n5) - 1) * n5;
                        rectangle.y = this.constrainY(rTextArea, n3 + n6, n6, rectangle2.height);
                        int n7 = rectangle2.contains(rectangle3.x, rectangle3.y) ? rTextArea.viewToModel(new Point(n4, this.constrainY(rTextArea, rectangle3.y + n6, 0, 0))) : (this.direction == -1 ? rTextArea.viewToModel(new Point(n4, rectangle.y)) : rTextArea.viewToModel(new Point(n4, rectangle.y + rectangle2.height)));
                        n7 = this.constrainOffset(rTextArea, n7);
                        if (n7 == n) break block6;
                        this.adjustScrollIfNecessary(rTextArea, rectangle, n3, n7);
                        if (this.select) {
                            rTextArea.moveCaretPosition(n7);
                            break block6;
                        }
                        rTextArea.setCaretPosition(n7);
                    }
                    catch (BadLocationException badLocationException) {}
                } else {
                    int n8 = this.direction * n2;
                    rectangle.y = this.constrainY(rTextArea, n3 + n8, n8, rectangle2.height);
                }
            }
            if (point != null) {
                caret.setMagicCaretPosition(point);
            }
            rTextArea.scrollRectToVisible(rectangle);
        }

        private int constrainY(JTextComponent jTextComponent, int n, int n2, int n3) {
            if (n < 0) {
                n = 0;
            } else if (n + n2 > jTextComponent.getHeight()) {
                n = Math.max(0, jTextComponent.getHeight() - n3);
            }
            return n;
        }

        private int constrainOffset(JTextComponent jTextComponent, int n) {
            Document document = jTextComponent.getDocument();
            if (n != 0 && n > document.getLength()) {
                n = document.getLength();
            }
            if (n < 0) {
                n = 0;
            }
            return n;
        }

        private void adjustScrollIfNecessary(JTextComponent jTextComponent, Rectangle rectangle, int n, int n2) {
            try {
                Rectangle rectangle2 = jTextComponent.modelToView(n2);
                if (rectangle2.y < rectangle.y || rectangle2.y > rectangle.y + rectangle.height || rectangle2.y + rectangle2.height > rectangle.y + rectangle.height) {
                    int n3 = rectangle2.y < rectangle.y ? rectangle2.y : rectangle2.y + rectangle2.height - rectangle.height;
                    if (this.direction == -1 && n3 < n || this.direction == 1 && n3 > n) {
                        rectangle.y = n3;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public final String getMacroID() {
            return this.getName();
        }
    }

    public static class TimeDateAction
    extends RecordableTextAction {
        public TimeDateAction() {
            super(RTextAreaEditorKit.rtaTimeDateAction);
        }

        public TimeDateAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            if (!rTextArea.isEditable() || !rTextArea.isEnabled()) {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
                return;
            }
            Date date = new Date();
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            String string = dateFormat.format(date);
            rTextArea.replaceSelection(string);
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaTimeDateAction;
        }
    }

    public static class IncreaseFontSizeAction
    extends RecordableTextAction {
        protected float increaseAmount;
        protected static final float MAXIMUM_SIZE = 40.0f;

        public IncreaseFontSizeAction() {
            super(RTextAreaEditorKit.rtaIncreaseFontSizeAction);
            this.initialize();
        }

        public IncreaseFontSizeAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
            this.initialize();
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            Font font = rTextArea.getFont();
            float f = font.getSize2D();
            float f2 = f + this.increaseAmount;
            if (f2 <= 40.0f) {
                font = font.deriveFont(f2);
                rTextArea.setFont(font);
            } else if (f < 40.0f) {
                font = font.deriveFont(40.0f);
                rTextArea.setFont(font);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
            rTextArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaIncreaseFontSizeAction;
        }

        protected void initialize() {
            this.increaseAmount = 1.0f;
        }
    }

    public static class DecreaseFontSizeAction
    extends RecordableTextAction {
        protected float decreaseAmount;
        protected static final float MINIMUM_SIZE = 2.0f;

        public DecreaseFontSizeAction() {
            super(RTextAreaEditorKit.rtaDecreaseFontSizeAction);
            this.initialize();
        }

        public DecreaseFontSizeAction(String string, Icon icon, String string2, Integer n, KeyStroke keyStroke) {
            super(string, icon, string2, n, keyStroke);
            this.initialize();
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            Font font = rTextArea.getFont();
            float f = font.getSize2D();
            float f2 = f - this.decreaseAmount;
            if (f2 >= 2.0f) {
                font = font.deriveFont(f2);
                rTextArea.setFont(font);
            } else if (f > 2.0f) {
                font = font.deriveFont(2.0f);
                rTextArea.setFont(font);
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
            }
            rTextArea.requestFocusInWindow();
        }

        @Override
        public final String getMacroID() {
            return RTextAreaEditorKit.rtaDecreaseFontSizeAction;
        }

        protected void initialize() {
            this.decreaseAmount = 1.0f;
        }
    }

    public static class BeepAction
    extends RecordableTextAction {
        public BeepAction() {
            super("beep");
        }

        @Override
        public void actionPerformedImpl(ActionEvent actionEvent, RTextArea rTextArea) {
            UIManager.getLookAndFeel().provideErrorFeedback(rTextArea);
        }

        @Override
        public final String getMacroID() {
            return "beep";
        }
    }
}

