/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rtextarea.ChangeableHighlightPainter;
import org.fife.ui.rtextarea.RTextArea;

public class RTextAreaHighlighter
extends BasicTextUI.BasicHighlighter {
    protected RTextArea textArea;
    private List<HighlightInfo> markAllHighlights = new ArrayList<HighlightInfo>();

    Object addMarkAllHighlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        Document document = this.textArea.getDocument();
        TextUI textUI = this.textArea.getUI();
        LayeredHighlightInfoImpl layeredHighlightInfoImpl = new LayeredHighlightInfoImpl();
        layeredHighlightInfoImpl.setPainter(highlightPainter);
        layeredHighlightInfoImpl.p0 = document.createPosition(n);
        layeredHighlightInfoImpl.p1 = document.createPosition(n2 - 1);
        this.markAllHighlights.add(layeredHighlightInfoImpl);
        textUI.damageRange(this.textArea, n, n2);
        return layeredHighlightInfoImpl;
    }

    void clearMarkAllHighlights() {
        for (HighlightInfo highlightInfo : this.markAllHighlights) {
            this.repaintListHighlight(highlightInfo);
        }
        this.markAllHighlights.clear();
    }

    @Override
    public void deinstall(JTextComponent jTextComponent) {
        this.textArea = null;
        this.markAllHighlights.clear();
    }

    public int getMarkAllHighlightCount() {
        return this.markAllHighlights.size();
    }

    public List<DocumentRange> getMarkAllHighlightRanges() {
        ArrayList<DocumentRange> arrayList = new ArrayList<DocumentRange>(this.markAllHighlights.size());
        for (HighlightInfo highlightInfo : this.markAllHighlights) {
            int n = highlightInfo.getStartOffset();
            int n2 = highlightInfo.getEndOffset() + 1;
            DocumentRange documentRange = new DocumentRange(n, n2);
            arrayList.add(documentRange);
        }
        return arrayList;
    }

    @Override
    public void install(JTextComponent jTextComponent) {
        super.install(jTextComponent);
        this.textArea = (RTextArea)jTextComponent;
    }

    @Override
    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        this.paintListLayered(graphics, n, n2, shape, jTextComponent, view, this.markAllHighlights);
        super.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, view);
    }

    protected void paintListLayered(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view, List<? extends HighlightInfo> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            HighlightInfo highlightInfo = list.get(i);
            if (!(highlightInfo instanceof LayeredHighlightInfo)) continue;
            LayeredHighlightInfo layeredHighlightInfo = (LayeredHighlightInfo)highlightInfo;
            int n3 = layeredHighlightInfo.getStartOffset();
            int n4 = layeredHighlightInfo.getEndOffset() + 1;
            if ((n >= n3 || n2 <= n3) && (n < n3 || n >= n4)) continue;
            layeredHighlightInfo.paintLayeredHighlights(graphics, n, n2, shape, jTextComponent, view);
        }
    }

    protected void repaintListHighlight(HighlightInfo highlightInfo) {
        if (highlightInfo instanceof LayeredHighlightInfoImpl) {
            LayeredHighlightInfoImpl layeredHighlightInfoImpl = (LayeredHighlightInfoImpl)highlightInfo;
            if (layeredHighlightInfoImpl.width > 0 && layeredHighlightInfoImpl.height > 0) {
                this.textArea.repaint(layeredHighlightInfoImpl.x, layeredHighlightInfoImpl.y, layeredHighlightInfoImpl.width, layeredHighlightInfoImpl.height);
            }
        } else {
            TextUI textUI = this.textArea.getUI();
            textUI.damageRange(this.textArea, highlightInfo.getStartOffset(), highlightInfo.getEndOffset());
        }
    }

    protected static class LayeredHighlightInfoImpl
    extends HighlightInfoImpl
    implements LayeredHighlightInfo {
        public int x;
        public int y;
        public int width;
        public int height;

        protected LayeredHighlightInfoImpl() {
        }

        void union(Shape shape) {
            Rectangle rectangle;
            if (shape == null) {
                return;
            }
            Rectangle rectangle2 = rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = rectangle.x;
                this.y = rectangle.y;
                this.width = rectangle.width;
                this.height = rectangle.height;
            } else {
                this.width = Math.max(this.x + this.width, rectangle.x + rectangle.width);
                this.height = Math.max(this.y + this.height, rectangle.y + rectangle.height);
                this.x = Math.min(this.x, rectangle.x);
                this.width -= this.x;
                this.y = Math.min(this.y, rectangle.y);
                this.height -= this.y;
            }
        }

        @Override
        public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            int n3 = this.getStartOffset();
            int n4 = this.getEndOffset();
            n = Math.max(n3, n);
            n2 = Math.min(++n4, n2);
            n2 = Math.min(n2, jTextComponent.getDocument().getLength());
            if (this.getColor() != null && this.getPainter() instanceof ChangeableHighlightPainter) {
                ((ChangeableHighlightPainter)this.getPainter()).setPaint(this.getColor());
            }
            this.union(((LayeredHighlighter.LayerPainter)this.getPainter()).paintLayer(graphics, n, n2, shape, jTextComponent, view));
        }
    }

    protected static class HighlightInfoImpl
    implements HighlightInfo {
        private Position p0;
        private Position p1;
        private Highlighter.HighlightPainter painter;

        protected HighlightInfoImpl() {
        }

        public Color getColor() {
            return null;
        }

        @Override
        public int getStartOffset() {
            return this.p0.getOffset();
        }

        @Override
        public int getEndOffset() {
            return this.p1.getOffset();
        }

        @Override
        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }

        public void setStartOffset(Position position) {
            this.p0 = position;
        }

        public void setEndOffset(Position position) {
            this.p1 = position;
        }

        public void setPainter(Highlighter.HighlightPainter highlightPainter) {
            this.painter = highlightPainter;
        }
    }

    public static interface HighlightInfo
    extends Highlighter.Highlight {
    }

    public static interface LayeredHighlightInfo
    extends HighlightInfo {
        public void paintLayeredHighlights(Graphics var1, int var2, int var3, Shape var4, JTextComponent var5, View var6);
    }
}

