/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class SearchContext
implements Cloneable {
    public static final String PROPERTY_SEARCH_FOR = "Search.searchFor";
    public static final String PROPERTY_REPLACE_WITH = "Search.replaceWith";
    public static final String PROPERTY_MATCH_CASE = "Search.MatchCase";
    public static final String PROPERTY_MATCH_WHOLE_WORD = "Search.MatchWholeWord";
    public static final String PROPERTY_SEARCH_FORWARD = "Search.Forward";
    public static final String PROPERTY_SELECTION_ONLY = "Search.SelectionOnly";
    public static final String PROPERTY_USE_REGEX = "Search.UseRegex";
    public static final String PROPERTY_MARK_ALL = "Search.MarkAll";
    private String searchFor;
    private String replaceWith;
    private boolean forward;
    private boolean matchCase;
    private boolean wholeWord;
    private boolean regex;
    private boolean selectionOnly;
    private boolean markAll;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public SearchContext() {
        this(null);
    }

    public SearchContext(String string) {
        this(string, false);
    }

    public SearchContext(String string, boolean bl) {
        this.searchFor = string;
        this.matchCase = bl;
        this.markAll = true;
        this.forward = true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public SearchContext clone() {
        try {
            SearchContext searchContext = null;
            searchContext = (SearchContext)super.clone();
            searchContext.support = new PropertyChangeSupport(searchContext);
            return searchContext;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Should never happen", cloneNotSupportedException);
        }
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        this.support.firePropertyChange(string, bl, bl2);
    }

    protected void firePropertyChange(String string, String string2, String string3) {
        this.support.firePropertyChange(string, string2, string3);
    }

    public boolean getMarkAll() {
        return this.markAll;
    }

    public boolean getMatchCase() {
        return this.matchCase;
    }

    public String getReplaceWith() {
        return this.replaceWith;
    }

    public String getSearchFor() {
        return this.searchFor;
    }

    public boolean getSearchForward() {
        return this.forward;
    }

    public boolean getSearchSelectionOnly() {
        return this.selectionOnly;
    }

    public boolean getWholeWord() {
        return this.wholeWord;
    }

    public boolean isRegularExpression() {
        return this.regex;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setMarkAll(boolean bl) {
        if (bl != this.markAll) {
            this.markAll = bl;
            this.firePropertyChange(PROPERTY_MARK_ALL, !bl, bl);
        }
    }

    public void setMatchCase(boolean bl) {
        if (bl != this.matchCase) {
            this.matchCase = bl;
            this.firePropertyChange(PROPERTY_MATCH_CASE, !bl, bl);
        }
    }

    public void setRegularExpression(boolean bl) {
        if (bl != this.regex) {
            this.regex = bl;
            this.firePropertyChange(PROPERTY_USE_REGEX, !bl, bl);
        }
    }

    public void setReplaceWith(String string) {
        if (string == null && this.replaceWith != null || string != null && !string.equals(this.replaceWith)) {
            String string2 = this.replaceWith;
            this.replaceWith = string;
            this.firePropertyChange(PROPERTY_REPLACE_WITH, string2, string);
        }
    }

    public void setSearchFor(String string) {
        if (string == null && this.searchFor != null || string != null && !string.equals(this.searchFor)) {
            String string2 = this.searchFor;
            this.searchFor = string;
            this.firePropertyChange(PROPERTY_SEARCH_FOR, string2, string);
        }
    }

    public void setSearchForward(boolean bl) {
        if (bl != this.forward) {
            this.forward = bl;
            this.firePropertyChange(PROPERTY_SEARCH_FORWARD, !bl, bl);
        }
    }

    public void setSearchSelectionOnly(boolean bl) {
        if (bl != this.selectionOnly) {
            this.selectionOnly = bl;
            this.firePropertyChange(PROPERTY_SELECTION_ONLY, !bl, bl);
            if (bl) {
                throw new UnsupportedOperationException("Searching in selection is not currently supported");
            }
        }
    }

    public void setWholeWord(boolean bl) {
        if (bl != this.wholeWord) {
            this.wholeWord = bl;
            this.firePropertyChange(PROPERTY_MATCH_WHOLE_WORD, !bl, bl);
        }
    }

    public String toString() {
        return "[SearchContext: searchFor=" + this.getSearchFor() + ", replaceWith=" + this.getReplaceWith() + ", matchCase=" + this.getMatchCase() + ", wholeWord=" + this.getWholeWord() + ", regex=" + this.isRegularExpression() + ", markAll=" + this.getMarkAll() + "]";
    }
}

