/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.PredicateUtils;
import java.util.Iterator;

public class DegreeDistributionRanker
extends AbstractRanker {
    public static final String KEY = "jung.algorithms.importance.DegreeDistributionRanker.RankScore";
    private boolean mUseInDegree;
    private boolean directed;

    public DegreeDistributionRanker(Graph graph) {
        this(graph, true);
    }

    public DegreeDistributionRanker(Graph graph, boolean useInDegree) {
        this.initialize(graph, true, false);
        this.mUseInDegree = useInDegree;
        this.directed = PredicateUtils.enforcesEdgeConstraint(this.getGraph(), Graph.DIRECTED_EDGE);
    }

    protected double evaluateIteration() {
        Vertex currentVertex = null;
        Iterator it = this.getVertices().iterator();
        while (it.hasNext()) {
            currentVertex = (Vertex)it.next();
            if (this.directed) {
                if (this.mUseInDegree) {
                    this.setRankScore(currentVertex, currentVertex.inDegree());
                    continue;
                }
                this.setRankScore(currentVertex, currentVertex.outDegree());
                continue;
            }
            this.setRankScore(currentVertex, currentVertex.degree());
        }
        this.normalizeRankings();
        return 0.0;
    }

    public String getRankScoreKey() {
        return KEY;
    }
}

