/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.decorators;

import edu.uci.ics.jung.exceptions.FatalException;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.VertexStringer;
import edu.uci.ics.jung.utils.UserData;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class StringLabeller
implements VertexStringer {
    public static final Object DEFAULT_STRING_LABELER_KEY = "StringLabeller.LabelDefaultKey";
    protected Map labelToVertex = new HashMap();
    protected Map vertexToLabel = new HashMap();
    protected Graph graph;

    protected StringLabeller(Graph g) {
        this.graph = g;
    }

    public static StringLabeller getLabeller(Graph g) {
        return StringLabeller.getLabeller(g, DEFAULT_STRING_LABELER_KEY);
    }

    public static boolean hasStringLabeller(Graph g) {
        return StringLabeller.hasStringLabeller(g, DEFAULT_STRING_LABELER_KEY);
    }

    public static boolean hasStringLabeller(Graph g, Object key) {
        StringLabeller id = (StringLabeller)g.getUserDatum(key);
        return id != null;
    }

    public static StringLabeller getLabeller(Graph g, Object key) {
        StringLabeller id = (StringLabeller)g.getUserDatum(key);
        if (id != null) {
            return id;
        }
        id = new StringLabeller(g);
        g.addUserDatum(key, id, UserData.REMOVE);
        return id;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public String getLabel(ArchetypeVertex v) {
        if (this.getGraph().getVertices().contains(v)) {
            return (String)this.vertexToLabel.get(v);
        }
        throw new FatalException("Vertex not in my graph!");
    }

    public Vertex getVertex(String label) {
        return (Vertex)this.labelToVertex.get(label);
    }

    public void setLabel(Vertex v, String l) throws UniqueLabelException {
        if (v.getGraph() == this.graph) {
            if (this.labelToVertex.containsKey(l)) {
                throw new UniqueLabelException(l + " is already on vertex " + this.labelToVertex.get(l));
            }
            if (this.vertexToLabel.containsKey(v)) {
                Object junk = this.vertexToLabel.get(v);
                this.labelToVertex.remove(junk);
            }
        } else {
            throw new FatalException("This vertex is not a part of this graph");
        }
        this.vertexToLabel.put(v, l);
        this.labelToVertex.put(l, v);
    }

    public void assignDefaultLabels(Set vertices, int offset) throws UniqueLabelException {
        int labelIdx = offset;
        Iterator udcIt = vertices.iterator();
        while (udcIt.hasNext()) {
            Vertex v = (Vertex)udcIt.next();
            String label = String.valueOf(labelIdx);
            this.setLabel(v, label);
            ++labelIdx;
        }
    }

    public Vertex removeLabel(String string) {
        if (this.labelToVertex.containsKey(string)) {
            Vertex v = (Vertex)this.labelToVertex.get(string);
            this.labelToVertex.remove(string);
            this.vertexToLabel.remove(v);
            return v;
        }
        return null;
    }

    public void clear() {
        this.vertexToLabel.clear();
        this.labelToVertex.clear();
    }

    public static class UniqueLabelException
    extends Exception {
        public UniqueLabelException(String string) {
            super(string);
        }
    }
}

