/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.ChangeEventSupport;
import edu.uci.ics.jung.utils.DefaultChangeEventSupport;
import edu.uci.ics.jung.utils.Pair;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.visualization.Coordinates;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.LayoutDecorator;
import edu.uci.ics.jung.visualization.LayoutMutable;
import edu.uci.ics.jung.visualization.PersistentLayout;
import edu.uci.ics.jung.visualization.RadiusGraphElementAccessor;
import java.awt.Dimension;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PersistentLayoutImpl
extends LayoutDecorator
implements PersistentLayout {
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected Map map = new HashMap();
    protected Object key;
    protected Set dontmove = new HashSet();
    protected boolean locked;
    private static final Object BASE_KEY = "edu.uci.ics.jung.Base_Visualization_Key";
    protected RadiusGraphElementAccessor elementAccessor;

    public PersistentLayoutImpl(Layout layout) {
        super(layout);
        this.elementAccessor = new RadiusGraphElementAccessor(layout);
        if (layout instanceof ChangeEventSupport) {
            ((ChangeEventSupport)((Object)layout)).addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    PersistentLayoutImpl.this.fireStateChanged();
                }
            });
        }
    }

    protected void initializeLocations() {
        Iterator iter = this.getGraph().getVertices().iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            Coordinates coord = (Coordinates)v.getUserDatum(this.getBaseKey());
            if (coord == null) {
                coord = new Coordinates();
                v.addUserDatum(this.getBaseKey(), coord, UserData.REMOVE);
            }
            if (this.dontmove.contains(v)) continue;
            this.initializeLocation(v, coord, this.getCurrentSize());
        }
    }

    protected void initializeLocation(Vertex v, Coordinates coord, Dimension d) {
        double y;
        double x;
        PersistentLayout.Point point = (PersistentLayout.Point)this.map.get(new Integer(v.hashCode()));
        if (point == null) {
            x = Math.random() * d.getWidth();
            y = Math.random() * d.getHeight();
        } else {
            x = point.x;
            y = point.y;
        }
        coord.setX(x);
        coord.setY(y);
    }

    public void persist(String fileName) throws IOException {
        Set set = this.getGraph().getVertices();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Vertex v = (Vertex)iterator.next();
            PersistentLayout.Point p = new PersistentLayout.Point(this.getX(v), this.getY(v));
            this.map.put(new Integer(v.hashCode()), p);
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(fileName));
        oos.writeObject(this.map);
        oos.close();
    }

    public void restore(String fileName) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(fileName));
        this.map = (Map)ois.readObject();
        ois.close();
        this.initializeLocations();
        this.locked = true;
    }

    public void lock(boolean locked) {
        this.locked = locked;
    }

    public boolean incrementsAreDone() {
        return this.locked;
    }

    public void lockVertex(Vertex v) {
        this.dontmove.add(v);
        this.delegate.lockVertex(v);
    }

    public void unlockVertex(Vertex v) {
        this.dontmove.remove(v);
        this.delegate.unlockVertex(v);
    }

    public Object getBaseKey() {
        if (this.key == null) {
            this.key = new Pair(this.delegate, BASE_KEY);
        }
        return this.key;
    }

    public void update() {
        if (this.delegate instanceof LayoutMutable) {
            ((LayoutMutable)this.delegate).update();
        }
    }

    public void addChangeListener(ChangeListener l) {
        if (this.delegate instanceof ChangeEventSupport) {
            ((ChangeEventSupport)((Object)this.delegate)).addChangeListener(l);
        }
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.delegate instanceof ChangeEventSupport) {
            ((ChangeEventSupport)((Object)this.delegate)).removeChangeListener(l);
        }
        this.changeSupport.removeChangeListener(l);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }
}

