/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.SettableVertexLocationFunction;
import edu.uci.ics.jung.visualization.control.AnimatedPickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.EditingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ShearingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import java.awt.Dimension;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.basic.BasicIconFactory;

public class EditingModalGraphMouse
extends PluggableGraphMouse
implements ModalGraphMouse,
ItemSelectable {
    protected float in;
    protected float out;
    protected ItemListener modeListener;
    protected JComboBox modeBox;
    protected JMenu modeMenu;
    protected ModalGraphMouse.Mode mode;
    protected EventListenerList listenerList = new EventListenerList();
    protected GraphMousePlugin pickingPlugin;
    protected GraphMousePlugin translatingPlugin;
    protected GraphMousePlugin animatedPickingPlugin;
    protected GraphMousePlugin scalingPlugin;
    protected GraphMousePlugin rotatingPlugin;
    protected GraphMousePlugin shearingPlugin;
    protected GraphMousePlugin editingPlugin;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public EditingModalGraphMouse() {
        this(1.1f, 0.9090909f);
    }

    public EditingModalGraphMouse(float in, float out) {
        this.in = in;
        this.out = out;
        this.loadPlugins();
    }

    protected void loadPlugins() {
        this.pickingPlugin = new PickingGraphMousePlugin();
        this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
        this.translatingPlugin = new TranslatingGraphMousePlugin(16);
        this.scalingPlugin = new ScalingGraphMousePlugin(new CrossoverScalingControl(), 0, this.in, this.out);
        this.rotatingPlugin = new RotatingGraphMousePlugin();
        this.shearingPlugin = new ShearingGraphMousePlugin();
        this.editingPlugin = new EditingGraphMousePlugin();
        this.add(this.scalingPlugin);
        this.setMode(ModalGraphMouse.Mode.EDITING);
    }

    public void setVertexLocations(SettableVertexLocationFunction vertexLocations) {
        ((EditingGraphMousePlugin)this.editingPlugin).setVertexLocations(vertexLocations);
    }

    public void setMode(ModalGraphMouse.Mode mode) {
        if (this.mode != mode) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.mode, 2));
            this.mode = mode;
            if (mode == ModalGraphMouse.Mode.TRANSFORMING) {
                this.setTransformingMode();
            } else if (mode == ModalGraphMouse.Mode.PICKING) {
                this.setPickingMode();
            } else if (mode == ModalGraphMouse.Mode.EDITING) {
                this.setEditingMode();
            }
            if (this.modeBox != null) {
                this.modeBox.setSelectedItem(mode);
            }
            this.fireItemStateChanged(new ItemEvent(this, 701, mode, 1));
        }
    }

    protected void setPickingMode() {
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.remove(this.editingPlugin);
        this.add(this.pickingPlugin);
        this.add(this.animatedPickingPlugin);
    }

    protected void setTransformingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.editingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
    }

    protected void setEditingMode() {
        this.remove(this.pickingPlugin);
        this.remove(this.animatedPickingPlugin);
        this.remove(this.translatingPlugin);
        this.remove(this.rotatingPlugin);
        this.remove(this.shearingPlugin);
        this.add(this.editingPlugin);
    }

    public void setZoomAtMouse(boolean zoomAtMouse) {
        ((ScalingGraphMousePlugin)this.scalingPlugin).setZoomAtMouse(zoomAtMouse);
    }

    public ItemListener getModeListener() {
        if (this.modeListener == null) {
            this.modeListener = new ModeListener();
        }
        return this.modeListener;
    }

    public JComboBox getModeComboBox() {
        if (this.modeBox == null) {
            this.modeBox = new JComboBox<ModalGraphMouse.Mode>(new ModalGraphMouse.Mode[]{ModalGraphMouse.Mode.TRANSFORMING, ModalGraphMouse.Mode.PICKING, ModalGraphMouse.Mode.EDITING});
            this.modeBox.addItemListener(this.getModeListener());
        }
        this.modeBox.setSelectedItem(this.mode);
        return this.modeBox;
    }

    public JMenu getModeMenu() {
        if (this.modeMenu == null) {
            this.modeMenu = new JMenu();
            Icon icon = BasicIconFactory.getMenuArrowIcon();
            this.modeMenu.setIcon(BasicIconFactory.getMenuArrowIcon());
            this.modeMenu.setPreferredSize(new Dimension(icon.getIconWidth() + 10, icon.getIconHeight() + 10));
            final JRadioButtonMenuItem transformingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.TRANSFORMING.toString());
            transformingButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        EditingModalGraphMouse.this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
                    }
                }
            });
            final JRadioButtonMenuItem pickingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.PICKING.toString());
            pickingButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        EditingModalGraphMouse.this.setMode(ModalGraphMouse.Mode.PICKING);
                    }
                }
            });
            final JRadioButtonMenuItem editingButton = new JRadioButtonMenuItem(ModalGraphMouse.Mode.EDITING.toString());
            editingButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        EditingModalGraphMouse.this.setMode(ModalGraphMouse.Mode.EDITING);
                    }
                }
            });
            ButtonGroup radio = new ButtonGroup();
            radio.add(transformingButton);
            radio.add(pickingButton);
            radio.add(editingButton);
            transformingButton.setSelected(true);
            this.modeMenu.add(transformingButton);
            this.modeMenu.add(pickingButton);
            this.modeMenu.add(editingButton);
            this.modeMenu.setToolTipText("Menu for setting Mouse Mode");
            this.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        if (e.getItem() == ModalGraphMouse.Mode.TRANSFORMING) {
                            transformingButton.setSelected(true);
                        } else if (e.getItem() == ModalGraphMouse.Mode.PICKING) {
                            pickingButton.setSelected(true);
                        } else if (e.getItem() == ModalGraphMouse.Mode.EDITING) {
                            editingButton.setSelected(true);
                        }
                    }
                }
            });
        }
        return this.modeMenu;
    }

    public void addItemListener(ItemListener aListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = EditingModalGraphMouse.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, aListener);
    }

    public void removeItemListener(ItemListener aListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = EditingModalGraphMouse.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, aListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = EditingModalGraphMouse.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    }

    public Object[] getSelectedObjects() {
        if (this.mode == null) {
            return new Object[0];
        }
        Object[] result = new Object[]{this.mode};
        return result;
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ItemListener == null ? EditingModalGraphMouse.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) continue;
            ((ItemListener)listeners[i + 1]).itemStateChanged(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ModeListener
    implements ItemListener {
        ModeListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            EditingModalGraphMouse.this.setMode((ModalGraphMouse.Mode)e.getItem());
        }
    }
}

