/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.VertexShapeFunction;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.utils.TestGraphs;
import edu.uci.ics.jung.visualization.AbstractLayout;
import edu.uci.ics.jung.visualization.DefaultSettableVertexLocationFunction;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layout;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.StaticLayout;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.LayoutScalingControl;
import edu.uci.ics.jung.visualization.control.LensMagnificationGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.LayoutLensSupport;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.MagnifyTransformer;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.MagnifyShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ViewLensSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LensDemo
extends JApplet {
    Graph graph = TestGraphs.getOneComponentGraph();
    Layout graphLayout;
    Graph grid;
    Layout gridLayout;
    VisualizationViewer vv;
    LensSupport hyperbolicViewSupport;
    LensSupport magnifyViewSupport;
    LensSupport hyperbolicLayoutSupport;
    LensSupport magnifyLayoutSupport;
    ScalingControl scaler;

    public LensDemo() {
        final PluggableRenderer pr = new PluggableRenderer();
        this.graphLayout = new FRLayout(this.graph);
        ((FRLayout)this.graphLayout).setMaxIterations(1000);
        Dimension preferredSize = new Dimension(400, 400);
        DefaultSettableVertexLocationFunction vlf = new DefaultSettableVertexLocationFunction();
        this.grid = this.generateVertexGrid(vlf, preferredSize, 25);
        this.gridLayout = new StaticLayout(this.grid);
        ((AbstractLayout)this.gridLayout).initialize(preferredSize, vlf);
        final DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.graphLayout, preferredSize);
        this.vv = new VisualizationViewer(visualizationModel, (Renderer)pr, preferredSize);
        this.vv.setPickSupport(new ShapePickSupport());
        pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
        PickedState ps = this.vv.getPickedState();
        pr.setEdgePaintFunction(new PickableEdgePaintFunction(ps, Color.black, Color.red));
        this.vv.setBackground(Color.white);
        final VertexShapeFunction ovals = pr.getVertexShapeFunction();
        final VertexShapeFunction squares = new VertexShapeFunction(){

            public Shape getShape(Vertex v) {
                return new Rectangle2D.Float(-10.0f, -10.0f, 20.0f, 20.0f);
            }
        };
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add(gzsp);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.hyperbolicViewSupport = new ViewLensSupport(this.vv, new HyperbolicShapeTransformer(this.vv), new ModalLensGraphMouse());
        this.hyperbolicLayoutSupport = new LayoutLensSupport(this.vv, new HyperbolicTransformer(this.vv, this.vv.getLayoutTransformer()), new ModalLensGraphMouse());
        this.magnifyViewSupport = new ViewLensSupport(this.vv, new MagnifyShapeTransformer(this.vv), new ModalLensGraphMouse(new LensMagnificationGraphMousePlugin(1.0f, 6.0f, 0.2f)));
        this.magnifyLayoutSupport = new LayoutLensSupport(this.vv, new MagnifyTransformer(this.vv, this.vv.getLayoutTransformer()), new ModalLensGraphMouse(new LensMagnificationGraphMousePlugin(1.0f, 6.0f, 0.2f)));
        this.hyperbolicLayoutSupport.getLensTransformer().setEllipse(this.hyperbolicViewSupport.getLensTransformer().getEllipse());
        this.magnifyViewSupport.getLensTransformer().setEllipse(this.hyperbolicLayoutSupport.getLensTransformer().getEllipse());
        this.magnifyLayoutSupport.getLensTransformer().setEllipse(this.magnifyViewSupport.getLensTransformer().getEllipse());
        final CrossoverScalingControl crossoverScaler = new CrossoverScalingControl();
        final LayoutScalingControl layoutScaler = new LayoutScalingControl();
        this.scaler = crossoverScaler;
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LensDemo.this.scaler.scale(LensDemo.this.vv, 1.1f, LensDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LensDemo.this.scaler.scale(LensDemo.this.vv, 0.9090909f, LensDemo.this.vv.getCenter());
            }
        });
        ButtonGroup radio = new ButtonGroup();
        JRadioButton normal = new JRadioButton("None");
        normal.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (LensDemo.this.hyperbolicViewSupport != null) {
                        LensDemo.this.hyperbolicViewSupport.deactivate();
                    }
                    if (LensDemo.this.hyperbolicLayoutSupport != null) {
                        LensDemo.this.hyperbolicLayoutSupport.deactivate();
                    }
                    if (LensDemo.this.magnifyViewSupport != null) {
                        LensDemo.this.magnifyViewSupport.deactivate();
                    }
                    if (LensDemo.this.magnifyLayoutSupport != null) {
                        LensDemo.this.magnifyLayoutSupport.deactivate();
                    }
                    LensDemo.this.scaler = crossoverScaler;
                }
            }
        });
        JRadioButton hyperView = new JRadioButton("Hyperbolic View");
        hyperView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LensDemo.this.hyperbolicViewSupport.activate(e.getStateChange() == 1);
                LensDemo.this.scaler = layoutScaler;
            }
        });
        JRadioButton hyperModel = new JRadioButton("Hyperbolic Layout");
        hyperModel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LensDemo.this.hyperbolicLayoutSupport.activate(e.getStateChange() == 1);
                LensDemo.this.scaler = layoutScaler;
            }
        });
        JRadioButton magnifyView = new JRadioButton("Magnified View");
        magnifyView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LensDemo.this.magnifyViewSupport.activate(e.getStateChange() == 1);
                LensDemo.this.scaler = layoutScaler;
            }
        });
        JRadioButton magnifyModel = new JRadioButton("Magnified Layout");
        magnifyModel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                LensDemo.this.magnifyLayoutSupport.activate(e.getStateChange() == 1);
                LensDemo.this.scaler = layoutScaler;
            }
        });
        radio.add(normal);
        radio.add(hyperModel);
        radio.add(hyperView);
        radio.add(magnifyModel);
        radio.add(magnifyView);
        normal.setSelected(true);
        graphMouse.addItemListener(this.hyperbolicLayoutSupport.getGraphMouse().getModeListener());
        graphMouse.addItemListener(this.hyperbolicViewSupport.getGraphMouse().getModeListener());
        graphMouse.addItemListener(this.magnifyLayoutSupport.getGraphMouse().getModeListener());
        graphMouse.addItemListener(this.magnifyViewSupport.getGraphMouse().getModeListener());
        ButtonGroup graphRadio = new ButtonGroup();
        JRadioButton graphButton = new JRadioButton("Graph");
        graphButton.setSelected(true);
        graphButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    visualizationModel.setGraphLayout(LensDemo.this.graphLayout);
                    pr.setVertexShapeFunction(ovals);
                    LensDemo.this.vv.repaint();
                }
            }
        });
        JRadioButton gridButton = new JRadioButton("Grid");
        gridButton.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    visualizationModel.setGraphLayout(LensDemo.this.gridLayout);
                    pr.setVertexShapeFunction(squares);
                    LensDemo.this.vv.repaint();
                }
            }
        });
        graphRadio.add(graphButton);
        graphRadio.add(gridButton);
        JPanel modePanel = new JPanel(new GridLayout(2, 1));
        modePanel.setBorder(BorderFactory.createTitledBorder("Display"));
        modePanel.add(graphButton);
        modePanel.add(gridButton);
        JMenuBar menubar = new JMenuBar();
        menubar.add(graphMouse.getModeMenu());
        gzsp.setCorner(menubar);
        JPanel controls = new JPanel();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel hyperControls = new JPanel(new GridLayout(3, 2));
        hyperControls.setBorder(BorderFactory.createTitledBorder("Examiner Lens"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        hyperControls.add(normal);
        hyperControls.add(new JLabel());
        hyperControls.add(hyperModel);
        hyperControls.add(magnifyModel);
        hyperControls.add(hyperView);
        hyperControls.add(magnifyView);
        controls.add(zoomControls);
        controls.add(hyperControls);
        controls.add(modePanel);
        content.add((Component)controls, "South");
    }

    private Graph generateVertexGrid(DefaultSettableVertexLocationFunction vlf, Dimension d, int interval) {
        int count = d.width / interval * d.height / interval;
        SparseGraph graph = new SparseGraph();
        Vertex[] v = new Vertex[count];
        for (int i = 0; i < count; ++i) {
            int x = interval * i;
            int y = x / d.width * interval;
            Point2D.Float location = new Point2D.Float(x %= d.width, y);
            SparseVertex vertex = new SparseVertex();
            vlf.setLocation(vertex, location);
            v[i] = graph.addVertex(vertex);
        }
        return graph;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new LensDemo());
        f.pack();
        f.setVisible(true);
    }
}

