/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.algorithms.connectivity.BFSDistanceLabeler;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.AbstractEdgePaintFunction;
import edu.uci.ics.jung.graph.decorators.EdgeStrokeFunction;
import edu.uci.ics.jung.graph.decorators.StringLabeller;
import edu.uci.ics.jung.graph.decorators.VertexPaintFunction;
import edu.uci.ics.jung.random.generators.EppsteinPowerLawGenerator;
import edu.uci.ics.jung.utils.GraphUtils;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ShortestPathDemo
extends JPanel {
    private Vertex mFrom;
    private Vertex mTo;
    private Graph mGraph;
    private Set mPred;

    boolean isBlessed(Edge e) {
        Vertex v1 = (Vertex)e.getEndpoints().getFirst();
        Vertex v2 = (Vertex)e.getEndpoints().getSecond();
        return this.mPred.contains(v1) && this.mPred.contains(v2);
    }

    public ShortestPathDemo(Graph g) {
        this.mGraph = g;
        this.setBackground(Color.WHITE);
        final FRLayout layout = new FRLayout(g);
        final PluggableRenderer pr = new PluggableRenderer();
        final VisualizationViewer vv = new VisualizationViewer(layout, (Renderer)pr);
        vv.setBackground(Color.WHITE);
        pr.setVertexPaintFunction(new MyVertexPaintFunction());
        pr.setEdgePaintFunction(new MyEdgePaintFunction());
        pr.setEdgeStrokeFunction(new MyEdgeStrokeFunction());
        pr.setVertexStringer(StringLabeller.getLabeller(this.mGraph));
        vv.setPickSupport(new ShapePickSupport());
        vv.setGraphMouse(new DefaultModalGraphMouse());
        vv.addPostRenderPaintable(new VisualizationViewer.Paintable(){

            public boolean useTransform() {
                return true;
            }

            public void paint(Graphics g) {
                if (ShortestPathDemo.this.mPred == null) {
                    return;
                }
                Graphics2D g2d = (Graphics2D)g;
                Iterator iter = layout.getGraph().getEdges().iterator();
                while (iter.hasNext()) {
                    Edge e = (Edge)iter.next();
                    if (!ShortestPathDemo.this.isBlessed(e)) continue;
                    Vertex v1 = (Vertex)e.getEndpoints().getFirst();
                    Vertex v2 = (Vertex)e.getEndpoints().getSecond();
                    Point2D p1 = layout.getLocation(v1);
                    Point2D p2 = layout.getLocation(v2);
                    p1 = vv.layoutTransform(p1);
                    p2 = vv.layoutTransform(p2);
                    pr.paintEdge(g2d, e, (int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)vv, "Center");
        this.add((Component)this.setUpControls(), "South");
    }

    private JPanel setUpControls() {
        JPanel jp = new JPanel();
        jp.setBackground(Color.WHITE);
        jp.setLayout(new BoxLayout(jp, 3));
        jp.setBorder(BorderFactory.createLineBorder(Color.black, 3));
        jp.add(new JLabel("Select a pair of vertices for which a shortest path will be displayed"));
        JPanel jp2 = new JPanel();
        jp2.add(new JLabel("vertex from", 2));
        jp2.add(this.getSelectionBox(true));
        jp2.setBackground(Color.white);
        JPanel jp3 = new JPanel();
        jp3.add(new JLabel("vertex to", 2));
        jp3.add(this.getSelectionBox(false));
        jp3.setBackground(Color.white);
        jp.add(jp2);
        jp.add(jp3);
        return jp;
    }

    private Component getSelectionBox(final boolean from) {
        StringLabeller sl = StringLabeller.getLabeller(this.mGraph);
        TreeSet<String> s = new TreeSet<String>();
        Iterator iter = this.mGraph.getVertices().iterator();
        while (iter.hasNext()) {
            s.add(sl.getLabel((Vertex)iter.next()));
        }
        final JComboBox<Object> choices = new JComboBox<Object>(s.toArray());
        choices.setSelectedIndex(-1);
        choices.setBackground(Color.WHITE);
        choices.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StringLabeller sl = StringLabeller.getLabeller(ShortestPathDemo.this.mGraph);
                Vertex v = sl.getVertex((String)choices.getSelectedItem());
                if (from) {
                    ShortestPathDemo.this.mFrom = v;
                } else {
                    ShortestPathDemo.this.mTo = v;
                }
                ShortestPathDemo.this.drawShortest();
                ShortestPathDemo.this.repaint();
            }
        });
        return choices;
    }

    protected void drawShortest() {
        if (this.mFrom == null || this.mTo == null) {
            return;
        }
        BFSDistanceLabeler bdl = new BFSDistanceLabeler();
        bdl.labelDistances(this.mGraph, this.mFrom);
        this.mPred = new HashSet();
        StringLabeller sl = StringLabeller.getLabeller(this.mGraph);
        Vertex v = this.mTo;
        Set prd = bdl.getPredecessors(v);
        this.mPred.add(this.mTo);
        while (prd != null && prd.size() > 0) {
            Iterator iter = prd.iterator();
            while (iter.hasNext()) {
                Vertex x = (Vertex)iter.next();
            }
            v = (Vertex)prd.iterator().next();
            this.mPred.add(v);
            if (v == this.mFrom) {
                return;
            }
            prd = bdl.getPredecessors(v);
        }
    }

    public static void main(String[] s) {
        Graph g = ShortestPathDemo.getGraph();
        JFrame jf = new JFrame();
        jf.setDefaultCloseOperation(3);
        jf.getContentPane().add(new ShortestPathDemo(g));
        jf.pack();
        jf.setVisible(true);
    }

    static Graph getGraph() {
        Graph g = (Graph)new EppsteinPowerLawGenerator(26, 50, 50).generateGraph();
        HashSet<Vertex> removeMe = new HashSet<Vertex>();
        Iterator iter = g.getVertices().iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            if (v.degree() != 0) continue;
            removeMe.add(v);
        }
        GraphUtils.removeVertices(g, removeMe);
        StringLabeller sl = StringLabeller.getLabeller(g);
        int c = 0;
        Iterator iter2 = g.getVertices().iterator();
        while (iter2.hasNext()) {
            Vertex v = (Vertex)iter2.next();
            try {
                sl.setLabel(v, "" + (char)(c + 97));
            }
            catch (StringLabeller.UniqueLabelException e) {
                // empty catch block
            }
            c = (char)(c + 1);
        }
        return g;
    }

    public class MyVertexPaintFunction
    implements VertexPaintFunction {
        public Paint getDrawPaint(Vertex v) {
            return Color.black;
        }

        public Paint getFillPaint(Vertex v) {
            if (v == ShortestPathDemo.this.mFrom) {
                return Color.BLUE;
            }
            if (v == ShortestPathDemo.this.mTo) {
                return Color.BLUE;
            }
            if (ShortestPathDemo.this.mPred == null) {
                return Color.LIGHT_GRAY;
            }
            if (ShortestPathDemo.this.mPred.contains(v)) {
                return Color.RED;
            }
            return Color.LIGHT_GRAY;
        }
    }

    public class MyEdgeStrokeFunction
    implements EdgeStrokeFunction {
        protected final Stroke THIN = new BasicStroke(1.0f);
        protected final Stroke THICK = new BasicStroke(1.0f);

        public Stroke getStroke(Edge e) {
            if (ShortestPathDemo.this.mPred == null || ShortestPathDemo.this.mPred.size() == 0) {
                return this.THIN;
            }
            if (ShortestPathDemo.this.isBlessed(e)) {
                return this.THICK;
            }
            return this.THIN;
        }
    }

    public class MyEdgePaintFunction
    extends AbstractEdgePaintFunction {
        public Paint getDrawPaint(Edge e) {
            if (ShortestPathDemo.this.mPred == null || ShortestPathDemo.this.mPred.size() == 0) {
                return Color.BLACK;
            }
            if (ShortestPathDemo.this.isBlessed(e)) {
                return new Color(0.0f, 0.0f, 1.0f, 0.5f);
            }
            return Color.LIGHT_GRAY;
        }
    }
}

