/*
 * Decompiled with CFR 0.152.
 */
package samples.preview_new_graphdraw.iter;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import samples.preview_new_graphdraw.VisEdge;
import samples.preview_new_graphdraw.VisVertex;
import samples.preview_new_graphdraw.iter.IterableLayout;

public abstract class UpdatableIterableLayout
extends IterableLayout {
    public void updateGraphToMatch(Graph g) {
        Pair oldAndNewVertices = UpdatableIterableLayout.getSymmetricDifference(this.currentLayout.visVertexMap.keySet(), g.getVertices());
        Pair oldAndNewEdges = UpdatableIterableLayout.getSymmetricDifference(this.currentLayout.visEdgeMap.keySet(), g.getEdges());
        this.updateGraph(oldAndNewVertices, oldAndNewEdges);
    }

    protected void cleanupReferences(Graph g) {
        Iterator iter = this.currentLayout.visVertexMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry vertexEntry = iter.next();
            Vertex v = (Vertex)vertexEntry.getKey();
            if (v.getGraph() == g) continue;
            this.currentLayout.visVertexMap.remove(v);
            this.currentLayout.visVertexMap.put(v.getEqualVertex(g), vertexEntry.getValue());
        }
        iter = this.currentLayout.visEdgeMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry edgeEntry = iter.next();
            Edge e = (Edge)edgeEntry.getKey();
            if (e.getGraph() == g) continue;
            this.currentLayout.visEdgeMap.remove(e);
            this.currentLayout.visEdgeMap.put(e.getEqualEdge(g), edgeEntry.getValue());
        }
    }

    protected void updateGraph(Pair oldAndNewVertices, Pair oldAndNewEdges) {
        Edge e;
        Vertex v;
        Collection oldVertices = (Collection)oldAndNewVertices.getFirst();
        Collection newVertices = (Collection)oldAndNewVertices.getSecond();
        Iterator iter = oldVertices.iterator();
        while (iter.hasNext()) {
            v = (Vertex)iter.next();
            this.removeVertex(v);
        }
        iter = newVertices.iterator();
        while (iter.hasNext()) {
            v = (Vertex)iter.next();
            this.currentLayout.visVertexMap.put(v, this.addVisVertex(v));
        }
        Collection oldEdges = (Collection)oldAndNewEdges.getFirst();
        Collection newEdges = (Collection)oldAndNewEdges.getSecond();
        Iterator iter2 = oldEdges.iterator();
        while (iter2.hasNext()) {
            e = (Edge)iter2.next();
            this.removeEdge(e);
        }
        iter2 = newEdges.iterator();
        while (iter2.hasNext()) {
            e = (Edge)iter2.next();
            this.currentLayout.visEdgeMap.put(e, this.addVisEdge(e));
        }
    }

    protected void removeVertex(Vertex v) {
        this.currentLayout.visVertexMap.remove(v);
    }

    protected void removeEdge(Edge e) {
        this.currentLayout.visEdgeMap.remove(e);
    }

    protected VisEdge addVisEdge(Edge e) {
        Pair p = e.getEndpoints();
        Vertex v1 = (Vertex)p.getFirst();
        Vertex v2 = (Vertex)p.getSecond();
        VisVertex vv1 = this.currentLayout.getVisVertex(v1);
        VisVertex vv2 = this.currentLayout.getVisVertex(v2);
        System.out.println("New visedge for " + e);
        return new VisEdge(e, vv1, vv2);
    }

    protected VisVertex addVisVertex(Vertex v) {
        double x = Math.random() * this.currentLayout.getScreenSize().getWidth();
        double y = Math.random() * this.currentLayout.getScreenSize().getHeight();
        VisVertex vv = new VisVertex(v, x, y);
        System.out.println("New vertex " + v + " at " + x + " " + y);
        return vv;
    }

    public static Pair getSymmetricDifference(Set set1, Set set2) {
        Collection old = CollectionUtils.subtract((Collection)set1, (Collection)set2);
        Collection newP = CollectionUtils.subtract((Collection)set2, (Collection)set1);
        return new Pair(old, newP);
    }
}

