/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JRI;

public class Mutex {
    public static boolean verbose = false;
    private boolean locked = false;
    private Thread lockedBy = null;

    public synchronized void lock() {
        while (this.locked) {
            if (this.lockedBy == Thread.currentThread()) {
                System.err.println("FATAL ERROR: org.rosuda.JRI.Mutex detected a deadlock! The application is likely to hang indefinitely!");
            }
            if (verbose) {
                System.out.println("INFO: " + this.toString() + " is locked by " + String.valueOf(this.lockedBy) + ", but " + String.valueOf(Thread.currentThread()) + " waits for release (no timeout)");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (!verbose) continue;
                System.out.println("INFO: " + this.toString() + " caught InterruptedException");
            }
        }
        this.locked = true;
        this.lockedBy = Thread.currentThread();
        if (verbose) {
            System.out.println("INFO: " + this.toString() + " locked by " + String.valueOf(this.lockedBy));
        }
    }

    public synchronized boolean lockWithTimeout(long l) {
        block8: {
            if (this.locked) {
                if (this.lockedBy == Thread.currentThread()) {
                    System.err.println("FATAL ERROR: org.rosuda.JRI.Mutex detected a deadlock! The application is likely to hang indefinitely!");
                }
                if (verbose) {
                    System.out.println("INFO: " + this.toString() + " is locked by " + String.valueOf(this.lockedBy) + ", but " + String.valueOf(Thread.currentThread()) + " waits for release (timeout " + l + " ms)");
                }
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    if (!verbose) break block8;
                    System.out.println("INFO: " + this.toString() + " caught InterruptedException");
                }
            }
        }
        if (!this.locked) {
            this.locked = true;
            this.lockedBy = Thread.currentThread();
            if (verbose) {
                System.out.println("INFO: " + this.toString() + " locked by " + String.valueOf(this.lockedBy));
            }
            return true;
        }
        if (verbose) {
            System.out.println("INFO: " + this.toString() + " timeout, failed to obtain lock for " + String.valueOf(Thread.currentThread()));
        }
        return false;
    }

    public synchronized int tryLock() {
        if (verbose) {
            System.out.println("INFO: " + this.toString() + " tryLock by " + String.valueOf(Thread.currentThread()));
        }
        if (this.locked) {
            return this.lockedBy == Thread.currentThread() ? -1 : 1;
        }
        this.locked = true;
        this.lockedBy = Thread.currentThread();
        if (verbose) {
            System.out.println("INFO: " + this.toString() + " locked by " + String.valueOf(this.lockedBy));
        }
        return 0;
    }

    public synchronized boolean safeLock() {
        if (this.locked && this.lockedBy == Thread.currentThread()) {
            if (verbose) {
                System.out.println("INFO: " + this.toString() + " unable to provide safe lock for " + String.valueOf(Thread.currentThread()));
            }
            return false;
        }
        this.lock();
        return true;
    }

    public synchronized boolean safeLockWithTimeout(long l) {
        if (this.locked && this.lockedBy == Thread.currentThread()) {
            if (verbose) {
                System.out.println("INFO: " + this.toString() + " unable to provide safe lock (deadlock detected) for " + String.valueOf(Thread.currentThread()));
            }
            return false;
        }
        return this.lockWithTimeout(l);
    }

    public synchronized void unlock() {
        if (this.locked && this.lockedBy != Thread.currentThread()) {
            System.err.println("WARNING: org.rosuda.JRI.Mutex was unlocked by other thread than locked! This may soon lead to a crash...");
        }
        this.locked = false;
        if (verbose) {
            System.out.println("INFO: " + this.toString() + " unlocked by " + String.valueOf(Thread.currentThread()));
        }
        this.notify();
    }

    public String toString() {
        return super.toString() + "[" + (this.locked ? "" : "un") + "locked" + (String)(!this.locked ? "" : ", by " + (this.lockedBy == Thread.currentThread() ? "current" : "another") + " thread") + "]";
    }
}

