/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPRaw;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REXPWrapper;
import org.rosuda.REngine.REngineCallbacks;
import org.rosuda.REngine.REngineException;

public abstract class REngine {
    protected static REngine lastEngine = null;

    public static REngine engineForClass(String string) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        if (clazz == null) {
            throw new ClassNotFoundException("can't find engine class " + string);
        }
        Method method = clazz.getMethod("createEngine", null);
        Object object = method.invoke(null, (Object[])null);
        lastEngine = (REngine)object;
        return lastEngine;
    }

    public static REngine engineForClass(String string, String[] stringArray, REngineCallbacks rEngineCallbacks, boolean bl) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        if (clazz == null) {
            throw new ClassNotFoundException("can't find engine class " + string);
        }
        Method method = clazz.getMethod("createEngine", String[].class, REngineCallbacks.class, Boolean.TYPE);
        Object object = method.invoke(null, stringArray, rEngineCallbacks, new Boolean(bl));
        lastEngine = (REngine)object;
        return lastEngine;
    }

    public static REngine getLastEngine() {
        return lastEngine;
    }

    public abstract REXP parse(String var1, boolean var2) throws REngineException;

    public abstract REXP eval(REXP var1, REXP var2, boolean var3) throws REngineException, REXPMismatchException;

    public abstract void assign(String var1, REXP var2, REXP var3) throws REngineException, REXPMismatchException;

    public abstract REXP get(String var1, REXP var2, boolean var3) throws REngineException, REXPMismatchException;

    public abstract REXP resolveReference(REXP var1) throws REngineException, REXPMismatchException;

    public abstract REXP createReference(REXP var1) throws REngineException, REXPMismatchException;

    public abstract void finalizeReference(REXP var1) throws REngineException, REXPMismatchException;

    public abstract REXP getParentEnvironment(REXP var1, boolean var2) throws REngineException, REXPMismatchException;

    public abstract REXP newEnvironment(REXP var1, boolean var2) throws REngineException, REXPMismatchException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REXP parseAndEval(String string, REXP rEXP, boolean bl) throws REngineException, REXPMismatchException {
        REXP rEXP2 = null;
        try {
            rEXP2 = this.parse(string, false);
            REXP rEXP3 = this.eval(rEXP2, rEXP, bl);
            return rEXP3;
        }
        finally {
            if (rEXP2 instanceof REXPReference) {
                ((REXPReference)rEXP2).release();
            }
        }
    }

    public REXP parseAndEval(String string) throws REngineException, REXPMismatchException {
        return this.parseAndEval(string, null, true);
    }

    public boolean close() {
        return false;
    }

    public boolean supportsReferences() {
        return false;
    }

    public boolean supportsEnvironments() {
        return false;
    }

    public boolean supportsREPL() {
        return false;
    }

    public boolean supportsLocking() {
        return false;
    }

    public void assign(String string, double[] dArray) throws REngineException {
        try {
            this.assign(string, new REXPDouble(dArray), null);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this, "REXPMismatchException in assign(,double[]): " + String.valueOf(rEXPMismatchException));
        }
    }

    public void assign(String string, int[] nArray) throws REngineException {
        try {
            this.assign(string, new REXPInteger(nArray), null);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this, "REXPMismatchException in assign(,int[]): " + String.valueOf(rEXPMismatchException));
        }
    }

    public void assign(String string, String[] stringArray) throws REngineException {
        try {
            this.assign(string, new REXPString(stringArray), null);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this, "REXPMismatchException in assign(,String[]): " + String.valueOf(rEXPMismatchException));
        }
    }

    public void assign(String string, byte[] byArray) throws REngineException {
        try {
            this.assign(string, new REXPRaw(byArray), null);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this, "REXPMismatchException in assign(,byte[]): " + String.valueOf(rEXPMismatchException));
        }
    }

    public void assign(String string, String string2) throws REngineException {
        try {
            this.assign(string, new REXPString(string2), null);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new REngineException(this, "REXPMismatchException in assign(,String[]): " + String.valueOf(rEXPMismatchException));
        }
    }

    public void assign(String string, REXP rEXP) throws REngineException, REXPMismatchException {
        this.assign(string, rEXP, null);
    }

    public synchronized int tryLock() {
        return 0;
    }

    public synchronized int lock() {
        return 0;
    }

    public synchronized void unlock(int n) {
    }

    public String toString() {
        return super.toString() + (lastEngine == this ? "{last}" : "");
    }

    public REXP wrap(Object object) {
        return REXPWrapper.wrap(object);
    }
}

