
namespace java com.ef_prime.rflow.core.app.r.base

service AppRpcInterface {
    
	/**
	 * RMainLoopCallbacks
	 */
	 
    oneway void rWriteConsole(1:string text, 2:i32 oType),
    
    oneway void rBusy(1:i32 which),
    
    oneway void rReadConsole(1:string prompt, 2:i32 addToHistory),
    
    oneway void rShowMessage(1:string message),
    
    oneway void rChooseFile(1:i32 newFile),
    
    oneway void rFlushConsole(),
    
    oneway void rSaveHistory(1:string fileName),
    
    oneway void rLoadHistory(1:string fileName),
	
	/**
	 * RJavaInterface
	 */
	 
	i32 canBrowse(),
	
	void setFrame(1:i32 which),
	
	i32 selectFrame(),
	
	oneway void pager(1:string file, 2:string header, 3:string title, 4:bool deleteFile),
	
	oneway void browser(1:string url, 2:bool isRHelp),
	
	oneway void view(1:string command, 2:string id),
	
	i32 state(),
	
	oneway void packageStatus(1:string pkgName, 2:bool attached),
	
	/**
	 * Graphic Device
	 */
	 
	list<i32> openDevice(1:double w, 2:double h),
	
	oneway void createGD(1:i32 id),
	
	oneway void gdOpen(1:i32 id, 2:double w, 3:double h),
	
	oneway void gdActivate(1:i32 id),
	
	oneway void gdCircle(1:i32 id, 2:double x, 3:double y, 4:double r),
	
	oneway void gdClip(1:i32 id, 2:double x0, 3:double x1, 4:double y0, 5:double y1),
	
	oneway void gdClose(1:i32 id),
	
	oneway void gdDeactivate(1:i32 id),
	
	oneway void gdHold(1:i32 id),
	
	oneway void gdFlush(1:i32 id, 2:bool flush),
	
	oneway void gdLocator(1:i32 id),
	
	oneway void gdLine(1:i32 id, 2:double x1, 3:double y1, 4:double x2, 5:double y2),
	
	list<double> gdMetricInfo(1:i32 id, 2:i32 ch),
	
	oneway void gdMode(1:i32 id, 2:i32 mode),
	
	oneway void gdNewPageOld(1:i32 id),
	
	oneway void gdNewPage(1:i32 id, 2:i32 devNr),
	
	oneway void gdPath(1:i32 id, 2:i32 npoly, 3:list<i32> nper, 4:list<double> x, 5:list<double> y, 6:bool winding),
	
	oneway void gdPolygon(1:i32 id, 2:i32 n, 3:list<double> x, 4:list<double> y),
	
	oneway void gdPolyline(1:i32 id, 2:i32 n, 3:list<double> x, 4:list<double> y),
	
	oneway void gdRect(1:i32 id, 2:double x0, 3:double y0, 4:double x1, 5:double y1),
	
	oneway void gdRaster(1:i32 id, 2:binary img, 3:i32 img_w, 4:i32 img_h, 5:double x, 6:double y,
			7:double w, 8:double h, 9:double rot, 10:bool interpolate),
	
	list<double> gdSize(1:i32 id),
	
	double gdStrWidth(1:i32 id, 2:string str),
	
	oneway void gdText(1:i32 id, 2:double x, 3:double y, 4:string str, 5:double rot,
			6:double hadj),
			
	oneway void gdcSetColor(1:i32 id, 2:i32 cc),
	
	oneway void gdcSetFill(1:i32 id, 2:i32 cc),
	
	oneway void gdcSetLine(1:i32 id, 2:double lwd, 3:i32 lty),
	
	oneway void gdcSetFont(1:i32 id, 2:double cex, 3:double ps, 4:double lineheight,
			5:i32 fontface, 6:string fontfamily)
	
}